/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.preprocessing.IdTagging;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trend
extends OperatorChain {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    public static final String PARAMETER_KEEP_ORIGINAL_ATTRIBUTE = "keep_original_attribute";

    public Trend(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        ExampleSet trendSet = (ExampleSet)exampleSet.clone();
        Attribute attribute = trendSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE));
        Iterator<Attribute> iterator22 = trendSet.getAttributes().iterator();
        while (iterator22.hasNext()) {
            Attribute currentAttribute = iterator22.next();
            if (attribute.equals(currentAttribute)) continue;
            iterator22.remove();
        }
        try {
            trendSet = OperatorService.createOperator(IdTagging.class).apply(new IOContainer(trendSet)).get(ExampleSet.class);
        }
        catch (OperatorCreationException iterator22) {
            // empty catch block
        }
        trendSet.getAttributes().setLabel(attribute);
        Attribute id = trendSet.getAttributes().getId();
        trendSet.getAttributes().setId(null);
        trendSet.getAttributes().addRegular(id);
        Model model = this.getOperator(0).apply(new IOContainer(trendSet)).get(Model.class);
        model.apply(trendSet);
        Attribute trendAttribute = trendSet.getAttributes().getPredictedLabel();
        trendAttribute.setName("trend(" + attribute.getName() + ")");
        exampleSet.getAttributes().addRegular(trendAttribute);
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(attribute);
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE, "The attribute for which the trend should be added.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE, "Indicates whether the original attribute should be kept in the data set.", true));
        return types;
    }
}

