/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.ConfigurationWizardCreator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterTypeConfiguration
extends ParameterType {
    private static final long serialVersionUID = -3512071671355815277L;
    private Class<? extends ConfigurationWizardCreator> wizardCreatorClass;
    private transient ConfigurationListener wizardListener;
    private Map<String, String> parameters = null;

    public ParameterTypeConfiguration(Class<? extends ConfigurationWizardCreator> wizardCreatorClass, ConfigurationListener wizardListener) {
        this(wizardCreatorClass, null, wizardListener);
    }

    public ParameterTypeConfiguration(Class<? extends ConfigurationWizardCreator> wizardCreatorClass, Map<String, String> parameters, ConfigurationListener wizardListener) {
        super("configure_operator", "Configure this operator by means of a Wizard.");
        this.wizardCreatorClass = wizardCreatorClass;
        this.parameters = parameters;
        this.wizardListener = wizardListener;
    }

    public ConfigurationWizardCreator getWizardCreator() {
        ConfigurationWizardCreator creator = null;
        try {
            creator = this.wizardCreatorClass.newInstance();
            creator.setParameters(this.parameters);
        }
        catch (InstantiationException e) {
            LogService.getGlobal().log("Problem during creation of wizard: " + e.getMessage(), 5);
        }
        catch (IllegalAccessException e) {
            LogService.getGlobal().log("Problem during creation of wizard: " + e.getMessage(), 5);
        }
        return creator;
    }

    public ConfigurationListener getWizardListener() {
        return this.wizardListener;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public void setDefaultValue(Object value) {
    }

    @Override
    public String getRange() {
        return null;
    }

    @Override
    public String getXML(String indent, String key, String value, boolean hideDefault) {
        return "";
    }

    @Override
    public boolean isNumerical() {
        return false;
    }
}

