/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.MailSenderSMTP;
import com.rapidminer.tools.MailSenderSendmail;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ResourceSource;
import com.rapidminer.tools.TimeFormat;
import com.rapidminer.tools.plugin.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final double IS_ZERO = 1.0E-6;
    private static final double IS_DISPLAY_ZERO = 1.0E-8;
    private static final TimeFormat DURATION_TIME_FORMAT = new TimeFormat();
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(1, Locale.getDefault());
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(2, Locale.getDefault());
    private static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private static NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance(Locale.US);
    private static final DecimalFormatSymbols FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final LinkedList<ResourceSource> ALL_RESOURCES = new LinkedList();
    public static final String RESOURCE_PREFIX = "com/rapidminer/resources/";
    public static String[] availableTimeZoneNames;
    public static final int SYSTEM_TIME_ZONE = 0;
    public static final String[] TRUE_STRINGS;
    public static final String[] FALSE_STRINGS;

    static {
        ALL_RESOURCES.add(new ResourceSource(Tools.class.getClassLoader()));
        Object[] allTimeZoneNames = TimeZone.getAvailableIDs();
        Arrays.sort(allTimeZoneNames);
        availableTimeZoneNames = new String[allTimeZoneNames.length + 1];
        Tools.availableTimeZoneNames[0] = "SYSTEM";
        System.arraycopy(allTimeZoneNames, 0, availableTimeZoneNames, 1, allTimeZoneNames.length);
        TRUE_STRINGS = new String[]{"true", "on", "yes", "y"};
        FALSE_STRINGS = new String[]{"false", "off", "no", "n"};
    }

    public static void setFormatLocale(Locale locale) {
        NUMBER_FORMAT = NumberFormat.getInstance(locale);
        PERCENT_FORMAT = NumberFormat.getPercentInstance(locale);
    }

    public static String[] getAllTimeZones() {
        return availableTimeZoneNames;
    }

    public static TimeZone getTimeZone(int index) {
        if (index == 0) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(availableTimeZoneNames[index]);
    }

    public static TimeZone getPreferredTimeZone() {
        return Tools.getTimeZone(Tools.getPreferredTimeZoneIndex());
    }

    /*
     * Unable to fully structure code
     */
    public static int getPreferredTimeZoneIndex() {
        block6: {
            timeZoneString = System.getProperty("rapidminer.general.timezone");
            preferredTimeZone = 0;
            try {
                if (timeZoneString != null) {
                    preferredTimeZone = Integer.parseInt(timeZoneString);
                }
                break block6;
            }
            catch (NumberFormatException e) {
                index = 0;
                found = false;
                var8_5 = Tools.availableTimeZoneNames;
                var7_6 = Tools.availableTimeZoneNames.length;
                var6_7 = 0;
                ** while (var6_7 < var7_6)
            }
lbl-1000:
            // 1 sources

            {
                id = var8_5[var6_7];
                if (id.equals(timeZoneString)) {
                    found = true;
                    break;
                }
                ++index;
                ++var6_7;
                continue;
            }
lbl21:
            // 2 sources

            if (found) {
                preferredTimeZone = index;
            }
        }
        return preferredTimeZone;
    }

    public static Calendar getPreferredCalendar() {
        return GregorianCalendar.getInstance(Tools.getPreferredTimeZone(), Locale.getDefault());
    }

    public static String formatPercent(double value) {
        if (Double.isNaN(value)) {
            return "?";
        }
        String percentDigitsString = System.getProperty("rapidminer.general.fractiondigits.percent");
        int percentDigits = 2;
        try {
            if (percentDigitsString != null) {
                percentDigits = Integer.parseInt(percentDigitsString);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Bad integer for property 'rapidminer.gui.fractiondigits.percent', using default number if digits (2).", 5);
        }
        PERCENT_FORMAT.setMaximumFractionDigits(percentDigits);
        PERCENT_FORMAT.setMinimumFractionDigits(percentDigits);
        return PERCENT_FORMAT.format(value);
    }

    public static String formatNumber(double value) {
        if (Double.isNaN(value)) {
            return "?";
        }
        int numberDigits = 3;
        try {
            String numberDigitsString = System.getProperty("rapidminer.general.fractiondigits.numbers");
            numberDigits = Integer.parseInt(numberDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        NUMBER_FORMAT.setMaximumFractionDigits(numberDigits);
        NUMBER_FORMAT.setMinimumFractionDigits(numberDigits);
        return NUMBER_FORMAT.format(value);
    }

    public static String formatNumber(double value, int numberOfDigits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        int numberDigits = numberOfDigits;
        if (numberDigits < 0) {
            try {
                String numberDigitsString = System.getProperty("rapidminer.general.fractiondigits.numbers");
                numberDigits = Integer.parseInt(numberDigitsString);
            }
            catch (NumberFormatException e) {
                numberDigits = 3;
            }
        }
        NUMBER_FORMAT.setMaximumFractionDigits(numberDigits);
        NUMBER_FORMAT.setMinimumFractionDigits(numberDigits);
        return NUMBER_FORMAT.format(value);
    }

    public static String formatIntegerIfPossible(double value) {
        int numberDigits = 3;
        try {
            String numberDigitsString = System.getProperty("rapidminer.general.fractiondigits.numbers");
            numberDigits = Integer.parseInt(numberDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Tools.formatIntegerIfPossible(value, numberDigits);
    }

    public static String formatIntegerIfPossible(double value, int numberOfDigits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        if (Double.isInfinite(value)) {
            if (value < 0.0) {
                return "-" + FORMAT_SYMBOLS.getInfinity();
            }
            return FORMAT_SYMBOLS.getInfinity();
        }
        long longValue = Math.round(value);
        if (Math.abs((double)longValue - value) < 1.0E-8) {
            return String.valueOf(longValue);
        }
        return Tools.formatNumber(value, numberOfDigits);
    }

    public static String formatTime(Date date) {
        TIME_FORMAT.setTimeZone(Tools.getPreferredTimeZone());
        return TIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        DATE_FORMAT.setTimeZone(Tools.getPreferredTimeZone());
        return DATE_FORMAT.format(date);
    }

    public static String formatDateTime(Date date) {
        DATE_TIME_FORMAT.setTimeZone(Tools.getPreferredTimeZone());
        return DATE_TIME_FORMAT.format(date);
    }

    public static String formatDuation(long milliseconds) {
        return DURATION_TIME_FORMAT.format(milliseconds);
    }

    public static String ordinalNumber(int n) {
        if (n % 10 == 1 && n % 100 != 11) {
            return String.valueOf(n) + "st";
        }
        if (n % 10 == 2 && n % 100 != 12) {
            return String.valueOf(n) + "nd";
        }
        if (n % 10 == 3 && n % 100 != 13) {
            return String.valueOf(n) + "rd";
        }
        return String.valueOf(n) + "th";
    }

    public static boolean isEqual(double d1, double d2) {
        if (Double.isNaN(d1) && Double.isNaN(d2)) {
            return true;
        }
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            return false;
        }
        return Math.abs(d1 - d2) < 1.0E-6;
    }

    public static boolean isZero(double d) {
        return Tools.isEqual(d, 0.0);
    }

    public static boolean isNotEqual(double d1, double d2) {
        return !Tools.isEqual(d1, d2);
    }

    public static boolean isGreater(double d1, double d2) {
        return Double.compare(d1, d2) > 0 && Tools.isNotEqual(d1, d2) || Double.isNaN(d1) || Double.isNaN(d2);
    }

    public static boolean isGreaterEqual(double d1, double d2) {
        return Double.compare(d1, d2) > 0 || Tools.isEqual(d1, d2) || Double.isNaN(d1) || Double.isNaN(d2);
    }

    public static boolean isLess(double d1, double d2) {
        return !Tools.isGreaterEqual(d1, d2);
    }

    public static boolean isLessEqual(double d1, double d2) {
        return !Tools.isGreater(d1, d2) || Double.isNaN(d1) || Double.isNaN(d2);
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String getLineSeparators(int number) {
        if (number < 0) {
            number = 0;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < number) {
            result.append(LINE_SEPARATOR);
            ++i;
        }
        return result.toString();
    }

    public static String transformAllLineSeparators(String text) {
        Pattern crlf = Pattern.compile("(\r\n|\r|\n|\n\r)");
        Matcher m = crlf.matcher(text);
        if (m.find()) {
            text = m.replaceAll("\n");
        }
        return text;
    }

    public static String removeAllLineSeparators(String text) {
        Pattern crlf = Pattern.compile("(\r\n|\r|\n|\n\r)");
        Matcher m = crlf.matcher(text);
        if (m.find()) {
            text = m.replaceAll(" ");
        }
        return text;
    }

    public static String classNameWOPackage(Class c) {
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }

    public static String readOutput(BufferedReader in) throws IOException {
        StringBuffer output = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            output.append(line);
            output.append(Tools.getLineSeparator());
        }
        return output.toString();
    }

    public static File getFile(File parent, String name) {
        if (name == null) {
            return null;
        }
        File file = new File(name);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(parent, name);
    }

    public static BufferedReader getReader(File file, Charset encoding) throws IOException {
        if (file.getAbsolutePath().endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(file);
            if (zipFile.size() == 0) {
                throw new IOException("Input of Zip file failed: the file archive does not contain any entries.");
            }
            if (zipFile.size() > 1) {
                throw new IOException("Input of Zip file failed: the file archive contains more than one entry.");
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            InputStream zipIn = zipFile.getInputStream(entries.nextElement());
            return new BufferedReader(new InputStreamReader(zipIn, encoding));
        }
        if (file.getAbsolutePath().endsWith(".gz")) {
            return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), encoding));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
    }

    public static Charset getDefaultEncoding() {
        String encoding;
        ProcessRootOperator rootOperator;
        Process process;
        Charset result = null;
        MainFrame mainFrame = RapidMinerGUI.getMainFrame();
        if (mainFrame != null && (process = mainFrame.getProcess()) != null && (rootOperator = process.getRootOperator()) != null) {
            result = rootOperator.getEncoding();
        }
        if (result == null && (encoding = System.getProperty("rapidminer.general.encoding")) != null && encoding.trim().length() > 0) {
            result = "SYSTEM".equals(encoding) ? Charset.defaultCharset() : Charset.forName(encoding);
        }
        if (result == null) {
            result = Charset.defaultCharset();
        }
        return result;
    }

    public static String getRelativePath(File firstFile, File secondFile) throws IOException {
        String canonicalFirstPath = firstFile.getCanonicalPath();
        String canonicalSecondPath = secondFile.getCanonicalPath();
        int minLength = Math.min(canonicalFirstPath.length(), canonicalSecondPath.length());
        int index = 0;
        index = 0;
        while (index < minLength) {
            if (canonicalFirstPath.charAt(index) != canonicalSecondPath.charAt(index)) break;
            ++index;
        }
        String relPath = canonicalFirstPath;
        int lastSeparatorIndex = canonicalFirstPath.substring(0, index).lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            String absRest = canonicalSecondPath.substring(lastSeparatorIndex + 1);
            StringBuffer relPathBuffer = new StringBuffer();
            while (absRest.indexOf(File.separator) >= 0) {
                relPathBuffer.append(".." + File.separator);
                absRest = absRest.substring(absRest.indexOf(File.separator) + 1);
            }
            relPathBuffer.append(canonicalFirstPath.substring(lastSeparatorIndex + 1));
            relPath = relPathBuffer.toString();
        }
        return relPath;
    }

    public static void waitForProcess(Operator operator, java.lang.Process process, String name) throws OperatorException {
        try {
            LogService.getGlobal().log("Waiting for process '" + name + "' to die.", 0);
            int value = process.waitFor();
            if (value != 0) {
                throw new UserError(operator, 306, name, value);
            }
            LogService.getGlobal().log("Process '" + name + "' terminated successfully.", 2);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for process '" + name + "' to die.", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void sendEmail(String address, String subject, String content) {
        try {
            block12: {
                method = System.getProperty("rapidminer.tools.mail.method");
                methodIndex = -1;
                if (method != null) {
                    try {
                        methodIndex = Integer.parseInt(method);
                        break block12;
                    }
                    catch (NumberFormatException e) {
                        methodIndex = -1;
                        i = 0;
                        ** while (i < RapidMiner.PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (RapidMiner.PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES[i].equals(method)) {
                            methodIndex = i;
                            break;
                        }
                        ++i;
                        continue;
                    }
                }
            }
            mailSender = null;
            switch (methodIndex) {
                case 1: {
                    mailSender = new MailSenderSMTP();
                    break;
                }
                case 0: {
                    mailSender = new MailSenderSendmail();
                    break;
                }
                default: {
                    LogService.getGlobal().log("Illegal send mail method: " + method + ".", 6);
                }
            }
            if (mailSender != null) {
                mailSender.sendEmail(address, subject, content);
            }
        }
        catch (Exception e) {
            LogService.getGlobal().log("Cannot send mail to " + address + ": " + e, 6);
        }
    }

    public static void addResourceSource(ResourceSource source) {
        ALL_RESOURCES.add(source);
    }

    public static void prependResourceSource(ResourceSource source) {
        ALL_RESOURCES.addFirst(source);
    }

    public static URL getResource(ClassLoader loader, String name) {
        return Tools.getResource(loader, RESOURCE_PREFIX, name);
    }

    public static URL getResource(ClassLoader loader, String prefix, String name) {
        return loader.getResource(String.valueOf(prefix) + name);
    }

    public static URL getResource(String name) {
        for (ResourceSource source : ALL_RESOURCES) {
            URL url = source.getResource(name);
            if (url == null) continue;
            return url;
        }
        URL resourceURL = Tools.getResource(Tools.class.getClassLoader(), name);
        if (resourceURL != null) {
            return resourceURL;
        }
        return null;
    }

    public static String readTextFile(File file) throws IOException {
        return Tools.readTextFile(new FileReader(file));
    }

    public static String readTextFile(Reader r) throws IOException {
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = new BufferedReader(r);
        String line = "";
        while ((line = reader.readLine()) != null) {
            contents.append(String.valueOf(line) + Tools.getLineSeparator());
        }
        reader.close();
        return contents.toString();
    }

    public static boolean booleanValue(String string, boolean deflt) {
        if (string == null) {
            return deflt;
        }
        string = string.toLowerCase().trim();
        int i = 0;
        while (i < TRUE_STRINGS.length) {
            if (TRUE_STRINGS[i].equals(string)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < FALSE_STRINGS.length) {
            if (FALSE_STRINGS[i].equals(string)) {
                return false;
            }
            ++i;
        }
        return deflt;
    }

    public static File findSourceFile(StackTraceElement e) {
        try {
            Class<?> clazz = Class.forName(e.getClassName());
            while (clazz.getDeclaringClass() != null) {
                clazz = clazz.getDeclaringClass();
            }
            String filename = clazz.getName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(String.valueOf(filename) + ".java");
        }
        catch (Throwable clazz) {
            String filename = e.getClassName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(String.valueOf(filename) + ".java");
        }
    }

    public static java.lang.Process launchFileEditor(File file, int line) throws IOException {
        String editor = System.getProperty("rapidminer.tools.editor");
        if (editor == null) {
            throw new IOException("Property 'rapidminer.tools.editor' undefined.");
        }
        editor = editor.replaceAll("%f", file.getAbsolutePath());
        editor = editor.replaceAll("%l", String.valueOf(line));
        return Runtime.getRuntime().exec(editor);
    }

    public static String escapeXML(String string) {
        if (string == null) {
            return "null";
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&#39;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = Tools.transformAllLineSeparators(string);
        string = string.replaceAll("\n", "&#10;");
        string = string.replaceAll("\t", "&#09;");
        return string;
    }

    public static void findImplementationsInJar(JarFile jar, Class superClass, List<String> implementations) {
        Tools.findImplementationsInJar(Tools.class.getClassLoader(), jar, superClass, implementations);
    }

    public static void findImplementationsInJar(ClassLoader loader, JarFile jar, Class<?> superClass, List<String> implementations) {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            int dotClass = name.lastIndexOf(".class");
            if (dotClass < 0) continue;
            name = name.substring(0, dotClass);
            name = name.replaceAll("/", "\\.");
            try {
                Class<?> c = loader.loadClass(name);
                if (!superClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                implementations.add(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException var1_1) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException var1_2) {
                ** for (p : Plugin.getAllPlugins())
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                return p.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException var3_5) {
                // empty catch block
            }
            continue;
        }
lbl13:
        // 1 sources

        throw new ClassNotFoundException(className);
    }

    public static String[] quotedSplit(String line, Pattern separatorPattern) {
        return Tools.quotedSplit(line, separatorPattern, '\"', '\\');
    }

    public static String[] quotedSplit(String line, Pattern separatorPattern, char quotingChar, char escapeChar) {
        int[] quoteSplitIndices = new int[line.length()];
        char lastChar = '0';
        int lastSplitIndex = -1;
        int i = 0;
        while (i < line.length()) {
            char currentChar = line.charAt(i);
            if (currentChar == quotingChar) {
                boolean escaped = false;
                if (i != 0 && lastChar == escapeChar) {
                    escaped = true;
                }
                if (!escaped) {
                    quoteSplitIndices[++lastSplitIndex] = i;
                }
            }
            lastChar = currentChar;
            ++i;
        }
        LinkedList<String> quotedSplits = new LinkedList<String>();
        if (lastSplitIndex < 0) {
            line.replaceAll("\\\\\"", "\"");
            quotedSplits.add(line);
        } else {
            int start = 0;
            int i2 = 0;
            while (i2 <= lastSplitIndex) {
                int end = quoteSplitIndices[i2];
                String part = "";
                if (end > start) {
                    part = line.substring(start, end);
                }
                part = part.replaceAll("\\\\\"", "\"");
                quotedSplits.add(part);
                start = end + 1;
                ++i2;
            }
            if (start < line.length()) {
                String part = line.substring(start);
                part = part.replaceAll("\\\\\"", "\"");
                quotedSplits.add(part);
            }
        }
        LinkedList<String> result = new LinkedList<String>();
        boolean isSplitPart = true;
        int index = 0;
        for (String part : quotedSplits) {
            if (index > 0 || part.trim().length() > 0) {
                if (isSplitPart) {
                    String[] separatedParts = separatorPattern.split(part, -1);
                    int s = 0;
                    while (s < separatedParts.length) {
                        String currentPart = separatedParts[s].trim();
                        if (currentPart.length() == 0) {
                            if (s == 0 && index == 0) {
                                result.add(currentPart);
                            } else if (s == separatedParts.length - 1 && index == quotedSplits.size() - 1) {
                                result.add(currentPart);
                            } else if (s > 0 && s < separatedParts.length - 1) {
                                result.add(currentPart);
                            }
                        } else {
                            result.add(currentPart);
                        }
                        ++s;
                    }
                } else {
                    result.add(part);
                }
            }
            isSplitPart = !isSplitPart;
            ++index;
        }
        String[] resultArray = new String[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    @Deprecated
    public static String[] mergeQuotedSplits(String line, String[] splittedTokens, String quoteString) throws IOException {
        int[] tokenStarts = new int[splittedTokens.length];
        int currentCounter = 0;
        int currentIndex = 0;
        String[] stringArray = splittedTokens;
        int n = splittedTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String currentToken = stringArray[n2];
            tokenStarts[currentIndex] = line.indexOf(currentToken, currentCounter);
            currentCounter = tokenStarts[currentIndex] + currentToken.length() + 1;
            ++currentIndex;
            ++n2;
        }
        LinkedList<String> tokens = new LinkedList<String>();
        int start = -1;
        int end = -1;
        int i = 0;
        while (i < splittedTokens.length) {
            if (splittedTokens[i].trim().startsWith(quoteString)) {
                start = i;
            }
            if (start >= 0) {
                StringBuffer current = new StringBuffer();
                while (end < 0 && i < splittedTokens.length) {
                    if (splittedTokens[i].endsWith(quoteString)) {
                        end = i;
                        break;
                    }
                    ++i;
                }
                if (end < 0) {
                    throw new IOException("Error during reading: open quote \" is not ended!");
                }
                String lastToken = null;
                int a = start;
                while (a <= end) {
                    String nextToken = splittedTokens[a];
                    if (nextToken.length() != 0) {
                        if (a == start) {
                            nextToken = nextToken.substring(quoteString.length());
                        }
                        if (a == end) {
                            nextToken = nextToken.substring(0, nextToken.length() - quoteString.length());
                        }
                        if (lastToken != null) {
                            int lastIndex = tokenStarts[a - 1] + lastToken.length();
                            int thisIndex = tokenStarts[a];
                            if (lastIndex >= 0 && thisIndex >= lastIndex) {
                                String separator = line.substring(lastIndex, thisIndex);
                                current.append(separator);
                            }
                        }
                        current.append(nextToken);
                        lastToken = splittedTokens[a];
                    }
                    ++a;
                }
                tokens.add(current.toString());
                start = -1;
                end = -1;
            } else {
                tokens.add(splittedTokens[i]);
            }
            ++i;
        }
        String[] quoted = new String[tokens.size()];
        tokens.toArray(quoted);
        return quoted;
    }

    public static void getFirstToken(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void getLastToken(StreamTokenizer tokenizer, boolean endOfFileOk) throws IOException {
        if (!(tokenizer.nextToken() == 10 || tokenizer.ttype == -1 && endOfFileOk)) {
            throw new IOException("expected the end of the line " + tokenizer.lineno());
        }
    }

    public static void getNextToken(StreamTokenizer tokenizer) throws IOException {
        if (tokenizer.nextToken() == 10) {
            throw new IOException("unexpected end of line " + tokenizer.lineno());
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("unexpected end of file in line " + tokenizer.lineno());
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void waitForEOL(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() != 10) {
        }
        tokenizer.pushBack();
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                Tools.delete(child);
                ++n2;
            }
            boolean result = file.delete();
            if (!result) {
                LogService.getGlobal().logWarning("Unable to delete file " + file);
            }
        } else {
            boolean result = file.delete();
            if (!result) {
                LogService.getGlobal().logWarning("Unable to delete file " + file);
            }
        }
    }

    public static void copy(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            boolean result;
            if (!dstPath.exists() && !(result = dstPath.mkdir())) {
                throw new IOException("Unable to create directoy: " + dstPath);
            }
            String[] files = srcPath.list();
            int i = 0;
            while (i < files.length) {
                Tools.copy(new File(srcPath, files[i]), new File(dstPath, files[i]));
                ++i;
            }
        } else if (srcPath.exists()) {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(srcPath).getChannel();
                out = new FileOutputStream(dstPath).getChannel();
                long size = in.size();
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ((FileChannel)out).write(buf);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static String escape(String unescaped) {
        StringBuilder result = new StringBuilder();
        char[] cArray = unescaped.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++n2;
        }
        return result.toString();
    }

    public static String unescape(String escaped) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (index < escaped.length()) {
            char c = escaped.charAt(index);
            block0 : switch (c) {
                case '\\': {
                    if (index < escaped.length() - 1) {
                        char next = escaped.charAt(++index);
                        switch (next) {
                            case 'n': {
                                result.append('\n');
                                break block0;
                            }
                            case '\\': {
                                result.append('\\');
                                break block0;
                            }
                            case '\"': {
                                result.append('\"');
                                break block0;
                            }
                        }
                        result.append('\\').append(next);
                        break;
                    }
                    result.append('\\');
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++index;
        }
        return result.toString();
    }
}

