/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.help;

import com.rapidminer.tools.LogService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.TextHelpModel;
import javax.swing.AbstractButton;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HelpService
implements ActionListener,
ChangeListener {
    private static JHelpContentViewer helpViewer = new JHelpContentViewer();
    private static HelpBroker helpBroker;
    private static HelpService helpService;
    private HashMap<Object, String> actionMap = new HashMap();
    private HashMap<Object, HashMap<Integer, String>> selectionModelMap = new HashMap();

    static {
        helpService = new HelpService();
    }

    public static void setHelpSetFile(ClassLoader classLoader, URL url) {
        HelpSet helpSet;
        try {
            helpSet = new HelpSet(classLoader, url);
        }
        catch (Exception ee) {
            LogService.getGlobal().logWarning("Help Set not found");
            return;
        }
        helpViewer.setModel((TextHelpModel)new DefaultHelpModel(helpSet));
        helpBroker = helpSet.createHelpBroker();
    }

    public static void setHelpContext(String context) {
        try {
            helpBroker.setCurrentID(context);
            helpViewer.getModel().setCurrentID(helpBroker.getCurrentID());
        }
        catch (Exception ee) {
            LogService.getGlobal().logWarning("HelpID " + context + " does not exist");
        }
    }

    public static JHelpContentViewer getContentViewer() {
        return helpViewer;
    }

    public static HelpBroker getHelpBroker() {
        return helpBroker;
    }

    public static synchronized void registerButton(AbstractButton button, String id) {
        button.addActionListener(helpService);
        helpService.registerObject(button, id);
    }

    public static synchronized void registerModel(SingleSelectionModel model, int index, String helpTopicId) {
        helpService.registerOnModel(model, index, helpTopicId);
    }

    public void registerObject(Object object, String helpTopicId) {
        this.actionMap.put(object, helpTopicId);
    }

    public void registerOnModel(SingleSelectionModel model, int index, String helpTopicId) {
        HashMap<Integer, String> indexHelpTopicMap = this.selectionModelMap.containsKey(model) ? this.selectionModelMap.get(model) : new HashMap<Integer, String>();
        indexHelpTopicMap.put(index, helpTopicId);
        this.selectionModelMap.put(model, indexHelpTopicMap);
        model.addChangeListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        String id = this.actionMap.get(event.getSource());
        HelpService.setHelpContext(id);
    }

    public void stateChanged(ChangeEvent event) {
        HashMap<Integer, String> idMap = this.selectionModelMap.get(event.getSource());
        if (idMap != null) {
            SingleSelectionModel model = (SingleSelectionModel)event.getSource();
            String id = idMap.get(model.getSelectedIndex());
            HelpService.setHelpContext(id);
        }
    }
}

