/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DriverAdapter;
import com.rapidminer.tools.jdbc.DriverInfo;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseService {
    private static List<JDBCProperties> jdbcProperties = new ArrayList<JDBCProperties>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(File jdbcDir, boolean searchForJDBDriversInLibDirectory, boolean searchForJDBCDriversInClasspath) {
        DatabaseService.registerAllJDBCDrivers(jdbcDir, searchForJDBDriversInLibDirectory, searchForJDBCDriversInClasspath);
        File etcPropertyFile = ParameterService.getConfigFile("jdbc_properties.xml");
        if (etcPropertyFile != null && etcPropertyFile.exists()) {
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(etcPropertyFile);
                    DatabaseService.loadJDBCProperties(in, "etc:jdbc_properties.xml");
                    return;
                }
                catch (IOException e) {
                    LogService.getGlobal().logError("Cannot load JDBC properties from etc directory.");
                    if (in == null) return;
                    try {
                        ((InputStream)in).close();
                        return;
                    }
                    catch (IOException e2) {
                        LogService.getGlobal().logError("Cannot close connection for JDBC properties file in the etc directory.");
                    }
                }
                return;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        LogService.getGlobal().logError("Cannot close connection for JDBC properties file in the etc directory.");
                    }
                }
            }
        }
        URL propertyURL = Tools.getResource("jdbc_properties.xml");
        if (propertyURL == null) return;
        InputStream in = null;
        try {
            try {
                in = propertyURL.openStream();
                DatabaseService.loadJDBCProperties(in, "resources:jdbc_properties.xml");
                return;
            }
            catch (IOException e) {
                LogService.getGlobal().logError("Cannot load JDBC properties from program resources.");
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e3) {
                    LogService.getGlobal().logError("Cannot close connection for JDBC properties file in the resources.");
                }
            }
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogService.getGlobal().logError("Cannot close connection for JDBC properties file in the resources.");
                }
            }
        }
    }

    private static void registerAllJDBCDrivers(File jdbcDir, boolean searchForJDBDriversInLibDirectory, boolean searchForJDBCDriversInClasspath) {
        if (searchForJDBDriversInLibDirectory) {
            File[] allFiles;
            File jdbcDirectory = jdbcDir;
            if (jdbcDirectory == null) {
                jdbcDirectory = ParameterService.getLibraryFile("jdbc");
            }
            if (jdbcDirectory != null && jdbcDirectory.exists() && (allFiles = jdbcDirectory.listFiles()) != null) {
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
                        DatabaseService.registerDynamicJDBCDrivers(f);
                    }
                    ++n2;
                }
            }
        }
        if (searchForJDBCDriversInClasspath) {
            String classpath = System.getProperty("java.class.path");
            String[] pathComponents = classpath.split(File.pathSeparator);
            int i = 0;
            while (i < pathComponents.length) {
                String path = pathComponents[i].trim();
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    DatabaseService.registerClasspathJDBCDrivers(new File(path).getAbsoluteFile());
                }
                ++i;
            }
        }
    }

    private static void registerDynamicJDBCDrivers(File file) {
        URLClassLoader ucl = null;
        try {
            URL u = new URL("jar:file:" + file.getAbsolutePath() + "!/");
            ucl = new URLClassLoader(new URL[]{u});
        }
        catch (MalformedURLException e) {
            LogService.getGlobal().log("DatabaseService: cannot create class loader for file '" + file + "': " + e.getMessage(), 6);
        }
        if (ucl != null) {
            try {
                JarFile jarFile = new JarFile(file);
                LinkedList<String> driverNames = new LinkedList<String>();
                Tools.findImplementationsInJar(ucl, jarFile, Driver.class, driverNames);
                Iterator i = driverNames.iterator();
                while (i.hasNext()) {
                    DatabaseService.registerDynamicJDBCDriver(ucl, (String)i.next());
                }
            }
            catch (Exception e) {
                LogService.getGlobal().log("DatabaseService: cannot register drivers for file '" + file + "': " + e.getMessage(), 6);
            }
        }
    }

    private static void registerDynamicJDBCDriver(URLClassLoader ucl, String driverName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (!driverName.equals(DriverAdapter.class.getName())) {
            Driver d = (Driver)Class.forName(driverName, true, ucl).newInstance();
            DriverManager.registerDriver(new DriverAdapter(d));
        }
    }

    private static void registerClasspathJDBCDrivers(File file) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            LogService.getGlobal().log("DatabaseService: cannot register drivers from file '" + file + "': " + e.getMessage(), 6);
            return;
        }
        LinkedList<String> driverNames = new LinkedList<String>();
        Tools.findImplementationsInJar(jarFile, Driver.class, driverNames);
        for (String driverName : driverNames) {
            try {
                Class.forName(driverName);
            }
            catch (Exception e) {
                LogService.getGlobal().log("DatabaseService: cannot register driver '" + driverName + "' from file '" + file + "': " + e.getMessage(), 6);
            }
        }
    }

    private static void loadJDBCProperties(InputStream in, String name) {
        jdbcProperties.clear();
        LogService.getGlobal().log("Loading JDBC driver information from '" + name + "'.", 3);
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            LogService.getGlobal().log("Cannot read JDBC driver description file '" + name + "': no valid XML: " + e.getMessage(), 6);
        }
        if (document != null) {
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("drivers")) {
                LogService.getGlobal().log("JDBC driver description file '" + name + "': outermost tag must be <drivers>!", 6);
                return;
            }
            NodeList driverTags = document.getDocumentElement().getElementsByTagName("driver");
            int i = 0;
            while (i < driverTags.getLength()) {
                Element currentElement = (Element)driverTags.item(i);
                try {
                    DatabaseService.addDriverInformation(currentElement);
                }
                catch (Exception e) {
                    Attr currentNameAttr = currentElement.getAttributeNode("name");
                    if (currentNameAttr != null) {
                        LogService.getGlobal().log("JDBC driver description: cannot register '" + currentNameAttr.getValue() + "': " + e, 6);
                    }
                    LogService.getGlobal().log("JDBC driver registration: cannot register '" + currentElement + "': " + e, 6);
                }
                ++i;
            }
        }
    }

    private static void addDriverInformation(Element driverElement) throws Exception {
        Attr nameAttr = driverElement.getAttributeNode("name");
        Attr portAttr = driverElement.getAttributeNode("defaultport");
        Attr urlAttr = driverElement.getAttributeNode("urlprefix");
        Attr dbNameAttr = driverElement.getAttributeNode("dbnameseperator");
        Attr varcharNameAttr = driverElement.getAttributeNode("type_varchar");
        Attr textNameAttr = driverElement.getAttributeNode("type_text");
        Attr integerNameAttr = driverElement.getAttributeNode("type_integer");
        Attr realNameAttr = driverElement.getAttributeNode("type_real");
        Attr identifierQuoteOpenAttr = driverElement.getAttributeNode("identifier_quote_open");
        Attr identifierQuoteCloseAttr = driverElement.getAttributeNode("identifier_quote_close");
        Attr valueQuoteOpenAttr = driverElement.getAttributeNode("value_quote_open");
        Attr valueQuoteCloseAttr = driverElement.getAttributeNode("value_quote_close");
        if (nameAttr == null) {
            throw new Exception("Missing name for <driver> tag");
        }
        if (portAttr == null) {
            throw new Exception("Missing defaultport for <driver> tag");
        }
        if (urlAttr == null) {
            throw new Exception("Missing urlprefix for <driver> tag");
        }
        if (dbNameAttr == null) {
            throw new Exception("Missing dbnameseperator for <driver> tag");
        }
        String varcharString = "VARCHAR";
        if (varcharNameAttr != null) {
            varcharString = varcharNameAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'type_varchar' found for driver " + nameAttr.getValue() + ", using default (VARCHAR)...");
        }
        String textString = "BLOB";
        if (textNameAttr != null) {
            textString = textNameAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'type_text' found for driver " + nameAttr.getValue() + ", using default (BLOB)...");
        }
        String integerString = "INTEGER";
        if (integerNameAttr != null) {
            integerString = integerNameAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'type_integer' found for driver " + nameAttr.getValue() + ", using default (INTEGER)...");
        }
        String realString = "REAL";
        if (realNameAttr != null) {
            realString = realNameAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'type_real' found for driver " + nameAttr.getValue() + ", using default (REAL)...");
        }
        String identifierQuoteOpenString = "\"";
        if (identifierQuoteOpenAttr != null) {
            identifierQuoteOpenString = identifierQuoteOpenAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'identifier_quote_open' found for driver " + nameAttr.getValue() + ", using default (\")...");
        }
        String identifierQuoteCloseString = "\"";
        if (identifierQuoteCloseAttr != null) {
            identifierQuoteCloseString = identifierQuoteCloseAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'identifier_quote_close' found for driver " + nameAttr.getValue() + ", using default (\")...");
        }
        String valueQuoteOpenString = "'";
        if (valueQuoteOpenAttr != null) {
            valueQuoteOpenString = valueQuoteOpenAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'value_quote_open' found for driver " + nameAttr.getValue() + ", using default (')...");
        }
        String valueQuoteCloseString = "'";
        if (valueQuoteCloseAttr != null) {
            valueQuoteCloseString = valueQuoteCloseAttr.getValue();
        } else {
            LogService.getGlobal().logWarning("No definition of 'value_quote_close' found for driver " + nameAttr.getValue() + ", using default (')...");
        }
        JDBCProperties properties = new JDBCProperties(nameAttr.getValue(), portAttr.getValue(), urlAttr.getValue(), dbNameAttr.getValue(), varcharString, textString, integerString, realString, identifierQuoteOpenString, identifierQuoteCloseString, valueQuoteOpenString, valueQuoteCloseString);
        jdbcProperties.add(properties);
    }

    public static Enumeration<Driver> getAllDrivers() {
        return DriverManager.getDrivers();
    }

    public static DriverInfo[] getAllDriverInfos() {
        boolean accepted;
        LinkedList<DriverInfo> predefinedDriverList = new LinkedList<DriverInfo>();
        for (JDBCProperties properties : DatabaseService.getJDBCProperties()) {
            Enumeration<Driver> drivers = DatabaseService.getAllDrivers();
            accepted = false;
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                try {
                    if (!driver.acceptsURL(properties.getUrlPrefix())) continue;
                    DriverInfo info = new DriverInfo(driver);
                    info.setShortName(properties.getName());
                    predefinedDriverList.add(info);
                    accepted = true;
                    break;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (accepted) continue;
            predefinedDriverList.add(new DriverInfo(properties.getName()));
        }
        LinkedList<DriverInfo> driverList = new LinkedList<DriverInfo>();
        Enumeration<Driver> drivers = DatabaseService.getAllDrivers();
        while (drivers.hasMoreElements()) {
            DriverInfo info;
            Driver driver = drivers.nextElement();
            accepted = true;
            for (DriverInfo predefinedInfo : predefinedDriverList) {
                if (predefinedInfo.getDriver() == null || !predefinedInfo.getDriver().equals(driver)) continue;
                accepted = false;
                break;
            }
            if (!accepted || (info = new DriverInfo(driver)).getShortName().startsWith("NonRegistering") || info.getShortName().startsWith("Replication")) continue;
            driverList.add(new DriverInfo(driver));
        }
        driverList.addAll(predefinedDriverList);
        Collections.sort(driverList);
        DriverInfo[] driverArray = new DriverInfo[driverList.size()];
        driverList.toArray(driverArray);
        return driverArray;
    }

    public static JDBCProperties getJDBCProperties(String name) {
        for (JDBCProperties p : jdbcProperties) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static JDBCProperties getJProperties(String systemName) {
        JDBCProperties result = null;
        for (JDBCProperties properties : jdbcProperties) {
            if (!properties.getName().equalsIgnoreCase(systemName)) continue;
            result = properties;
            break;
        }
        return result;
    }

    public static List<JDBCProperties> getJDBCProperties() {
        return jdbcProperties;
    }

    public static String[] getDBSystemNames() {
        String[] names = new String[jdbcProperties.size()];
        int counter = 0;
        Iterator<JDBCProperties> i = jdbcProperties.iterator();
        while (i.hasNext()) {
            names[counter++] = i.next().getName();
        }
        return names;
    }
}

