/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.log;

import com.rapidminer.tools.log.LogFormatFilter;
import java.io.IOException;
import java.io.OutputStream;

public class FormattedFilterStream
extends OutputStream {
    private OutputStream out;
    private LogFormatFilter filter;
    private int lastChar = -1;

    public FormattedFilterStream(OutputStream out, LogFormatFilter filter) {
        this.out = out;
        this.filter = filter;
    }

    public void write(int b) throws IOException {
        if (this.filter.accept(this.lastChar, b)) {
            this.out.write(b);
        }
        this.lastChar = b;
    }

    public void close() throws IOException {
        if (!System.out.equals(this.out) && !System.err.equals(this.out)) {
            this.out.close();
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

