/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AverageVector
extends ResultObjectAdapter
implements Comparable,
Cloneable {
    private static final long serialVersionUID = 6207859713603581755L;
    private List<Averagable> averagesList = new ArrayList<Averagable>();

    public abstract Object clone() throws CloneNotSupportedException;

    public boolean equals(Object o) {
        if (!(o instanceof AverageVector)) {
            return false;
        }
        AverageVector v = (AverageVector)o;
        return this.averagesList.equals(v.averagesList);
    }

    public int hashCode() {
        return this.averagesList.hashCode();
    }

    public int size() {
        return this.averagesList.size();
    }

    public void addAveragable(Averagable avg) {
        this.averagesList.add(avg);
    }

    public void removeAveragable(Averagable avg) {
        this.averagesList.remove(avg);
    }

    public Averagable getAveragable(int index) {
        return this.averagesList.get(index);
    }

    public Averagable getAveragable(String name) {
        for (Averagable a : this.averagesList) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public int getSize() {
        return this.averagesList.size();
    }

    public String toResultString() {
        StringBuffer result = new StringBuffer(this.getName());
        result.append(":");
        result.append(Tools.getLineSeparator());
        Iterator<Averagable> i = this.averagesList.iterator();
        while (i.hasNext()) {
            result.append(i.next().toResultString());
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("AverageVector [");
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            if (i > 0) {
                result.append(", ");
            }
            result.append(avg);
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public Component getVisualizationComponent(IOContainer container) {
        JPanel mainPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        mainPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(11, 11, 11, 11);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JLabel mainLabel = new JLabel("<html><h2>" + this.getName() + " (" + this.size() + ")</h2></html>");
        layout.setConstraints(mainLabel, c);
        mainPanel.add(mainLabel);
        int i = 0;
        while (i < this.size()) {
            Averagable avg = this.getAveragable(i);
            Component visualizationComponent = avg.getVisualizationComponent(container);
            layout.setConstraints(visualizationComponent, c);
            mainPanel.add(visualizationComponent);
            ++i;
        }
        return new ExtendedJScrollPane(mainPanel);
    }

    public void buildAverages(AverageVector av) {
        if (this.size() != av.size()) {
            throw new IllegalArgumentException("Performance vectors have different size!");
        }
        int i = 0;
        while (i < this.size()) {
            this.getAveragable(i).buildAverage(av.getAveragable(i));
            ++i;
        }
    }
}

