/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDTreeNode<T> {
    private T storeValue;
    private double[] values;
    private KDTreeNode<T> lesserChild;
    private KDTreeNode<T> greaterChild;
    private int comparationDimension;

    public KDTreeNode(double[] values, T storeValue, int comparationDimension) {
        this.values = values;
        this.storeValue = storeValue;
        this.comparationDimension = comparationDimension;
    }

    public KDTreeNode<T> getNearChild(double[] compare) {
        if (compare[this.comparationDimension] < this.values[this.comparationDimension]) {
            return this.lesserChild;
        }
        return this.greaterChild;
    }

    public KDTreeNode<T> getFarChild(double[] compare) {
        if (compare[this.comparationDimension] >= this.values[this.comparationDimension]) {
            return this.lesserChild;
        }
        return this.greaterChild;
    }

    public boolean hasNearChild(double[] compare) {
        if (compare[this.comparationDimension] < this.values[this.comparationDimension]) {
            return this.lesserChild != null;
        }
        return this.greaterChild != null;
    }

    public boolean hasFarChild(double[] compare) {
        if (compare[this.comparationDimension] >= this.values[this.comparationDimension]) {
            return this.lesserChild != null;
        }
        return this.greaterChild != null;
    }

    public void setChild(KDTreeNode<T> node) {
        if (node.getValues()[this.comparationDimension] < this.values[this.comparationDimension]) {
            this.lesserChild = node;
        } else {
            this.greaterChild = node;
        }
    }

    public T getStoreValue() {
        return this.storeValue;
    }

    public KDTreeNode getLesserChild() {
        return this.lesserChild;
    }

    public void setLesserChild(KDTreeNode<T> leftChild) {
        this.lesserChild = leftChild;
    }

    public KDTreeNode<T> getGreaterChild() {
        return this.greaterChild;
    }

    public void setGreaterChild(KDTreeNode<T> rightChild) {
        this.greaterChild = rightChild;
    }

    public double[] getValues() {
        return this.values;
    }

    public double getCompareValue() {
        return this.values[this.comparationDimension];
    }

    public int getCompareDimension() {
        return this.comparationDimension;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.comparationDimension) {
            buffer.append(String.valueOf(this.values[i]) + "  ");
            ++i;
        }
        buffer.append("[");
        buffer.append(this.values[this.comparationDimension]);
        buffer.append("]  ");
        i = this.comparationDimension + 1;
        while (i < this.values.length) {
            buffer.append(String.valueOf(this.values[i]) + "  ");
            ++i;
        }
        return buffer.toString();
    }
}

