/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function;

import com.rapidminer.MacroHandler;
import com.rapidminer.Process;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.function.expressions.Average;
import com.rapidminer.tools.math.function.expressions.LogarithmDualis;
import com.rapidminer.tools.math.function.expressions.Maximum;
import com.rapidminer.tools.math.function.expressions.Minimum;
import com.rapidminer.tools.math.function.expressions.ParameterValue;
import com.rapidminer.tools.math.function.expressions.ParseNumber;
import com.rapidminer.tools.math.function.expressions.Signum;
import com.rapidminer.tools.math.function.expressions.Substring;
import java.util.HashMap;
import java.util.Map;
import org.nfunk.jep.JEP;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.type.Complex;

public class ExpressionParser {
    private JEP parser = new JEP();

    public ExpressionParser(boolean useStandardConstants) {
        this.parser.addStandardFunctions();
        if (useStandardConstants) {
            this.parser.addStandardConstants();
        }
        this.addCustomFunctions(this.parser);
        this.parser.setAllowUndeclared(false);
        this.parser.setImplicitMul(false);
    }

    public ExpressionParser(boolean useStandardConstants, Process process) {
        this(useStandardConstants);
        this.parser.addFunction("param", (PostfixMathCommandI)new ParameterValue(process));
    }

    private void addCustomFunctions(JEP parser) {
        parser.addFunction("avg", (PostfixMathCommandI)new Average());
        parser.addFunction("min", (PostfixMathCommandI)new Minimum());
        parser.addFunction("max", (PostfixMathCommandI)new Maximum());
        parser.addFunction("ld", (PostfixMathCommandI)new LogarithmDualis());
        parser.addFunction("sgn", (PostfixMathCommandI)new Signum());
        parser.addFunction("parse", (PostfixMathCommandI)new ParseNumber());
        parser.addFunction("cut", (PostfixMathCommandI)new Substring());
    }

    public void addMacro(MacroHandler macroHandler, String name, String function) throws GenerationException {
        this.parser.parseExpression(function);
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        Object result = this.parser.getValueAsObject();
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        if (result != null) {
            try {
                macroHandler.addMacro(name, Tools.formatIntegerIfPossible(Double.parseDouble(result.toString())));
            }
            catch (NumberFormatException e) {
                macroHandler.addMacro(name, result.toString());
            }
        }
    }

    public void addAttribute(ExampleSet exampleSet, String name, String function) throws GenerationException {
        this.parser.setAllowUndeclared(true);
        this.parser.parseExpression(function);
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        SymbolTable symbolTable = this.parser.getSymbolTable();
        HashMap<String, Attribute> name2attributes = new HashMap<String, Attribute>();
        for (Object variableObj : symbolTable.values()) {
            Variable variable = (Variable)variableObj;
            if (variable.isConstant()) continue;
            Attribute attribute = exampleSet.getAttributes().get(variable.getName());
            if (attribute == null) {
                throw new GenerationException("No such attribute: " + variable.getName());
            }
            name2attributes.put(variable.getName(), attribute);
            if (attribute.isNominal()) {
                this.parser.addVariable(attribute.getName(), (Object)"");
                continue;
            }
            this.parser.addVariable(attribute.getName(), Double.NaN);
        }
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        Object result = this.parser.getValueAsObject();
        if (this.parser.hasError()) {
            throw new GenerationException(this.parser.getErrorInfo());
        }
        Attribute newAttribute = null;
        if (result instanceof Boolean) {
            newAttribute = AttributeFactory.createAttribute(name, 6);
            newAttribute.getMapping().mapString("false");
            newAttribute.getMapping().mapString("true");
        } else {
            newAttribute = result instanceof Number ? AttributeFactory.createAttribute(name, 4) : (result instanceof Complex ? AttributeFactory.createAttribute(name, 4) : AttributeFactory.createAttribute(name, 1));
        }
        newAttribute.setConstruction(function);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            for (Map.Entry entry : name2attributes.entrySet()) {
                String variableName = (String)entry.getKey();
                Attribute attribute = (Attribute)entry.getValue();
                if (attribute.isNominal()) {
                    this.parser.setVarValue(variableName, (Object)example.getValueAsString(attribute));
                    continue;
                }
                this.parser.setVarValue(variableName, (Object)example.getValue(attribute));
            }
            result = this.parser.getValueAsObject();
            if (this.parser.hasError()) {
                throw new GenerationException(this.parser.getErrorInfo());
            }
            if (result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    example.setValue(newAttribute, 0.0);
                    continue;
                }
                example.setValue(newAttribute, 1.0);
                continue;
            }
            if (result instanceof Number) {
                example.setValue(newAttribute, ((Number)result).doubleValue());
                continue;
            }
            if (result instanceof Complex) {
                example.setValue(newAttribute, ((Complex)result).doubleValue());
                continue;
            }
            example.setValue(newAttribute, newAttribute.getMapping().mapString(result.toString()));
        }
    }
}

