/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.pso;

import com.rapidminer.operator.performance.PerformanceVector;

public class Population {
    private static final int CURRENT = 0;
    private static final int BEST = 1;
    private double[][][] values;
    private double[][] individualFitness;
    private double[] bestValuesEver;
    private PerformanceVector bestPerformanceEver;
    private double generationsBest = Double.NaN;
    private int generation = 0;
    private int lastImprovement = 0;

    public Population(int popSize, int individualSize) {
        this.values = new double[2][popSize][individualSize];
        this.individualFitness = new double[2][popSize];
        int i = 0;
        while (i < popSize) {
            this.individualFitness[1][i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
    }

    public int getNumberOfIndividuals() {
        return this.values[0].length;
    }

    public int getIndividualSize() {
        return this.values[0][0].length;
    }

    public double[] getValues(int index) {
        return this.values[0][index];
    }

    public double[] getLocalBestValues(int index) {
        return this.values[1][index];
    }

    public double[] getGlobalBestValues() {
        return this.bestValuesEver;
    }

    public double getBestFitnessEver() {
        if (this.bestPerformanceEver == null) {
            return Double.NaN;
        }
        return this.bestPerformanceEver.getMainCriterion().getFitness();
    }

    public PerformanceVector getBestPerformanceEver() {
        return this.bestPerformanceEver;
    }

    public double getBestFitnessInGeneration() {
        return this.generationsBest;
    }

    public void setValues(int index, double[] values) {
        this.values[0][index] = values;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void nextGeneration() {
        ++this.generation;
    }

    public int getGenerationsWithoutImprovement() {
        return this.generation - this.lastImprovement;
    }

    public void setFitnessVector(PerformanceVector[] performanceVectors) {
        double[] fitnessValues = new double[performanceVectors.length];
        int i = 0;
        while (i < fitnessValues.length) {
            fitnessValues[i] = performanceVectors[i] == null ? Double.NEGATIVE_INFINITY : performanceVectors[i].getMainCriterion().getFitness();
            ++i;
        }
        this.generationsBest = Double.NEGATIVE_INFINITY;
        int generationsBestIndex = -1;
        int i2 = 0;
        while (i2 < fitnessValues.length) {
            this.individualFitness[0][i2] = fitnessValues[i2];
            if (fitnessValues[i2] > this.individualFitness[1][i2]) {
                int d = 0;
                while (d < this.values[1][i2].length) {
                    this.values[1][i2][d] = this.values[0][i2][d];
                    ++d;
                }
                this.individualFitness[1][i2] = fitnessValues[i2];
            }
            if (fitnessValues[i2] > this.generationsBest) {
                this.generationsBest = fitnessValues[i2];
                generationsBestIndex = i2;
            }
            ++i2;
        }
        if (this.bestPerformanceEver == null || this.generationsBest > this.bestPerformanceEver.getMainCriterion().getFitness()) {
            this.bestPerformanceEver = performanceVectors[generationsBestIndex];
            this.bestValuesEver = new double[this.values[0][0].length];
            int d = 0;
            while (d < this.bestValuesEver.length) {
                this.bestValuesEver[d] = this.values[1][generationsBestIndex][d];
                ++d;
            }
            this.lastImprovement = this.generation;
        }
    }
}

