/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.AndCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.math.kernels.Kernel;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.divergences.GeneralizedIDivergence;
import com.rapidminer.tools.math.similarity.divergences.ItakuraSaitoDistance;
import com.rapidminer.tools.math.similarity.divergences.KLDivergence;
import com.rapidminer.tools.math.similarity.divergences.LogarithmicLoss;
import com.rapidminer.tools.math.similarity.divergences.LogisticLoss;
import com.rapidminer.tools.math.similarity.divergences.MahalanobisDistance;
import com.rapidminer.tools.math.similarity.divergences.SquaredEuclideanDistance;
import com.rapidminer.tools.math.similarity.divergences.SquaredLoss;
import com.rapidminer.tools.math.similarity.mixed.MixedEuclideanDistance;
import com.rapidminer.tools.math.similarity.nominal.DiceNominalSimilarity;
import com.rapidminer.tools.math.similarity.nominal.JaccardNominalSimilarity;
import com.rapidminer.tools.math.similarity.nominal.KulczynskiNominalSimilarity;
import com.rapidminer.tools.math.similarity.nominal.NominalDistance;
import com.rapidminer.tools.math.similarity.nominal.RogersTanimotoNominalSimilarity;
import com.rapidminer.tools.math.similarity.nominal.RussellRaoNominalSimilarity;
import com.rapidminer.tools.math.similarity.nominal.SimpleMatchingNominalSimilarity;
import com.rapidminer.tools.math.similarity.numerical.CamberraNumericalDistance;
import com.rapidminer.tools.math.similarity.numerical.ChebychevNumericalDistance;
import com.rapidminer.tools.math.similarity.numerical.CorrelationSimilarity;
import com.rapidminer.tools.math.similarity.numerical.CosineSimilarity;
import com.rapidminer.tools.math.similarity.numerical.DTWDistance;
import com.rapidminer.tools.math.similarity.numerical.DiceNumericalSimilarity;
import com.rapidminer.tools.math.similarity.numerical.EuclideanDistance;
import com.rapidminer.tools.math.similarity.numerical.InnerProductSimilarity;
import com.rapidminer.tools.math.similarity.numerical.JaccardNumericalSimilarity;
import com.rapidminer.tools.math.similarity.numerical.KernelEuclideanDistance;
import com.rapidminer.tools.math.similarity.numerical.ManhattanDistance;
import com.rapidminer.tools.math.similarity.numerical.MaxProductSimilarity;
import com.rapidminer.tools.math.similarity.numerical.OverlapNumericalSimilarity;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceMeasures {
    public static final String PARAMETER_MEASURE_TYPES = "measure_types";
    public static final String PARAMETER_NOMINAL_MEASURE = "nominal_measure";
    public static final String PARAMETER_NUMERICAL_MEASURE = "numerical_measure";
    public static final String PARAMETER_MIXED_MEASURE = "mixed_measure";
    public static final String PARAMETER_DIVERGENCE = "divergence";
    private static final String[] MEASURE_TYPES = new String[]{"MixedMeasures", "NominalMeasures", "NumericalMeasures", "BregmanDivergences"};
    public static final int MIXED_MEASURES_TYPE = 0;
    public static final int NOMINAL_MEASURES_TYPE = 1;
    public static final int NUMERICAL_MEASURES_TYPE = 2;
    public static final int DIVERGENCES_TYPE = 3;
    private static String[] NOMINAL_MEASURES = new String[]{"NominalDistance", "DiceSimilarity", "JaccardSimilarity", "KulczynskiSimilarity", "RogersTanimotoSimilarity", "RussellRaoSimilarity", "SimpleMatchingSimilarity"};
    private static Class[] NOMINAL_MEASURE_CLASSES = new Class[]{NominalDistance.class, DiceNominalSimilarity.class, JaccardNominalSimilarity.class, KulczynskiNominalSimilarity.class, RogersTanimotoNominalSimilarity.class, RussellRaoNominalSimilarity.class, SimpleMatchingNominalSimilarity.class};
    private static String[] MIXED_MEASURES = new String[]{"MixedEuclideanDistance"};
    private static Class[] MIXED_MEASURE_CLASSES = new Class[]{MixedEuclideanDistance.class};
    private static String[] NUMERICAL_MEASURES = new String[]{"EuclideanDistance", "CamberraDistance", "ChebychevDistance", "CorrelationSimilarity", "CosineSimilarity", "DiceSimilarity", "DynamicTimeWarpingDistance", "InnerProductSimilarity", "JaccardSimilarity", "KernelEuclideanDistance", "ManhattanDistance", "MaxProductSimilarity", "OverlapSimilarity"};
    private static Class[] NUMERICAL_MEASURE_CLASSES = new Class[]{EuclideanDistance.class, CamberraNumericalDistance.class, ChebychevNumericalDistance.class, CorrelationSimilarity.class, CosineSimilarity.class, DiceNumericalSimilarity.class, DTWDistance.class, InnerProductSimilarity.class, JaccardNumericalSimilarity.class, KernelEuclideanDistance.class, ManhattanDistance.class, MaxProductSimilarity.class, OverlapNumericalSimilarity.class};
    private static String[] DIVERGENCES = new String[]{"GeneralizedIDivergence", "ItakuraSaitoDistance", "KLDivergence", "LogarithmicLoss", "LogisticLoss", "MahalanobisDistance", "SquaredEuclideanDistance", "SquaredLoss"};
    private static Class[] DIVERGENCE_CLASSES = new Class[]{GeneralizedIDivergence.class, ItakuraSaitoDistance.class, KLDivergence.class, LogarithmicLoss.class, LogisticLoss.class, MahalanobisDistance.class, SquaredEuclideanDistance.class, SquaredLoss.class};
    private static String[][] MEASURE_ARRAYS = new String[][]{MIXED_MEASURES, NOMINAL_MEASURES, NUMERICAL_MEASURES, DIVERGENCES};
    private static Class[][] MEASURE_CLASS_ARRAYS = new Class[][]{MIXED_MEASURE_CLASSES, NOMINAL_MEASURE_CLASSES, NUMERICAL_MEASURE_CLASSES, DIVERGENCE_CLASSES};

    public static void registerMeasure(int measureType, String measureName, Class<? extends DistanceMeasure> measureClass) {
        String[] newTypeNames = new String[MEASURE_ARRAYS[measureType].length + 1];
        System.arraycopy(MEASURE_ARRAYS[measureType], 0, newTypeNames, 0, MEASURE_ARRAYS[measureType].length);
        newTypeNames[newTypeNames.length - 1] = measureName;
        DistanceMeasures.MEASURE_ARRAYS[measureType] = newTypeNames;
        Class[] newTypeClasses = new Class[MEASURE_CLASS_ARRAYS[measureType].length + 1];
        System.arraycopy(MEASURE_CLASS_ARRAYS[measureType], 0, newTypeClasses, 0, MEASURE_CLASS_ARRAYS[measureType].length);
        newTypeClasses[newTypeClasses.length - 1] = measureClass;
        DistanceMeasures.MEASURE_CLASS_ARRAYS[measureType] = newTypeClasses;
    }

    public static DistanceMeasure createMeasure(ParameterHandler parameterHandler, ExampleSet exampleSet, IOContainer ioContainer) throws UndefinedParameterError, OperatorException {
        int measureType = parameterHandler.getParameterAsInt(PARAMETER_MEASURE_TYPES);
        switch (measureType) {
            case 0: {
                return DistanceMeasures.createMixedMeasure(parameterHandler, exampleSet, ioContainer);
            }
            case 1: {
                return DistanceMeasures.createNominalMeasure(parameterHandler, exampleSet, ioContainer);
            }
            case 2: {
                return DistanceMeasures.createNumericalMeasure(parameterHandler, exampleSet, ioContainer);
            }
            case 3: {
                return DistanceMeasures.createDivergence(parameterHandler, exampleSet, ioContainer);
            }
        }
        return null;
    }

    public static DistanceMeasure createNumericalMeasure(ParameterHandler parameterHandler, ExampleSet exampleSet, IOContainer ioContainer) throws UndefinedParameterError, OperatorException {
        Class measureClass = MEASURE_CLASS_ARRAYS[2][parameterHandler.getParameterAsInt(PARAMETER_NUMERICAL_MEASURE)];
        return DistanceMeasures.createMeasureFromClass(measureClass, parameterHandler, exampleSet, ioContainer);
    }

    public static DistanceMeasure createNominalMeasure(ParameterHandler parameterHandler, ExampleSet exampleSet, IOContainer ioContainer) throws UndefinedParameterError, OperatorException {
        Class measureClass = MEASURE_CLASS_ARRAYS[1][parameterHandler.getParameterAsInt(PARAMETER_NOMINAL_MEASURE)];
        return DistanceMeasures.createMeasureFromClass(measureClass, parameterHandler, exampleSet, ioContainer);
    }

    public static DistanceMeasure createMixedMeasure(ParameterHandler parameterHandler, ExampleSet exampleSet, IOContainer ioContainer) throws UndefinedParameterError, OperatorException {
        Class measureClass = MEASURE_CLASS_ARRAYS[0][parameterHandler.getParameterAsInt(PARAMETER_MIXED_MEASURE)];
        return DistanceMeasures.createMeasureFromClass(measureClass, parameterHandler, exampleSet, ioContainer);
    }

    public static DistanceMeasure createDivergence(ParameterHandler parameterHandler, ExampleSet exampleSet, IOContainer ioContainer) throws UndefinedParameterError, OperatorException {
        Class measureClass = MEASURE_CLASS_ARRAYS[3][parameterHandler.getParameterAsInt(PARAMETER_DIVERGENCE)];
        return DistanceMeasures.createMeasureFromClass(measureClass, parameterHandler, exampleSet, ioContainer);
    }

    private static DistanceMeasure createMeasureFromClass(Class measureClass, ParameterHandler parameterHandler, ExampleSet exampleSet, IOContainer ioContainer) throws OperatorException {
        try {
            DistanceMeasure measure = (DistanceMeasure)measureClass.newInstance();
            measure.init(exampleSet, parameterHandler, ioContainer);
            return measure;
        }
        catch (InstantiationException e) {
            throw new OperatorException("Could not instanciate distance measure " + measureClass);
        }
        catch (IllegalAccessException e) {
            throw new OperatorException("Could not instanciate distance measure " + measureClass);
        }
    }

    public static List<ParameterType> getParameterTypes(ParameterHandler parameterHandler) {
        LinkedList<ParameterType> list = new LinkedList<ParameterType>();
        list.add(new ParameterTypeCategory(PARAMETER_MEASURE_TYPES, "The measure type", MEASURE_TYPES, 0));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_MIXED_MEASURE, "Select measure", MEASURE_ARRAYS[0], 0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_MEASURE_TYPES, true, 0));
        list.add(type);
        type = new ParameterTypeCategory(PARAMETER_NOMINAL_MEASURE, "Select measure", MEASURE_ARRAYS[1], 0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_MEASURE_TYPES, true, 1));
        list.add(type);
        type = new ParameterTypeCategory(PARAMETER_NUMERICAL_MEASURE, "Select measure", MEASURE_ARRAYS[2], 0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_MEASURE_TYPES, true, 2));
        list.add(type);
        type = new ParameterTypeCategory(PARAMETER_DIVERGENCE, "Select divergence", MEASURE_ARRAYS[3], 0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_MEASURE_TYPES, true, 3));
        list.add(type);
        list.addAll(DistanceMeasures.registerDependency(Kernel.getParameters(parameterHandler), 9, parameterHandler));
        return list;
    }

    public static List<ParameterType> getParameterTypesForNumericals(ParameterHandler handler) {
        LinkedList<ParameterType> list = new LinkedList<ParameterType>();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_NUMERICAL_MEASURE, "Select measure", MEASURE_ARRAYS[2], 0);
        list.add(type);
        return list;
    }

    private static Collection<ParameterType> registerDependency(Collection<ParameterType> sourceTypeList, int selectedValue, ParameterHandler handler) {
        for (ParameterType type : sourceTypeList) {
            type.registerDependencyCondition(new AndCondition(new EqualTypeCondition(handler, PARAMETER_NUMERICAL_MEASURE, false, selectedValue), new EqualTypeCondition(handler, PARAMETER_MEASURE_TYPES, false, 2)));
        }
        return sourceTypeList;
    }
}

