/*
 * Decompiled with CFR 0.152.
 */
package liblinear;

import liblinear.FeatureNode;
import liblinear.Function;
import liblinear.Problem;

public class L2LossSVMFunction
implements Function {
    private final Problem prob;
    private final double[] C;
    private final int[] I;
    private final double[] z;
    private int sizeI;

    public L2LossSVMFunction(Problem prob, double Cp, double Cn) {
        int l = prob.l;
        int[] y = prob.y;
        this.prob = prob;
        this.z = new double[l];
        this.C = new double[l];
        this.I = new int[l];
        int i = 0;
        while (i < l) {
            this.C[i] = y[i] == 1 ? Cp : Cn;
            ++i;
        }
    }

    public double fun(double[] w) {
        double f = 0.0;
        int[] y = this.prob.y;
        int l = this.prob.l;
        int n = this.prob.n;
        this.Xv(w, this.z);
        int i = 0;
        while (i < l) {
            this.z[i] = (double)y[i] * this.z[i];
            double d = 1.0 - this.z[i];
            if (d > 0.0) {
                f += this.C[i] * d * d;
            }
            ++i;
        }
        f *= 2.0;
        i = 0;
        while (i < n) {
            f += w[i] * w[i];
            ++i;
        }
        return f /= 2.0;
    }

    public int get_nr_variable() {
        return this.prob.n;
    }

    public void grad(double[] w, double[] g) {
        int[] y = this.prob.y;
        int l = this.prob.l;
        int n = this.prob.n;
        this.sizeI = 0;
        int i = 0;
        while (i < l) {
            if (this.z[i] < 1.0) {
                this.z[this.sizeI] = this.C[i] * (double)y[i] * (this.z[i] - 1.0);
                this.I[this.sizeI] = i;
                ++this.sizeI;
            }
            ++i;
        }
        this.subXTv(this.z, g);
        i = 0;
        while (i < n) {
            g[i] = w[i] + 2.0 * g[i];
            ++i;
        }
    }

    public void Hv(double[] s, double[] Hs) {
        int l = this.prob.l;
        int n = this.prob.n;
        double[] wa = new double[l];
        this.subXv(s, wa);
        int i = 0;
        while (i < this.sizeI) {
            wa[i] = this.C[this.I[i]] * wa[i];
            ++i;
        }
        this.subXTv(wa, Hs);
        i = 0;
        while (i < n) {
            Hs[i] = s[i] + 2.0 * Hs[i];
            ++i;
        }
    }

    private void subXTv(double[] v, double[] XTv) {
        int n = this.prob.n;
        int i = 0;
        while (i < n) {
            XTv[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.sizeI) {
            FeatureNode[] featureNodeArray = this.prob.x[this.I[i]];
            int n2 = featureNodeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FeatureNode s = featureNodeArray[n3];
                int n4 = s.index - 1;
                XTv[n4] = XTv[n4] + v[i] * s.value;
                ++n3;
            }
            ++i;
        }
    }

    private void subXv(double[] v, double[] Xv) {
        int i = 0;
        while (i < this.sizeI) {
            Xv[i] = 0.0;
            FeatureNode[] featureNodeArray = this.prob.x[this.I[i]];
            int n = featureNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureNode s = featureNodeArray[n2];
                int n3 = i;
                Xv[n3] = Xv[n3] + v[s.index - 1] * s.value;
                ++n2;
            }
            ++i;
        }
    }

    private void Xv(double[] v, double[] Xv) {
        int i = 0;
        while (i < this.prob.l) {
            Xv[i] = 0.0;
            FeatureNode[] featureNodeArray = this.prob.x[i];
            int n = featureNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureNode s = featureNodeArray[n2];
                int n3 = i;
                Xv[n3] = Xv[n3] + v[s.index - 1] * s.value;
                ++n2;
            }
            ++i;
        }
    }
}

