/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.tools.LogService;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTInputList;
import edu.udo.cs.wvtool.main.WVTool;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextVisualizer
implements ObjectVisualizer {
    private static final long serialVersionUID = -7041933149816104684L;
    private Map<String, WVTDocumentInfo> idMapping = null;
    private WVTConfiguration wvtConfing = null;
    private WVTool wvt = new WVTool(false);

    public TextVisualizer(WVTInputList list, WVTConfiguration wvtConfig, int idType) {
        this.idMapping = new HashMap<String, WVTDocumentInfo>();
        this.wvtConfing = wvtConfig;
        int counter = 1;
        Iterator e = list.getEntries();
        while (e.hasNext()) {
            WVTDocumentInfo docInfo = (WVTDocumentInfo)e.next();
            switch (idType) {
                case 0: {
                    this.idMapping.put(docInfo.getSourceName(), docInfo);
                    break;
                }
                case 1: {
                    this.idMapping.put(docInfo.getSourceName().substring(docInfo.getSourceName().lastIndexOf(File.separator) + 1), docInfo);
                    break;
                }
                case 2: {
                    this.idMapping.put(String.valueOf(counter++), docInfo);
                }
            }
        }
    }

    public String getTitle(Object objId) {
        return objId.toString();
    }

    public boolean isCapableToVisualize(Object id) {
        return this.idMapping.get(id) != null;
    }

    public void startVisualization(Object objId) {
        WVTDocumentInfo docInfo = this.idMapping.get(objId);
        StringBuffer newText = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(this.wvt.getReader(docInfo, this.wvtConfing));
            String buf = null;
            while ((buf = in.readLine()) != null) {
                newText.append(String.valueOf(buf) + "\n");
            }
            in.close();
        }
        catch (Exception e) {
            LogService.getGlobal().log("Could not read text for id: " + e.getMessage(), 6);
        }
        JTextArea text = new JTextArea(20, 20);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setMargin(new Insets(10, 10, 10, 10));
        text.setText(newText.toString());
        text.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(text, 22, 31);
        JDialog dialog = new JDialog();
        dialog.setTitle("Text: " + this.getTitle(objId));
        dialog.getContentPane().add(scroll);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void stopVisualization(Object objId) {
    }

    public String getDetailData(Object objId, String fieldName) {
        return null;
    }

    public String[] getFieldNames(Object id) {
        return new String[0];
    }
}

