/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Types;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.io.HmmWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchScaledLearner;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BWActionHandler
extends ActionHandler {
    BWActionHandler() {
    }

    @Override
    public void act() throws FileNotFoundException, IOException, FileFormatException, AbnormalTerminationException {
        EnumSet<CommandLineArguments.Arguments> args = EnumSet.of(CommandLineArguments.Arguments.OPDF, CommandLineArguments.Arguments.OUT_HMM, CommandLineArguments.Arguments.IN_HMM, CommandLineArguments.Arguments.IN_SEQ, CommandLineArguments.Arguments.NB_ITERATIONS);
        CommandLineArguments.checkArgs(args);
        int nbIterations = CommandLineArguments.Arguments.NB_ITERATIONS.getAsInt();
        OutputStream outStream = CommandLineArguments.Arguments.OUT_HMM.getAsOutputStream();
        OutputStreamWriter hmmWriter = new OutputStreamWriter(outStream);
        InputStream hmmStream = CommandLineArguments.Arguments.IN_HMM.getAsInputStream();
        InputStream seqStream = CommandLineArguments.Arguments.IN_SEQ.getAsInputStream();
        InputStreamReader hmmReader = new InputStreamReader(hmmStream);
        InputStreamReader seqReader = new InputStreamReader(seqStream);
        this.learn(Types.relatedObjs(), hmmReader, seqReader, hmmWriter, nbIterations);
        ((Writer)hmmWriter).flush();
    }

    private <O extends Observation> void learn(RelatedObjs<O> relatedObjs, Reader hmmFileReader, Reader seqFileReader, Writer hmmFileWriter, int nbIterations) throws IOException, FileFormatException {
        List<List<O>> seqs = relatedObjs.readSequences(seqFileReader);
        OpdfReader<Opdf<O>> opdfReader = relatedObjs.opdfReader();
        OpdfWriter<Opdf<O>> opdfWriter = relatedObjs.opdfWriter();
        Hmm<O> initHmm = HmmReader.read(hmmFileReader, opdfReader);
        BaumWelchScaledLearner bw = new BaumWelchScaledLearner();
        bw.setNbIterations(nbIterations);
        Hmm<O> hmm = bw.learn(initHmm, seqs);
        HmmWriter.write(hmmFileWriter, opdfWriter, hmm);
    }
}

