/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Statistics;
import com.rapidminer.tools.LogService;
import java.util.Arrays;

public class NominalStatistics
implements Statistics {
    private static final long serialVersionUID = -7644523717916796701L;
    private long mode = -1L;
    private long maxCounter = 0L;
    private long[] scores;

    public NominalStatistics() {
    }

    private NominalStatistics(NominalStatistics other) {
        this.mode = other.mode;
        this.maxCounter = other.maxCounter;
        if (other.scores != null) {
            this.scores = new long[other.scores.length];
            int i = 0;
            while (i < this.scores.length) {
                this.scores[i] = other.scores[i];
                ++i;
            }
        }
    }

    public Object clone() {
        return new NominalStatistics(this);
    }

    public void startCounting(Attribute attribute) {
        this.scores = new long[attribute.getMapping().size()];
        this.mode = -1L;
        this.maxCounter = 0L;
    }

    public void count(double doubleIndex, double weight) {
        int index;
        if (!Double.isNaN(doubleIndex) && (index = (int)doubleIndex) >= 0) {
            if (index >= this.scores.length) {
                long[] newScores = new long[index + 1];
                System.arraycopy(this.scores, 0, newScores, 0, this.scores.length);
                this.scores = newScores;
            }
            int n = index;
            this.scores[n] = this.scores[n] + 1L;
            if (this.scores[index] > this.maxCounter) {
                this.maxCounter = this.scores[index];
                this.mode = index;
            }
        }
    }

    public boolean handleStatistics(String name) {
        return "mode".equals(name) || "count".equals(name) || "least".equals(name);
    }

    public double getStatistics(Attribute attribute, String name, String parameter) {
        if ("mode".equals(name)) {
            return this.mode;
        }
        if ("count".equals(name)) {
            if (parameter != null) {
                return this.getValueCount(attribute, parameter);
            }
            LogService.getGlobal().log("Cannot calculate statistics COUNT, no value given...", 5);
            return Double.NaN;
        }
        if ("least".equals(name)) {
            long minCounter = Integer.MAX_VALUE;
            long least = 0L;
            int i = 0;
            while (i < this.scores.length) {
                if (this.scores[i] < minCounter) {
                    minCounter = this.scores[i];
                    least = i;
                }
                ++i;
            }
            return least;
        }
        LogService.getGlobal().log("Cannot calculate statistics, unknown type: " + name, 5);
        return Double.NaN;
    }

    private long getValueCount(Attribute attribute, String value) {
        if (attribute != null && attribute.getMapping() != null) {
            int index = attribute.getMapping().getIndex(value);
            if (index < 0) {
                return -1L;
            }
            return this.scores[index];
        }
        return -1L;
    }

    public String toString() {
        return "Counts: " + Arrays.toString(this.scores);
    }
}

