/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeTransformation;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.AttributeTransformationRemapping;
import com.rapidminer.example.set.AttributesExampleReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.NominalMapping;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemappedExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 3460640319989955936L;
    private final ExampleSet parent;
    private final ExampleSet mappingSet;

    public RemappedExampleSet(ExampleSet parentSet, ExampleSet _mappingSet) {
        this.parent = (ExampleSet)parentSet.clone();
        this.mappingSet = (ExampleSet)_mappingSet.clone();
        Iterator<AttributeRole> a = this.parent.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute currentAttribute = role.getAttribute();
            if (!currentAttribute.isNominal()) continue;
            NominalMapping mapping = null;
            mapping = currentAttribute.getMapping();
            Attribute oldMappingAttribute = this.mappingSet.getAttributes().get(role.getAttribute().getName());
            if (oldMappingAttribute != null && oldMappingAttribute.isNominal()) {
                mapping = oldMappingAttribute.getMapping();
            }
            currentAttribute.addTransformation(new AttributeTransformationRemapping(mapping));
        }
    }

    public RemappedExampleSet(RemappedExampleSet other) {
        this.parent = (ExampleSet)other.parent.clone();
        this.mappingSet = (ExampleSet)other.mappingSet.clone();
        Iterator<AttributeRole> a = this.parent.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            NominalMapping oldMapping;
            Attribute mappingAttribute;
            AttributeRole role = a.next();
            Attribute currentAttribute = role.getAttribute();
            AttributeTransformation transformation = currentAttribute.getLastTransformation();
            if (transformation == null || !(transformation instanceof AttributeTransformationRemapping) || (mappingAttribute = this.mappingSet.getAttributes().get(currentAttribute.getName())) == null || (oldMapping = mappingAttribute.getMapping()) == null) continue;
            ((AttributeTransformationRemapping)transformation).setNominalMapping(oldMapping);
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return this.parent.getExample(index);
    }
}

