/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.BooleanArrayDataRow;
import com.rapidminer.example.table.BooleanSparseArrayDataRow;
import com.rapidminer.example.table.ByteArrayDataRow;
import com.rapidminer.example.table.ByteSparseArrayDataRow;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.DoubleSparseArrayDataRow;
import com.rapidminer.example.table.FloatArrayDataRow;
import com.rapidminer.example.table.FloatSparseArrayDataRow;
import com.rapidminer.example.table.IntArrayDataRow;
import com.rapidminer.example.table.IntSparseArrayDataRow;
import com.rapidminer.example.table.LongArrayDataRow;
import com.rapidminer.example.table.LongSparseArrayDataRow;
import com.rapidminer.example.table.ShortArrayDataRow;
import com.rapidminer.example.table.ShortSparseArrayDataRow;
import com.rapidminer.example.table.SparseMapDataRow;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;

public class DataRowFactory {
    public static final String[] TYPE_NAMES = new String[]{"double_array", "float_array", "long_array", "int_array", "short_array", "byte_array", "boolean_array", "double_sparse_array", "float_sparse_array", "long_sparse_array", "int_sparse_array", "short_sparse_array", "byte_sparse_array", "boolean_sparse_array", "sparse_map"};
    public static final int FIRST_TYPE_INDEX = 0;
    public static final int TYPE_DOUBLE_ARRAY = 0;
    public static final int TYPE_FLOAT_ARRAY = 1;
    public static final int TYPE_LONG_ARRAY = 2;
    public static final int TYPE_INT_ARRAY = 3;
    public static final int TYPE_SHORT_ARRAY = 4;
    public static final int TYPE_BYTE_ARRAY = 5;
    public static final int TYPE_BOOLEAN_ARRAY = 6;
    public static final int TYPE_DOUBLE_SPARSE_ARRAY = 7;
    public static final int TYPE_FLOAT_SPARSE_ARRAY = 8;
    public static final int TYPE_LONG_SPARSE_ARRAY = 9;
    public static final int TYPE_INT_SPARSE_ARRAY = 10;
    public static final int TYPE_SHORT_SPARSE_ARRAY = 11;
    public static final int TYPE_BYTE_SPARSE_ARRAY = 12;
    public static final int TYPE_BOOLEAN_SPARSE_ARRAY = 13;
    public static final int TYPE_SPARSE_MAP = 14;
    public static final int LAST_TYPE_INDEX = 14;
    private int type;
    private char decimalPointCharacter = (char)46;

    @Deprecated
    public DataRowFactory(int type) {
        this(type, '.');
    }

    public DataRowFactory(int type, char decimalPointCharacter) {
        if (type < 0 || type > 14) {
            throw new IllegalArgumentException("Illegal data row type: " + type);
        }
        this.type = type;
        this.decimalPointCharacter = decimalPointCharacter;
    }

    public DataRow create(int size) {
        DataRow row = null;
        switch (this.type) {
            case 0: {
                row = new DoubleArrayDataRow(new double[size]);
                break;
            }
            case 1: {
                row = new FloatArrayDataRow(new float[size]);
                break;
            }
            case 2: {
                row = new LongArrayDataRow(new long[size]);
                break;
            }
            case 3: {
                row = new IntArrayDataRow(new int[size]);
                break;
            }
            case 4: {
                row = new ShortArrayDataRow(new short[size]);
                break;
            }
            case 5: {
                row = new ByteArrayDataRow(new byte[size]);
                break;
            }
            case 6: {
                row = new BooleanArrayDataRow(new boolean[size]);
                break;
            }
            case 7: {
                row = new DoubleSparseArrayDataRow(size >> 2);
                break;
            }
            case 8: {
                row = new FloatSparseArrayDataRow(size >> 2);
                break;
            }
            case 9: {
                row = new LongSparseArrayDataRow(size >> 2);
                break;
            }
            case 10: {
                row = new IntSparseArrayDataRow(size >> 2);
                break;
            }
            case 11: {
                row = new ShortSparseArrayDataRow(size >> 2);
                break;
            }
            case 12: {
                row = new ByteSparseArrayDataRow(size >> 2);
                break;
            }
            case 13: {
                row = new BooleanSparseArrayDataRow(size >> 2);
                break;
            }
            case 14: {
                row = new SparseMapDataRow();
            }
        }
        return row;
    }

    public DataRow create(String[] strings, Attribute[] attributes) {
        DataRow dataRow = this.create(strings.length);
        int i = 0;
        while (i < strings.length) {
            if (strings[i] != null) {
                strings[i] = strings[i].trim();
            }
            if (strings[i] != null && strings[i].length() > 0 && !strings[i].equals("?")) {
                if (attributes[i].isNominal()) {
                    String unescaped = Tools.unescape(strings[i]);
                    dataRow.set(attributes[i], attributes[i].getMapping().mapString(unescaped));
                } else {
                    dataRow.set(attributes[i], DataRowFactory.string2Double(strings[i], this.decimalPointCharacter));
                }
            } else {
                dataRow.set(attributes[i], Double.NaN);
            }
            ++i;
        }
        dataRow.trim();
        return dataRow;
    }

    public DataRow create(Object[] data, Attribute[] attributes) {
        DataRow dataRow = this.create(data.length);
        int i = 0;
        while (i < data.length) {
            if (data[i] != null) {
                if (attributes[i].isNominal()) {
                    dataRow.set(attributes[i], attributes[i].getMapping().mapString(((String)data[i]).trim()));
                } else {
                    dataRow.set(attributes[i], ((Number)data[i]).doubleValue());
                }
            } else {
                dataRow.set(attributes[i], Double.NaN);
            }
            ++i;
        }
        dataRow.trim();
        return dataRow;
    }

    public DataRow create(Double[] data, Attribute[] attributes) {
        DataRow dataRow = this.create(data.length);
        int i = 0;
        while (i < data.length) {
            if (data[i] != null) {
                if (attributes[i].isNominal()) {
                    dataRow.set(attributes[i], attributes[i].getMapping().mapString(String.valueOf(data[i]).trim()));
                } else {
                    dataRow.set(attributes[i], data[i]);
                }
            } else {
                dataRow.set(attributes[i], Double.NaN);
            }
            ++i;
        }
        dataRow.trim();
        return dataRow;
    }

    public int getType() {
        return this.type;
    }

    private static final double string2Double(String str, char decimalPointCharacter) {
        if (str == null) {
            return Double.NaN;
        }
        try {
            str = str.replace(decimalPointCharacter, '.');
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("DataRowFactory.string2Double(String): '" + str + "' is not a valid number!", 6);
            return Double.NaN;
        }
    }
}

