/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.test;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.SparseFormatDataRowReader;
import com.rapidminer.example.test.ExampleTestTools;
import com.rapidminer.test.RapidMinerTestCase;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.att.AttributeSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;

public class SparseReaderTest
extends RapidMinerTestCase {
    private static final String[] ATTRIBUTE_STRINGS = new String[]{"5:3.0 2:8.0", "1:cat 3:2.5 4:1.5e-1", "5:1.0", "1:dog 4:7.3e1"};
    private static final String[] LABEL = new String[]{"yes", "no", "no", "yes"};

    public void readerTest(int format, Reader input, Reader labelInput) throws Exception {
        AttributeSet attributeSet = new AttributeSet();
        Attribute att1 = ExampleTestTools.attributeDogCatMouse();
        Attribute att2 = ExampleTestTools.attributeReal(1);
        Attribute att3 = ExampleTestTools.attributeReal(2);
        Attribute att4 = ExampleTestTools.attributeReal(3);
        Attribute att5 = ExampleTestTools.attributeReal(4);
        Attribute att6 = ExampleTestTools.attributeYesNo();
        attributeSet.addAttribute(att1);
        attributeSet.addAttribute(att2);
        attributeSet.addAttribute(att3);
        attributeSet.addAttribute(att4);
        attributeSet.addAttribute(att5);
        attributeSet.setSpecialAttribute("label", att6);
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        prefixMap.put("l", "label");
        SparseFormatDataRowReader reader = new SparseFormatDataRowReader(new DataRowFactory(14, '.'), format, prefixMap, attributeSet, input, labelInput, -1);
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes());
        table.readExamples(reader);
        ExampleSet exampleSet = table.createExampleSet(attributeSet);
        Iterator r = exampleSet.iterator();
        Example e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 1, column 1", (String)"dog", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 1, column 2", (double)8.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, column 3", (double)0.0, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, column 4", (double)0.0, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, column 5", (double)3.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, label", (String)"yes", (String)e.getValueAsString(att6));
        e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 2, column 1", (String)"cat", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 2, column 2", (double)0.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, column 3", (double)2.5, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, column 4", (double)0.15, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, column 5", (double)0.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, label", (String)"no", (String)e.getValueAsString(att6));
        e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 3, column 1", (String)"dog", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 3, column 2", (double)0.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, column 3", (double)0.0, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, column 4", (double)0.0, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, column 5", (double)1.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, label", (String)"no", (String)e.getValueAsString(att6));
        e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 4, column 1", (String)"dog", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 4, column 2", (double)0.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, column 3", (double)0.0, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, column 4", (double)73.0, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, column 5", (double)0.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, label", (String)"yes", (String)e.getValueAsString(att6));
    }

    public void testFormatXY() throws Exception {
        StringBuffer input = new StringBuffer("# comment" + Tools.getLineSeparator());
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            input.append(String.valueOf(ATTRIBUTE_STRINGS[i]) + " " + LABEL[i] + Tools.getLineSeparator());
            ++i;
        }
        this.readerTest(0, new StringReader(input.toString()), null);
    }

    public void testFormatYX() throws Exception {
        StringBuffer input = new StringBuffer("# comment" + Tools.getLineSeparator());
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            input.append(String.valueOf(LABEL[i]) + " " + ATTRIBUTE_STRINGS[i] + Tools.getLineSeparator());
            ++i;
        }
        this.readerTest(1, new StringReader(input.toString()), null);
    }

    public void testFormatPrefix() throws Exception {
        StringBuffer input = new StringBuffer("# comment" + Tools.getLineSeparator());
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            input.append("l:" + LABEL[i] + " " + ATTRIBUTE_STRINGS[i] + Tools.getLineSeparator());
            ++i;
        }
        this.readerTest(2, new StringReader(input.toString()), null);
    }

    public void testFormatSeparate() throws Exception {
        StringBuffer input = new StringBuffer("# comment" + Tools.getLineSeparator());
        StringBuffer label = new StringBuffer();
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            label.append(String.valueOf(LABEL[i]) + Tools.getLineSeparator());
            input.append(String.valueOf(ATTRIBUTE_STRINGS[i]) + Tools.getLineSeparator());
            ++i;
        }
        this.readerTest(3, new StringReader(input.toString()), new StringReader(label.toString()));
    }
}

