/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.PropertyValueCellEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public abstract class FileValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -8235047960089702819L;
    private JPanel panel = new JPanel();
    private JTextField textField = new JTextField(12);
    private ParameterTypeFile type;
    private GridBagLayout gridBagLayout = new GridBagLayout();

    public FileValueCellEditor(ParameterTypeFile type) {
        this.type = type;
        this.panel.setLayout(this.gridBagLayout);
        this.panel.setToolTipText(type.getDescription());
        this.textField.setToolTipText(type.getDescription());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        this.gridBagLayout.setConstraints(this.textField, c);
        this.panel.add(this.textField);
    }

    protected JButton createFileChooserButton() {
        JButton button = new JButton(" ... ");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileValueCellEditor.this.buttonPressed();
            }
        });
        button.setToolTipText("Select file (" + this.type.getDescription() + ")");
        return button;
    }

    protected void addButton(JButton button, int gridwidth) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = gridwidth;
        c.weightx = 0.0;
        c.fill = 1;
        this.gridBagLayout.setConstraints(button, c);
        this.panel.add(button);
    }

    private void buttonPressed() {
        String value = (String)this.getCellEditorValue();
        File file = value == null || value.length() == 0 ? null : RapidMinerGUI.getMainFrame().getProcess().resolveFileName(value);
        File selectedFile = SwingTools.chooseFile((Component)RapidMinerGUI.getMainFrame(), file, true, this.type instanceof ParameterTypeDirectory, this.type.getExtension(), this.type.getKey());
        if (selectedFile != null) {
            this.setText(selectedFile);
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }

    protected void setText(File file) {
        if (file == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(file.getPath());
        }
    }

    public Object getCellEditorValue() {
        return this.textField.getText().trim().length() == 0 ? null : this.textField.getText().trim();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.textField.setText(value == null ? "" : value.toString());
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }
}

