/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataTablePlotterRenderer
extends AbstractRenderer {
    public static final String PARAMETER_PLOTTER = "plotter";

    public abstract DataTable getDataTable(Object var1, IOContainer var2);

    @Override
    public String getName() {
        return "Plot View";
    }

    public LinkedHashMap<String, Class<? extends Plotter>> getPlotterSelection() {
        return PlotterPanel.COMPLETE_PLOTTER_SELECTION;
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        DataTable dataTable = this.getDataTable(renderable, ioContainer);
        PlotterPanel plotterPanel = new PlotterPanel(dataTable, this.getPlotterSelection());
        String plotterName = null;
        try {
            plotterName = this.getParameterAsString(PARAMETER_PLOTTER);
        }
        catch (UndefinedParameterError e) {
            e.printStackTrace();
        }
        if (plotterName != null) {
            plotterPanel.setSelectedPlotter(plotterName);
            Plotter plotter = plotterPanel.getSelectedPlotter();
            plotter.stopUpdates(true);
            List<ParameterType> plotterParameters = plotter.getParameterTypes();
            if (plotterParameters != null) {
                for (ParameterType type : plotterParameters) {
                    String key = type.getKey();
                    try {
                        String value = this.getParameter(key);
                        if (value == null) continue;
                        plotter.setParameter(dataTable, key, value);
                    }
                    catch (UndefinedParameterError undefinedParameterError) {
                        // empty catch block
                    }
                }
            }
            plotter.getPlotter().setSize(width, height);
            plotter.stopUpdates(false);
        }
        return plotterPanel;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        return new PlotterPanel(this.getDataTable(renderable, ioContainer), this.getPlotterSelection());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        String[] availablePlotterNames = this.getPlotterSelection().keySet().toArray(new String[this.getPlotterSelection().size()]);
        ParameterTypeStringCategory plotterType = null;
        plotterType = availablePlotterNames.length == 0 ? new ParameterTypeStringCategory(PARAMETER_PLOTTER, "Indicates the type of the plotter which should be used.", availablePlotterNames, "dummy") : new ParameterTypeStringCategory(PARAMETER_PLOTTER, "Indicates the type of the plotter which should be used.", availablePlotterNames, availablePlotterNames[0]);
        plotterType.setEditable(false);
        types.add(plotterType);
        for (String plotterName : this.getPlotterSelection().keySet()) {
            Class<? extends Plotter> clazz = this.getPlotterSelection().get(plotterName);
            try {
                Plotter plotter = clazz.newInstance();
                List<ParameterType> plotterParameters = plotter.getParameterTypes();
                if (plotterParameters == null) continue;
                for (ParameterType type : plotterParameters) {
                    type.registerDependencyCondition(new EqualStringCondition(this, PARAMETER_PLOTTER, false, plotterName));
                    type.setHidden(false);
                    type.setExpert(false);
                    types.add(type);
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return types;
    }
}

