/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SaveAsBuildingBlockDialog
extends JDialog {
    private static final long serialVersionUID = 7662184237558085856L;
    private boolean ok = false;
    private JTextField nameField = new JTextField();
    private JTextField descriptionField = new JTextField();

    public SaveAsBuildingBlockDialog(MainFrame mainFrame, Operator operator) {
        super(mainFrame, "Save as Building Block", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JPanel textPanel = SwingTools.createTextPanel("Save this operator as building block", "Save this operator, its parameters and children as a building block which can ease future process setup.Please specify a name and short description for this building block.");
        c.gridwidth = 0;
        layout.setConstraints(textPanel, c);
        mainPanel.add(textPanel);
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        JLabel label = new JLabel("Name");
        label.setToolTipText("The name of the template.");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        this.nameField.setToolTipText("The name of the template.");
        c.gridwidth = 0;
        layout.setConstraints(this.nameField, c);
        mainPanel.add(this.nameField);
        label = new JLabel("Description");
        label.setToolTipText("A short description of this template.");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        this.descriptionField.setToolTipText("A short description of this template.");
        c.gridwidth = 0;
        layout.setConstraints(this.descriptionField, c);
        mainPanel.add(this.descriptionField);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveAsBuildingBlockDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveAsBuildingBlockDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        rootPanel.add((Component)mainPanel, "Center");
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.pack();
        this.setSize(600, 400);
        this.setLocationRelativeTo(mainFrame);
    }

    public boolean isOk() {
        return this.ok;
    }

    public BuildingBlock getBuildingBlock(Operator operator) {
        String name = this.nameField.getText();
        return new BuildingBlock(name, this.descriptionField.getText(), operator.getOperatorDescription().getIconPath(), operator.getXML("", false));
    }

    private boolean checkIfNameOk() {
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a name for this template!");
            return false;
        }
        File[] preDefinedBuildingBlockFiles = ParameterService.getConfigFile("buildingblocks").listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        File[] userDefinedBuildingBlockFiles = ParameterService.getUserRapidMinerDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        File[] buildingBlockFiles = new File[preDefinedBuildingBlockFiles.length + userDefinedBuildingBlockFiles.length];
        System.arraycopy(preDefinedBuildingBlockFiles, 0, buildingBlockFiles, 0, preDefinedBuildingBlockFiles.length);
        System.arraycopy(userDefinedBuildingBlockFiles, 0, buildingBlockFiles, preDefinedBuildingBlockFiles.length, userDefinedBuildingBlockFiles.length);
        int i = 0;
        while (i < buildingBlockFiles.length) {
            String tempName = buildingBlockFiles[i].getName().substring(0, buildingBlockFiles[i].getName().lastIndexOf("."));
            if (tempName.equals(name)) {
                SwingTools.showVerySimpleErrorMessage("Name '" + name + "' is already used." + Tools.getLineSeparator() + "Please change name or delete the old building block before!");
                return false;
            }
            ++i;
        }
        return true;
    }

    private void ok() {
        if (this.checkIfNameOk()) {
            this.ok = true;
            this.dispose();
        }
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }
}

