/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.Attributes;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.JDBCDriverTable;
import com.rapidminer.gui.tools.ProgressMonitor;
import com.rapidminer.gui.tools.ProgressUtils;
import com.rapidminer.gui.tools.SQLEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.wizards.AbstractConfigurationWizard;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.DBExampleSourceConfigurationWizardDataTable;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.DriverInfo;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DBExampleSourceConfigurationWizard
extends AbstractConfigurationWizard {
    private static final long serialVersionUID = 5127262335077061590L;
    private static final int DEFAULT_MAX_ROW_NUMBER = 100;
    private static final String USER_DEFINED_STRING = "User Defined URL (next step)";
    private static final int STEP_USER_DATA = 2;
    private static final int STEP_TABLE_SELECTION = 3;
    private static final int STEP_TYPE_DEFINITION = 4;
    private transient DatabaseHandler handler = null;
    private transient JDBCProperties properties = null;
    private boolean isConnected = false;
    Map<String, List<ColumnIdentifier>> attributeNameMap = new LinkedHashMap<String, List<ColumnIdentifier>>();
    private JComboBox systemComboBox;
    private JTextField serverField = new JTextField(40);
    private JTextField urlField = new JTextField(40);
    private JTextField databaseNameField = new JTextField(40);
    private JTextField userNameField = new JTextField(40);
    private JPasswordField passwordField = new JPasswordField(40);
    private String password = null;
    private boolean passwordFromTextField = false;
    private boolean showSystemSetup = true;
    private boolean showOnlyTableNames = false;
    private JList tableList = new JList();
    private JList attributeList = new JList();
    private JTextArea whereTextArea = new JTextArea(4, 20);
    private SQLEditor sqlQueryTextArea = new SQLEditor();
    private Map<ColumnIdentifier, String> attributeTypeMap = new HashMap<ColumnIdentifier, String>();
    private DBExampleSourceConfigurationWizardDataTable dataView = new DBExampleSourceConfigurationWizardDataTable();

    public DBExampleSourceConfigurationWizard(ConfigurationListener listener, boolean showDrivers, boolean showOnlyTables, boolean showSystemSetup, String selectedSystem, String server, String databaseName) {
        super("Database Example Source Wizard", listener);
        this.showSystemSetup = showSystemSetup;
        this.showOnlyTableNames = showOnlyTables;
        this.addTitleStep(showDrivers);
        String[] knownNames = DatabaseService.getDBSystemNames();
        String[] names = new String[knownNames.length + 1];
        System.arraycopy(knownNames, 0, names, 0, knownNames.length);
        names[names.length - 1] = USER_DEFINED_STRING;
        this.systemComboBox = new JComboBox<String>(names);
        this.addDBSystemSelectionStep();
        this.systemComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBExampleSourceConfigurationWizard.this.updateSystemSelection();
            }
        });
        this.addUserDataStep();
        if (this.showOnlyTableNames) {
            this.addTableSelectionStep();
        } else {
            this.addSQLQueryStep();
        }
        this.addSpecialAttributesStep();
        this.updateSystemSelection();
        this.initStartParameters(listener);
        if (!showSystemSetup) {
            if (selectedSystem != null) {
                this.systemComboBox.setSelectedItem(selectedSystem);
            }
            this.serverField.setText(server);
        }
        if (databaseName != null) {
            this.databaseNameField.setText(databaseName);
        }
    }

    private void addTitleStep(boolean showDrivers) {
        StringBuffer titleString = new StringBuffer();
        titleString.append("This wizard will guide you through the process of data loading from databases. Using this wizard will involve the following steps:<ul>");
        if (this.showSystemSetup) {
            titleString.append("<li>Selection of a database</li>");
        }
        titleString.append("<li>Definition of the username and password</li><li>Selection of tables and attributes (SQL query)</li><li>Definition of special attributes like labels or IDs</li></ul>");
        if (showDrivers) {
            titleString.append("<br>The currently available JDBC drivers are listed below. Please make sure to copy missing drivers into the directory lib/jdbc and restart RapidMiner in order to make additional drivers available.");
        }
        JPanel panel = SwingTools.createTextPanel("Welcome to the Database Example Source Wizard", titleString.toString());
        if (showDrivers) {
            DriverInfo[] drivers = DatabaseService.getAllDriverInfos();
            JDBCDriverTable driverTable = new JDBCDriverTable(drivers);
            panel.add((Component)new JScrollPane(driverTable), "Center");
        }
        this.addStep(panel);
    }

    private void addDBSystemSelectionStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify your database system...", "Please specify your database system. If your system is not available, you can select \"User Defined URL (next step)\" and define an appropriate connection URL for your system in the next step. If the connection fails because no suitable driver is available, you might copy a driver library into the directory lib/jdbc and it will be available after the next start of RapidMiner.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("Database System:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        if (!this.showSystemSetup) {
            this.systemComboBox.setEnabled(false);
        }
        layout.setConstraints(this.systemComboBox, c);
        content.add(this.systemComboBox);
        label = new JLabel("Server Name or IP:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        if (!this.showSystemSetup) {
            this.serverField.setEnabled(false);
        }
        layout.setConstraints(this.serverField, c);
        content.add(this.serverField);
        label = new JLabel("Database Name:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.databaseNameField, c);
        content.add(this.databaseNameField);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addUserDataStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify the connection data...", "Please check the connection URL and adapt it if necessary (or define it in cases where your database system was not available in the dialog before). Please specify the user name and the password. If the password field remains empty you will be prompted for it during connections. You can validate the connection to the database by pressing the \"Test Connection\" button. Please note that after pressing \"Next\" a connection to your database will be made in order to retrieve table and attribute names (this may take some minutes).");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("URL:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.urlField, c);
        content.add(this.urlField);
        JPanel fillPanel = new JPanel();
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        label = new JLabel("User:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.userNameField, c);
        content.add(this.userNameField);
        label = new JLabel("Password:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.passwordField, c);
        content.add(this.passwordField);
        JPanel testButtonPanel = new JPanel(new FlowLayout(1));
        JButton testButton = new JButton("Test Connection");
        testButton.setToolTipText("Tests the connection to the database based on the current settings.");
        testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBExampleSourceConfigurationWizard.this.testConnection();
            }
        });
        testButtonPanel.add(testButton);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(testButtonPanel, c);
        content.add(testButtonPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addTableSelectionStep() {
        JPanel panel = SwingTools.createTextPanel("Please select a single table...", "Please specify the table which is the base for this data access.");
        this.tableList.setSelectionMode(0);
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBExampleSourceConfigurationWizard.this.updateAttributeNames();
            }
        });
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.tableList);
        tablePane.setBorder(BorderFactory.createTitledBorder("Tables"));
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel content = new JPanel(layout);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(7, 7, 7, 7);
        c.gridwidth = 0;
        layout.setConstraints(tablePane, c);
        content.add(tablePane);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addSQLQueryStep() {
        JPanel panel = SwingTools.createTextPanel("Please select tables and attributes...", "Please specify the tables, the attributes and an optional where clause which will be used to create a query statement to retrieve the data. You can modify the statement in the text field below.");
        JPanel gridPanel = new JPanel(new GridLayout(1, 3));
        this.tableList.setSelectionMode(2);
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBExampleSourceConfigurationWizard.this.updateAttributeNames();
                DBExampleSourceConfigurationWizard.this.updateSQLQuery();
            }
        });
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.tableList);
        tablePane.setBorder(BorderFactory.createTitledBorder("Tables"));
        gridPanel.add(tablePane);
        this.attributeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBExampleSourceConfigurationWizard.this.updateSQLQuery();
            }
        });
        ExtendedJScrollPane attributePane = new ExtendedJScrollPane(this.attributeList);
        attributePane.setBorder(BorderFactory.createTitledBorder("Attributes"));
        gridPanel.add(attributePane);
        this.whereTextArea.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DBExampleSourceConfigurationWizard.this.updateSQLQuery();
            }
        });
        ExtendedJScrollPane whereTextPane = new ExtendedJScrollPane(this.whereTextArea);
        whereTextPane.setBorder(BorderFactory.createTitledBorder("Where Clause"));
        gridPanel.add(whereTextPane);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel content = new JPanel(layout);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.insets = new Insets(7, 7, 7, 7);
        c.gridwidth = 0;
        layout.setConstraints(gridPanel, c);
        content.add(gridPanel);
        c.weighty = 1.0;
        this.sqlQueryTextArea.setBorder(BorderFactory.createTitledBorder("SQL Query"));
        layout.setConstraints(this.sqlQueryTextArea, c);
        content.add(this.sqlQueryTextArea);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addSpecialAttributesStep() {
        JPanel panel = SwingTools.createTextPanel("Please define special attributes...", "Please define which columns should be used as special attributes like labels or Ids (if any). After pressing finish the necessary settings will be made for the operator.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        ExtendedJScrollPane typeViewPane = new ExtendedJScrollPane(this.dataView);
        typeViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Data and Attribute Types View (Sample)")));
        layout.setConstraints(typeViewPane, c);
        content.add(typeViewPane);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    protected void performStepAction(int currentStep, int oldStep) {
        if (currentStep == 2) {
            this.password = null;
            if (this.systemComboBox.getSelectedIndex() < DatabaseService.getJDBCProperties().size()) {
                this.urlField.setText(this.createPredefinedDatabaseURL());
            }
        } else if (currentStep == 3) {
            if (oldStep < currentStep) {
                try {
                    this.retrieveTableAndAttributeNames();
                }
                catch (SQLException e) {
                    this.showConnectionError("Cannot retrieve table and attribute names", e);
                }
            }
        } else if (currentStep == 4) {
            try {
                this.updateDataView();
            }
            catch (SQLException e) {
                this.showConnectionError("Cannot retrieve sample data", e);
            }
        }
    }

    private void updateSystemSelection() {
        if (!this.showSystemSetup) {
            this.serverField.setEnabled(false);
        } else if (this.systemComboBox.getSelectedIndex() >= DatabaseService.getJDBCProperties().size()) {
            this.serverField.setEnabled(false);
            this.databaseNameField.setEnabled(false);
            JDBCProperties defaultProps = JDBCProperties.createDefaultJDBCProperties();
            String defaultString = String.valueOf(defaultProps.getUrlPrefix()) + "server" + ":port" + defaultProps.getDbNameSeperator() + "database_name";
            this.urlField.setText(defaultString);
        } else {
            this.serverField.setEnabled(true);
            this.databaseNameField.setEnabled(true);
        }
    }

    private String getDatabaseURL() {
        return this.urlField.getText().trim();
    }

    private String createPredefinedDatabaseURL() {
        int index = this.systemComboBox.getSelectedIndex();
        String serverName = this.serverField.getText().trim();
        if (serverName == null || serverName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a database server name or IP!");
            return "";
        }
        String databaseName = this.databaseNameField.getText().trim();
        if (databaseName == null || databaseName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a database name!");
            return "";
        }
        String portString = "";
        String defaultPort = DatabaseService.getJDBCProperties().get(index).getDefaultPort();
        if (defaultPort.length() > 0) {
            portString = ":" + defaultPort;
        }
        return String.valueOf(DatabaseService.getJDBCProperties().get(index).getUrlPrefix()) + serverName + portString + DatabaseService.getJDBCProperties().get(index).getDbNameSeperator() + databaseName;
    }

    private void testConnection() {
        try {
            if (!this.connect()) {
                throw new SQLException("Connection was not possible!");
            }
            this.disconnect();
            JOptionPane.showMessageDialog(this, "Connection to database is possible.", "Connection OK", 1);
        }
        catch (SQLException e) {
            this.showConnectionError(null, e);
        }
    }

    private boolean connect() throws SQLException {
        String urlString = this.getDatabaseURL();
        if (urlString != null && urlString.length() > 0) {
            if (this.isConnected) {
                this.handler.disconnect();
                this.handler = null;
            }
            int selectedSystem = this.systemComboBox.getSelectedIndex();
            JDBCProperties jdbcProperties = JDBCProperties.createDefaultJDBCProperties();
            if (selectedSystem >= 0 && selectedSystem < DatabaseService.getJDBCProperties().size() - 1) {
                jdbcProperties = DatabaseService.getJDBCProperties().get(this.systemComboBox.getSelectedIndex());
            }
            this.handler = new DatabaseHandler(urlString, jdbcProperties);
            this.properties = this.handler.getProperties();
            String userName = null;
            String passwd = null;
            if (urlString.indexOf("AuthenticationMethod") < 0) {
                userName = this.userNameField.getText().trim();
                if (userName == null || userName.length() == 0) {
                    SwingTools.showVerySimpleErrorMessage("Please specify a user name!");
                    return false;
                }
                passwd = this.password;
                if (passwd == null) {
                    passwd = new String(this.passwordField.getPassword());
                    if (passwd == null || passwd.length() == 0) {
                        passwd = RapidMiner.getInputHandler().inputPassword("Password for user '" + userName + "' required:");
                        this.passwordFromTextField = false;
                    } else {
                        this.passwordFromTextField = true;
                    }
                }
            }
            this.handler.connect(userName, passwd, true);
            this.password = passwd;
            this.isConnected = true;
            return true;
        }
        SwingTools.showVerySimpleErrorMessage("Please specify the necessary connection data!");
        return false;
    }

    private void disconnect() throws SQLException {
        if (this.isConnected) {
            this.handler.disconnect();
            this.handler = null;
            this.isConnected = false;
        }
    }

    private void retrieveTableAndAttributeNames() throws SQLException {
        this.connect();
        Thread retrieveTablesThread = new Thread(){

            public void run() {
                ProgressMonitor monitor = ProgressUtils.createProgressMonitor(DBExampleSourceConfigurationWizard.this, 100, true, 50, true);
                monitor.start("Fetching tables and attributes from database...");
                try {
                    DBExampleSourceConfigurationWizard.this.attributeNameMap.clear();
                    if (DBExampleSourceConfigurationWizard.this.handler != null) {
                        try {
                            Map<String, List<ColumnIdentifier>> newAttributeMap = DBExampleSourceConfigurationWizard.this.handler.getAllTableMetaData();
                            DBExampleSourceConfigurationWizard.this.attributeNameMap.putAll(newAttributeMap);
                        }
                        catch (SQLException e) {
                            DBExampleSourceConfigurationWizard.this.showSQLError("Retrieval of table and attribute names failed", e);
                        }
                    }
                    String[] allNames = new String[DBExampleSourceConfigurationWizard.this.attributeNameMap.size()];
                    DBExampleSourceConfigurationWizard.this.attributeNameMap.keySet().toArray(allNames);
                    DBExampleSourceConfigurationWizard.this.tableList.removeAll();
                    DBExampleSourceConfigurationWizard.this.tableList.setListData(allNames);
                }
                finally {
                    if (monitor.getCurrent() != monitor.getTotal()) {
                        monitor.setCurrent(null, monitor.getTotal());
                    }
                    try {
                        DBExampleSourceConfigurationWizard.this.disconnect();
                    }
                    catch (SQLException e) {
                        DBExampleSourceConfigurationWizard.this.showSQLError("Disconnecting from the database failed", e);
                    }
                }
            }
        };
        retrieveTablesThread.start();
    }

    private void updateAttributeNames() {
        Object[] selection;
        LinkedList<ColumnIdentifier> allColumnIdentifiers = new LinkedList<ColumnIdentifier>();
        Object[] objectArray = selection = this.tableList.getSelectedValues();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            String tableName = (String)o;
            List<ColumnIdentifier> attributeNames = this.attributeNameMap.get(tableName);
            if (attributeNames != null) {
                for (ColumnIdentifier currentIdentifier : attributeNames) {
                    allColumnIdentifiers.add(currentIdentifier);
                }
            }
            ++n2;
        }
        this.attributeList.removeAll();
        ColumnIdentifier[] identifierArray = new ColumnIdentifier[allColumnIdentifiers.size()];
        allColumnIdentifiers.toArray(identifierArray);
        this.attributeList.setListData(identifierArray);
    }

    private void updateDataView() throws SQLException {
        ColumnIdentifier currentColumn;
        int i;
        this.attributeTypeMap.clear();
        Object[] attributeSelection = this.attributeList.getSelectedValues();
        ColumnIdentifier[] usedAttributes = null;
        if (attributeSelection.length == 0) {
            usedAttributes = new ColumnIdentifier[this.attributeList.getModel().getSize()];
            i = 0;
            while (i < this.attributeList.getModel().getSize()) {
                usedAttributes[i] = currentColumn = (ColumnIdentifier)this.attributeList.getModel().getElementAt(i);
                this.attributeTypeMap.put(currentColumn, "attribute");
                ++i;
            }
        } else {
            usedAttributes = new ColumnIdentifier[attributeSelection.length];
            i = 0;
            while (i < attributeSelection.length) {
                usedAttributes[i] = currentColumn = (ColumnIdentifier)attributeSelection[i];
                this.attributeTypeMap.put(currentColumn, "attribute");
                ++i;
            }
        }
        LinkedList<String[]> data = new LinkedList<String[]>();
        this.connect();
        if (this.handler != null) {
            Statement statement = this.handler.createStatement(false);
            statement.setMaxRows(100);
            String query = this.getQueryString();
            ResultSet resultSet = statement.executeQuery(query);
            int counter = 0;
            while (resultSet.next() && counter < 100) {
                String[] row = new String[usedAttributes.length];
                int c = 0;
                while (c < row.length) {
                    row[c] = resultSet.getString(c + 1);
                    ++c;
                }
                data.add(row);
                ++counter;
            }
            resultSet.close();
            statement.close();
        }
        this.disconnect();
        this.dataView.update(usedAttributes, data, this.attributeTypeMap);
    }

    private void appendAttributeName(StringBuffer result, ColumnIdentifier identifier, boolean first, boolean singleTable) {
        if (!first) {
            result.append(", ");
        }
        if (singleTable) {
            result.append(identifier.getFullName(this.properties, singleTable));
        } else {
            result.append(String.valueOf(identifier.getFullName(this.properties, singleTable)) + " AS " + identifier.getAliasName(this.properties, singleTable));
        }
    }

    private void updateSQLQuery() {
        int n;
        Object[] objectArray;
        boolean first;
        Object[] tableSelection = this.tableList.getSelectedValues();
        if (tableSelection.length == 0) {
            this.sqlQueryTextArea.setText("");
            return;
        }
        boolean singleTable = tableSelection.length == 1;
        StringBuffer result = new StringBuffer("SELECT ");
        Object[] attributeSelection = this.attributeList.getSelectedValues();
        if (singleTable && (attributeSelection.length == 0 || attributeSelection.length == this.attributeList.getModel().getSize())) {
            result.append("*");
        } else if (attributeSelection.length == 0 || attributeSelection.length == this.attributeList.getModel().getSize()) {
            first = true;
            int i = 0;
            while (i < this.attributeList.getModel().getSize()) {
                ColumnIdentifier identifier = (ColumnIdentifier)this.attributeList.getModel().getElementAt(i);
                this.appendAttributeName(result, identifier, first, singleTable);
                first = false;
                ++i;
            }
        } else {
            first = true;
            objectArray = attributeSelection;
            n = attributeSelection.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ColumnIdentifier identifier = (ColumnIdentifier)o;
                this.appendAttributeName(result, identifier, first, singleTable);
                first = false;
                ++n2;
            }
        }
        result.append(String.valueOf(Tools.getLineSeparator()) + "FROM ");
        first = true;
        objectArray = tableSelection;
        n = tableSelection.length;
        int n3 = 0;
        while (n3 < n) {
            Object o = objectArray[n3];
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            String tableName = (String)o;
            result.append(String.valueOf(this.properties.getIdentifierQuoteOpen()) + tableName + this.properties.getIdentifierQuoteClose());
            ++n3;
        }
        String whereText = this.whereTextArea.getText().trim();
        if (whereText.length() > 0) {
            result.append(String.valueOf(Tools.getLineSeparator()) + "WHERE " + whereText);
        }
        this.sqlQueryTextArea.setText(result.toString());
    }

    private String getQueryString() {
        String result = null;
        if (this.showOnlyTableNames) {
            result = "SELECT * FROM " + this.properties.getIdentifierQuoteOpen() + this.tableList.getSelectedValue() + this.properties.getIdentifierQuoteClose();
        } else {
            result = this.sqlQueryTextArea.getText().trim();
            result = result.replaceAll(Tools.getLineSeparator(), " ");
        }
        return result;
    }

    private void showConnectionError(String message, SQLException e) {
        JOptionPane.showMessageDialog(this, String.valueOf(message != null ? String.valueOf(message) + ": " : "") + "Connection to database has failed:" + Tools.getLineSeparator() + e.getMessage().substring(0, Math.min(300, e.getMessage().length())) + "...", "Connection failed", 0);
    }

    private void showSQLError(String message, SQLException e) {
        JOptionPane.showMessageDialog(this, String.valueOf(message != null ? String.valueOf(message) + ": " : "") + e.getMessage(), "SQL Error", 0);
    }

    protected void initStartParameters(ConfigurationListener listener) {
        Parameters parameters = listener.getParameters();
        int dbIndex = -1;
        try {
            String systemObject = parameters.getParameter("database_system");
            if (systemObject != null) {
                dbIndex = Integer.valueOf(systemObject);
                this.systemComboBox.setSelectedIndex(dbIndex);
            }
        }
        catch (UndefinedParameterError systemObject) {
            // empty catch block
        }
        try {
            String urlObject = parameters.getParameter("database_url");
            if (urlObject != null) {
                String urlString = urlObject.toString();
                this.urlField.setText(urlString);
                JDBCProperties props = DatabaseService.getJDBCProperties().get(dbIndex);
                String urlPrefix = props.getUrlPrefix();
                String dbNameSeparator = props.getDbNameSeperator();
                int serverStart = urlPrefix.length();
                int serverEnd = -1;
                if (urlString.indexOf(":") >= 0) {
                    serverEnd = urlString.indexOf(":", serverStart + 1);
                } else if (urlString.indexOf(dbNameSeparator, serverStart + 1) >= 0) {
                    serverEnd = urlString.indexOf(dbNameSeparator);
                }
                if (serverEnd >= serverStart && serverStart < urlString.length()) {
                    String serverName = urlString.substring(serverStart, serverEnd);
                    this.serverField.setText(serverName);
                }
                int dbStart = -1;
                if (urlString.indexOf(dbNameSeparator, serverStart + 1) >= 0) {
                    dbStart = urlString.lastIndexOf(dbNameSeparator) + dbNameSeparator.length();
                }
                if (dbStart >= 0) {
                    String dbName = urlString.substring(dbStart);
                    this.databaseNameField.setText(dbName);
                }
            }
        }
        catch (UndefinedParameterError urlObject) {
            // empty catch block
        }
        try {
            String userNameObject = parameters.getParameter("username");
            if (userNameObject != null) {
                this.userNameField.setText(userNameObject.toString());
            }
        }
        catch (UndefinedParameterError userNameObject) {
            // empty catch block
        }
        try {
            String passwordObject = parameters.getParameter("password");
            if (passwordObject != null) {
                this.passwordField.setText(passwordObject.toString());
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
    }

    protected void finish(ConfigurationListener listener) {
        try {
            this.disconnect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String sqlQueryString = this.getQueryString();
        String databaseURL = this.urlField.getText().trim();
        String userName = this.userNameField.getText().trim();
        if (databaseURL.length() == 0 || !this.showOnlyTableNames && sqlQueryString.length() == 0 || userName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("You must specify a database connection and proper settings - the operator will not work without this." + Tools.getLineSeparator() + "Please select \"Cancel\" if you want to abort this wizard.");
        } else {
            Parameters parameters = listener.getParameters();
            parameters.setParameter("work_on_database", "false");
            parameters.setParameter("database_system", String.valueOf(this.systemComboBox.getSelectedIndex()));
            parameters.setParameter("database_url", databaseURL);
            parameters.setParameter("username", userName);
            parameters.setParameter("password", null);
            if (this.passwordFromTextField) {
                parameters.setParameter("password", new String(this.passwordField.getPassword()));
            }
            if (this.showOnlyTableNames) {
                String tableName = this.tableList.getSelectedValue().toString();
                parameters.setParameter("table_name", tableName);
            } else {
                parameters.setParameter("query", sqlQueryString);
                parameters.setParameter("query_file", null);
                parameters.setParameter("table_name", null);
            }
            parameters.setParameter("label_attribute", null);
            parameters.setParameter("id_attribute", null);
            parameters.setParameter("weight_attribute", null);
            int i = 1;
            while (i < Attributes.KNOWN_ATTRIBUTE_TYPES.length) {
                this.ensureAttributeTypeIsUnique(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
                ++i;
            }
            boolean singleTable = this.tableList.getSelectedValues().length == 1;
            for (ColumnIdentifier attributeIdentifier : this.attributeTypeMap.keySet()) {
                String attType = this.attributeTypeMap.get(attributeIdentifier);
                String maskedAttributeName = attributeIdentifier.getAliasName(this.properties, singleTable);
                maskedAttributeName = maskedAttributeName.substring(1, maskedAttributeName.length() - 1);
                if (attType.equals("label")) {
                    parameters.setParameter("label_attribute", maskedAttributeName);
                    continue;
                }
                if (attType.equals("id")) {
                    parameters.setParameter("id_attribute", maskedAttributeName);
                    continue;
                }
                if (!attType.equals("weight")) continue;
                parameters.setParameter("weight_attribute", maskedAttributeName);
            }
            listener.setParameters(parameters);
            this.dispose();
            RapidMinerGUI.getMainFrame().getPropertyTable().refresh();
        }
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<ColumnIdentifier> columns = new LinkedList<ColumnIdentifier>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator<ColumnIdentifier> i = this.attributeTypeMap.keySet().iterator();
        int j = 0;
        while (i.hasNext()) {
            ColumnIdentifier attributeIdentifier = i.next();
            String attType = this.attributeTypeMap.get(attributeIdentifier);
            if (attType.equals(type)) {
                columns.add(attributeIdentifier);
                columnNumbers.add(j);
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] identifiers = new ColumnIdentifier[columns.size()];
            columns.toArray(identifiers);
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            ColumnIdentifier selection = (ColumnIdentifier)JOptionPane.showInputDialog(this, message, String.valueOf(type) + " multiply defined", 2, null, identifiers, identifiers[0]);
            if (selection != null) {
                for (ColumnIdentifier name : columns) {
                    if (name.equals(selection)) continue;
                    this.attributeTypeMap.remove(name);
                    this.attributeTypeMap.put(name, "attribute");
                }
            }
        }
    }

    protected void cancel() {
        try {
            this.disconnect();
        }
        catch (SQLException e) {
            LogService.getGlobal().log("Problem during disconnecting: " + e.getMessage(), 5);
        }
        super.cancel();
    }
}

