/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.operator.AddListener;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.tools.Tools;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperatorChain
extends Operator {
    private Vector<Operator> operators = new Vector();
    private List<AddListener> addListeners = new LinkedList<AddListener>();

    public OperatorChain(OperatorDescription description) {
        super(description);
    }

    public abstract int getMaxNumberOfInnerOperators();

    public abstract int getMinNumberOfInnerOperators();

    public abstract InnerOperatorCondition getInnerOperatorCondition();

    public void addAddListener(AddListener listener) {
        this.addListeners.add(listener);
    }

    public void removeAddListener(AddListener listener) {
        this.addListeners.remove(listener);
    }

    private void fireAddEvent(Operator child) {
        Iterator<AddListener> i = this.addListeners.iterator();
        while (i.hasNext()) {
            i.next().operatorAdded(child);
        }
    }

    @Override
    public Operator cloneOperator(String name) {
        OperatorChain clone = (OperatorChain)super.cloneOperator(name);
        clone.operators = new Vector();
        for (Operator originalChild : this.operators) {
            Operator clonedChild = originalChild.cloneOperator(originalChild.getName());
            clonedChild.setParent(clone);
            clone.addOperator(clonedChild);
        }
        return clone;
    }

    @Override
    public Class<?>[] checkIO(Class<?>[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        InnerOperatorCondition condition = this.getInnerOperatorCondition();
        Class[] innerOutput = condition.checkIO(this, input);
        LinkedList nonConsumedList = new LinkedList();
        if (this.shouldAddNonConsumedInput()) {
            Class<?> clazz;
            Class<?>[] classArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                clazz = classArray[n2];
                nonConsumedList.add(clazz);
                ++n2;
            }
            Class<?>[] classArray2 = this.getInputClasses();
            n = classArray2.length;
            n2 = 0;
            while (n2 < n) {
                clazz = classArray2[n2];
                nonConsumedList.remove(clazz);
                ++n2;
            }
        }
        Class[] directResult = null;
        directResult = this.shouldReturnInnerOutput() ? this.getAllOutputClasses(innerOutput) : this.getDeliveredOutputClasses();
        Class[] finalResult = new Class[directResult.length + nonConsumedList.size()];
        System.arraycopy(directResult, 0, finalResult, 0, directResult.length);
        int index = directResult.length;
        for (Class clazz : nonConsumedList) {
            finalResult[index++] = clazz;
        }
        return finalResult;
    }

    protected boolean shouldReturnInnerOutput() {
        return false;
    }

    protected boolean shouldAddNonConsumedInput() {
        return !this.shouldReturnInnerOutput();
    }

    private Class[] getAllOutputClasses(Class[] innerOutput) {
        Class<?>[] deliveredOutput = this.getDeliveredOutputClasses();
        Class[] result = new Class[deliveredOutput.length + innerOutput.length];
        System.arraycopy(deliveredOutput, 0, result, 0, deliveredOutput.length);
        System.arraycopy(innerOutput, 0, result, deliveredOutput.length, innerOutput.length);
        return result;
    }

    public final int addOperator(Operator o) {
        return this.addOperator(o, this.getNumberOfAllOperators());
    }

    public final int addOperator(Operator operator, int index) {
        if (operator == null) {
            return -1;
        }
        operator.setParent(this);
        this.operators.add(index, operator);
        Process process = this.getProcess();
        if (process != null) {
            operator.registerOperator(process);
        }
        if (this.getNumberOfOperators() == this.getMaxNumberOfInnerOperators() + 1) {
            this.logWarning("More than " + this.getMaxNumberOfInnerOperators() + " inner operators!");
        }
        this.fireAddEvent(operator);
        return index;
    }

    @Override
    protected void registerOperator(Process process) {
        super.registerOperator(process);
        for (Operator child : this.operators) {
            child.registerOperator(process);
        }
    }

    @Override
    protected void unregisterOperator(Process process) {
        super.unregisterOperator(process);
        for (Operator operator : this.operators) {
            operator.unregisterOperator(process);
        }
    }

    protected final void removeOperator(Operator operator) {
        this.operators.remove(operator);
    }

    public Operator getOperator(int i) {
        if (i < 0 || i >= this.getNumberOfOperators()) {
            throw new RuntimeException("Illegal operator index in getOperator() (" + this.getName() + "): " + i);
        }
        int counter = 0;
        for (Operator operator : this.operators) {
            if (!operator.isEnabled()) continue;
            if (counter == i) {
                return operator;
            }
            ++counter;
        }
        return null;
    }

    public Iterator<Operator> getOperators() {
        return this.operators.iterator();
    }

    public List<Operator> getAllInnerOperators() {
        LinkedList<Operator> children = new LinkedList<Operator>();
        int i = 0;
        while (i < this.operators.size()) {
            Operator innerOp = this.operators.get(i);
            children.add(innerOp);
            if (innerOp instanceof OperatorChain) {
                children.addAll(((OperatorChain)innerOp).getAllInnerOperators());
            }
            ++i;
        }
        return children;
    }

    public int getNumberOfOperators() {
        int number = 0;
        for (Operator op : this.operators) {
            if (!op.isEnabled()) continue;
            ++number;
        }
        return number;
    }

    public int getNumberOfAllOperators() {
        return this.operators.size();
    }

    public Operator getOperatorFromAll(int i) {
        return this.operators.get(i);
    }

    public int getIndexOfOperator(Operator operator, boolean useDisabled) {
        if (useDisabled) {
            return this.operators.indexOf(operator);
        }
        int index = 0;
        for (Operator current : this.operators) {
            if (!current.isEnabled()) continue;
            if (current.equals(operator)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Operator getInnerOperatorForName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals(this.getName())) {
            return this;
        }
        for (Operator inner : this.operators) {
            Operator innerinner;
            if (name.equals(inner.getName())) {
                return inner;
            }
            if (!(inner instanceof OperatorChain) || (innerinner = ((OperatorChain)inner).getInnerOperatorForName(name)) == null) continue;
            return innerinner;
        }
        return null;
    }

    @Override
    public void processStarts() throws OperatorException {
        super.processStarts();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            this.getOperator(i).processStarts();
            ++i;
        }
    }

    @Override
    public void processFinished() throws OperatorException {
        super.processFinished();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            this.getOperator(i).processFinished();
            ++i;
        }
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        Enumeration<Operator> i = this.operators.elements();
        while (i.hasMoreElements()) {
            Operator next;
            try {
                next = i.nextElement();
            }
            catch (ConcurrentModificationException e) {
                if (this.isDebugMode()) {
                    e.printStackTrace();
                }
                throw new UserError(this, 923);
            }
            input = next.apply(input);
        }
        return input.getIOObjects();
    }

    @Override
    public void performAdditionalChecks() throws UserError {
        for (Operator o : this.operators) {
            if (!o.isEnabled()) continue;
            o.performAdditionalChecks();
        }
    }

    @Override
    public int checkProperties() {
        int errorCount = super.checkProperties();
        for (Operator o : this.operators) {
            if (!o.isEnabled()) continue;
            errorCount += o.checkProperties();
        }
        return errorCount;
    }

    @Override
    public int checkDeprecations() {
        int deprecationCount = super.checkDeprecations();
        for (Operator o : this.operators) {
            deprecationCount += o.checkDeprecations();
        }
        return deprecationCount;
    }

    public int checkNumberOfInnerOperators() {
        int errorCount = 0;
        if (this.getNumberOfOperators() < this.getMinNumberOfInnerOperators() || this.getNumberOfOperators() > this.getMaxNumberOfInnerOperators()) {
            int maximum = this.getMaxNumberOfInnerOperators();
            String maximumString = maximum == Integer.MAX_VALUE ? "infinity" : String.valueOf(maximum);
            String message = "Operator has " + this.getNumberOfOperators() + " " + (this.getNumberOfOperators() == 1 ? "child" : "children") + ", should be " + (this.getMinNumberOfInnerOperators() == this.getMaxNumberOfInnerOperators() ? String.valueOf(this.getMinNumberOfInnerOperators()) : " between " + this.getMinNumberOfInnerOperators() + " and " + maximumString);
            this.addError(message);
            ++errorCount;
        }
        for (Operator o : this.operators) {
            if (!(o instanceof OperatorChain) || !o.isEnabled()) continue;
            errorCount += ((OperatorChain)o).checkNumberOfInnerOperators();
        }
        return errorCount;
    }

    @Override
    @Deprecated
    protected String createExperimentTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        return this.createProcessTree(indent, selfPrefix, childPrefix, markOperator, mark);
    }

    @Override
    protected String createProcessTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        String tree = super.createProcessTree(indent, selfPrefix, childPrefix, markOperator, mark);
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            Operator o = i.next();
            tree = String.valueOf(tree) + Tools.getLineSeparator() + o.createProcessTree(indent, String.valueOf(childPrefix) + "+- ", String.valueOf(childPrefix) + (i.hasNext() ? "|  " : "   "), markOperator, mark);
        }
        return tree;
    }

    @Override
    protected final String getInnerOperatorsXML(String indent, boolean hideDefault) {
        StringBuffer result = new StringBuffer();
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            result.append(i.next().getXML(indent, hideDefault));
        }
        return result.toString();
    }

    @Override
    public void clearErrorList() {
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            i.next().clearErrorList();
        }
        super.clearErrorList();
    }
}

