/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.FlatFuzzyClusterModel;
import com.rapidminer.operator.learner.PredictionModel;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterToPrediction
extends Operator {
    public ClusterToPrediction(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int minimum;
        int j;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        ClusterModel model = this.getInput(ClusterModel.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError(this, 105);
        }
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        PredictionModel.createPredictedLabel(exampleSet, labelAttribute);
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        HashMap<Integer, String> intToClusterMapping = new HashMap<Integer, String>();
        int[][] mappingTable = new int[model.getNumberOfClusters()][model.getNumberOfClusters()];
        int a = 0;
        int i = 0;
        while (i < model.getNumberOfClusters()) {
            HashMap<String, Integer> labelOccurrence = new HashMap<String, Integer>();
            for (Example example : exampleSet) {
                String label = example.getValueAsString(labelAttribute);
                if (!labelOccurrence.containsKey(label)) {
                    labelOccurrence.put(label, 0);
                    if (i == 0) {
                        intToClusterMapping.put(a, label);
                        ++a;
                    }
                }
                if (example.getValue(example.getAttributes().getCluster()) != (double)i) continue;
                labelOccurrence.put(label, (Integer)labelOccurrence.get(label) + 1);
            }
            if (i == 0 && model.getNumberOfClusters() != labelOccurrence.size()) {
                throw new UserError((Operator)this, 943, labelOccurrence.size(), model.getNumberOfClusters());
            }
            j = 0;
            while (j < mappingTable[i].length) {
                int occ;
                String clusterName = (String)intToClusterMapping.get(j);
                mappingTable[i][j] = occ = ((Integer)labelOccurrence.get(clusterName)).intValue();
                ++j;
            }
            ++i;
        }
        int maxValue = -1;
        int i2 = 0;
        while (i2 < mappingTable.length) {
            j = 0;
            while (j < mappingTable[i2].length) {
                if (mappingTable[i2][j] > maxValue) {
                    maxValue = mappingTable[i2][j];
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < mappingTable.length) {
            minimum = Integer.MAX_VALUE;
            int j2 = 0;
            while (j2 < mappingTable[i2].length) {
                mappingTable[i2][j2] = maxValue - mappingTable[i2][j2];
                if (mappingTable[i2][j2] < minimum) {
                    minimum = mappingTable[i2][j2];
                }
                ++j2;
            }
            if (minimum > 0) {
                j2 = 0;
                while (j2 < mappingTable[i2].length) {
                    mappingTable[i2][j2] = mappingTable[i2][j2] - minimum;
                    ++j2;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < mappingTable[0].length) {
            minimum = Integer.MAX_VALUE;
            int j3 = 0;
            while (j3 < mappingTable.length) {
                if (mappingTable[j3][i2] < minimum) {
                    minimum = mappingTable[j3][i2];
                }
                ++j3;
            }
            if (minimum > 0) {
                j3 = 0;
                while (j3 < mappingTable.length) {
                    mappingTable[j3][i2] = mappingTable[j3][i2] - minimum;
                    ++j3;
                }
            }
            ++i2;
        }
        while (!this.assignmentAvailable(mappingTable)) {
            int j4;
            int j5;
            Vector<Integer> markedRows = new Vector<Integer>();
            Vector<Integer> markedColumns = new Vector<Integer>();
            int i3 = 0;
            while (i3 < mappingTable[0].length) {
                boolean markedZero = false;
                j5 = 0;
                while (j5 < mappingTable.length) {
                    if (mappingTable[j5][i3] == Integer.MIN_VALUE) {
                        markedZero = true;
                        break;
                    }
                    ++j5;
                }
                if (!markedZero) {
                    markedRows.add(i3);
                }
                ++i3;
            }
            boolean newMarked = true;
            while (newMarked) {
                newMarked = false;
                int i4 = 0;
                while (i4 < mappingTable.length) {
                    j5 = 0;
                    while (j5 < mappingTable[i4].length) {
                        if (mappingTable[i4][j5] == Integer.MAX_VALUE && markedRows.contains(j5) && !markedColumns.contains(i4)) {
                            newMarked = true;
                            markedColumns.add(i4);
                        }
                        ++j5;
                    }
                    ++i4;
                }
                i4 = 0;
                while (i4 < mappingTable[0].length) {
                    j5 = 0;
                    while (j5 < mappingTable.length) {
                        if (mappingTable[j5][i4] == Integer.MIN_VALUE && markedColumns.contains(j5) && !markedRows.contains(i4)) {
                            newMarked = true;
                            markedRows.add(i4);
                        }
                        ++j5;
                    }
                    ++i4;
                }
            }
            int i5 = 0;
            while (i5 < mappingTable.length) {
                if (!markedColumns.contains(i5)) {
                    markedColumns.add(i5);
                } else {
                    markedColumns.removeElement(i5);
                }
                ++i5;
            }
            int minimum2 = Integer.MAX_VALUE;
            int i6 = 0;
            while (i6 < markedRows.size()) {
                j4 = 0;
                while (j4 < markedColumns.size()) {
                    if (mappingTable[(Integer)markedColumns.get(j4)][(Integer)markedRows.get(i6)] < minimum2) {
                        minimum2 = mappingTable[(Integer)markedColumns.get(j4)][(Integer)markedRows.get(i6)];
                    }
                    ++j4;
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < markedRows.size()) {
                j4 = 0;
                while (j4 < markedColumns.size()) {
                    mappingTable[((Integer)markedColumns.get((int)j4)).intValue()][((Integer)markedRows.get((int)i6)).intValue()] = mappingTable[(Integer)markedColumns.get(j4)][(Integer)markedRows.get(i6)] - minimum2;
                    ++j4;
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < mappingTable.length) {
                if (!markedColumns.contains(i6)) {
                    j4 = 0;
                    while (j4 < mappingTable[i6].length) {
                        if (!markedRows.contains(j4)) {
                            mappingTable[i6][j4] = mappingTable[i6][j4] + minimum2;
                        }
                        ++j4;
                    }
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < mappingTable.length) {
                j4 = 0;
                while (j4 < mappingTable[i6].length) {
                    if (mappingTable[i6][j4] == Integer.MAX_VALUE) {
                        mappingTable[i6][j4] = 0;
                    }
                    if (mappingTable[i6][j4] == Integer.MIN_VALUE) {
                        mappingTable[i6][j4] = 0;
                    }
                    ++j4;
                }
                ++i6;
            }
        }
        HashMap<Integer, String> clusterToPrediction = new HashMap<Integer, String>();
        int i7 = 0;
        while (i7 < mappingTable.length) {
            int result = -1;
            int j6 = 0;
            while (j6 < mappingTable[i7].length) {
                if (mappingTable[i7][j6] == Integer.MIN_VALUE) {
                    result = j6;
                    break;
                }
                ++j6;
            }
            String resultCluster = (String)intToClusterMapping.get(result);
            clusterToPrediction.put(i7, resultCluster);
            ++i7;
        }
        HashMap<String, Integer> predictionToCluster = new HashMap<String, Integer>();
        int i8 = 0;
        Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
        for (Example example : exampleSet) {
            String resultLabel = (String)clusterToPrediction.get((int)example.getValue(example.getAttributes().getCluster()));
            example.setValue(predictedLabel, resultLabel);
            if (predictionToCluster.size() < model.getNumberOfClusters() && !predictionToCluster.containsKey(example.getValueAsString(example.getAttributes().getPredictedLabel()))) {
                String clusterNumber = example.getValueAsString(clusterAttribute).replaceAll("[^\\d]+", "");
                try {
                    int number = Integer.parseInt(clusterNumber);
                    predictionToCluster.put(example.getValueAsString(example.getAttributes().getPredictedLabel()), number);
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 145, clusterAttribute.getName());
                }
            }
            ++i8;
        }
        i8 = 0;
        for (Example example : exampleSet) {
            if (model.getClass() == FlatFuzzyClusterModel.class) {
                FlatFuzzyClusterModel fuzzyModel = (FlatFuzzyClusterModel)model;
                int j7 = 0;
                while (j7 < clusterToPrediction.size()) {
                    String label = (String)clusterToPrediction.get(j7);
                    example.setConfidence(label, fuzzyModel.getExampleInClusterProbability(i8, (Integer)predictionToCluster.get(label)));
                    ++j7;
                }
            } else {
                example.setConfidence((String)clusterToPrediction.get((int)example.getValue(example.getAttributes().getCluster())), 1.0);
            }
            ++i8;
        }
        return new IOObject[]{exampleSet, model};
    }

    /*
     * Unable to fully structure code
     */
    private boolean assignmentAvailable(int[][] mappingTable) {
        markedZeros = 0;
        modificationDone = true;
        ** GOTO lbl90
        {
            modificationDone = false;
            i = 0;
            while (i < mappingTable.length) {
                position = -1;
                j = 0;
                while (j < mappingTable[i].length) {
                    if (mappingTable[i][j] == 0) {
                        if (position == -1) {
                            position = j;
                        } else {
                            position = -1;
                            break;
                        }
                    }
                    ++j;
                }
                if (position != -1) {
                    modificationDone = true;
                    mappingTable[i][position] = -2147483648;
                    k = 0;
                    while (k < mappingTable.length) {
                        if (mappingTable[k][position] == 0) {
                            mappingTable[k][position] = 0x7FFFFFFF;
                        }
                        ++k;
                    }
                    ++markedZeros;
                }
                ++i;
            }
            if (markedZeros == mappingTable.length) {
                return true;
            }
            i = 0;
            while (i < mappingTable[0].length) {
                position = -1;
                j = 0;
                while (j < mappingTable.length) {
                    if (mappingTable[j][i] == 0) {
                        if (position == -1) {
                            position = j;
                        } else {
                            position = -1;
                            break;
                        }
                    }
                    ++j;
                }
                if (position != -1) {
                    modificationDone = true;
                    mappingTable[position][i] = -2147483648;
                    k = 0;
                    while (k < mappingTable[0].length) {
                        if (mappingTable[position][k] == 0) {
                            mappingTable[position][k] = 0x7FFFFFFF;
                        }
                        ++k;
                    }
                    ++markedZeros;
                }
                ++i;
            }
            if (markedZeros == mappingTable.length) {
                return true;
            }
            do {
                if (modificationDone) continue block0;
                aktMarkedZeros = markedZeros;
                i = 0;
                while (i < mappingTable.length) {
                    j = 0;
                    while (j < mappingTable[i].length) {
                        if (mappingTable[i][j] == 0) {
                            mappingTable[i][j] = -2147483648;
                            k = j + 1;
                            while (k < mappingTable[i].length) {
                                if (mappingTable[i][k] == 0) {
                                    mappingTable[i][k] = 0x7FFFFFFF;
                                }
                                ++k;
                            }
                            k = 0;
                            while (k < mappingTable.length) {
                                if (mappingTable[k][j] == 0) {
                                    mappingTable[k][j] = 0x7FFFFFFF;
                                }
                                ++k;
                            }
                            modificationDone = true;
                            ++markedZeros;
                            break;
                        }
                        ++j;
                    }
                    if (aktMarkedZeros != markedZeros) break;
                    ++i;
                }
                if (markedZeros != mappingTable.length) continue;
                return true;
lbl90:
                // 2 sources

            } while (modificationDone);
        }
        return false;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ClusterModel.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, ClusterModel.class};
    }
}

