/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.FastICAModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.MathFunctions;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastICA
extends Operator {
    public static final String PARAMETER_NUMBER_OF_COMPONENTS = "number_of_components";
    public static final String PARAMETER_ALGORITHM_TYPE = "algorithm_type";
    public static final String PARAMETER_FUNCTION = "function";
    public static final String PARAMETER_ALPHA = "alpha";
    public static final String PARAMETER_ROW_NORM = "row_norm";
    public static final String PARAMETER_MAX_ITERATION = "max_iteration";
    public static final String PARAMETER_TOLERANCE = "tolerance";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class, Model.class};
    private static final String[] ALGORITHM_TYPE = new String[]{"deflation", "parallel"};
    private static final String[] FUNCTION = new String[]{"logcosh", "exp"};
    private int algorithmType;
    private int function;
    private int numberOfComponents;
    private double tolerance;
    private double alpha;
    private boolean rowNorm;
    private int maxIteration;
    private int numberOfSamples;
    private int numberOfAttributes;
    private Attribute[] attributes;
    private double[] means;
    private double[][] data;
    private double[][] wInit;

    public FastICA(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet set = this.getInput(ExampleSet.class);
        set.recalculateAllAttributeStatistics();
        this.numberOfSamples = set.size();
        this.numberOfAttributes = set.getAttributes().size();
        this.attributes = new Attribute[this.numberOfAttributes];
        this.means = new double[this.numberOfAttributes];
        int i = 0;
        Iterator<Attribute> atts = set.getAttributes().iterator();
        while (atts.hasNext()) {
            this.attributes[i] = atts.next();
            if (!this.attributes[i].isNumerical()) {
                throw new UserError((Operator)this, 104, "FastICA", this.attributes[i].getName());
            }
            this.means[i] = set.getStatistics(this.attributes[i], "average");
            ++i;
        }
        this.algorithmType = this.getParameterAsInt(PARAMETER_ALGORITHM_TYPE);
        this.function = this.getParameterAsInt(PARAMETER_FUNCTION);
        this.tolerance = this.getParameterAsDouble(PARAMETER_TOLERANCE);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        this.rowNorm = this.getParameterAsBoolean(PARAMETER_ROW_NORM);
        this.maxIteration = this.getParameterAsInt(PARAMETER_MAX_ITERATION);
        this.numberOfComponents = this.getParameterAsInt(PARAMETER_NUMBER_OF_COMPONENTS);
        if (this.numberOfComponents < 1) {
            this.numberOfComponents = this.numberOfAttributes;
        }
        if (this.numberOfComponents > this.numberOfAttributes) {
            this.numberOfComponents = this.numberOfAttributes;
            this.logWarning("The parameter 'number_of_components' is too large! Set to number of attributes.");
        }
        this.data = new double[this.numberOfSamples][this.numberOfAttributes];
        Iterator reader = set.iterator();
        int sample = 0;
        while (sample < this.numberOfSamples) {
            Example example = (Example)reader.next();
            int d = 0;
            while (d < this.numberOfAttributes) {
                this.data[sample][d] = example.getValue(this.attributes[d]) - this.means[d];
                ++d;
            }
            ++sample;
        }
        this.log("Initializing the weights...");
        this.wInit = new double[this.numberOfComponents][this.numberOfComponents];
        RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                this.wInit[i][j] = randomGenerator.nextDouble() * 2.0 - 1.0;
                ++j;
            }
            ++i;
        }
        if (this.rowNorm) {
            this.log("Scaling the data now.");
            int row = 0;
            while (row < this.numberOfSamples) {
                double rms_row = 0.0;
                int d = 0;
                while (d < this.numberOfAttributes) {
                    rms_row += this.data[row][d] * this.data[row][d];
                    ++d;
                }
                rms_row = Math.sqrt(rms_row) / (double)Math.max(1, this.numberOfAttributes - 1);
                d = 0;
                while (d < this.numberOfAttributes) {
                    this.data[row][d] = this.data[row][d] / rms_row;
                    ++d;
                }
                ++row;
            }
        }
        Matrix X = new Matrix(this.data);
        X = X.transpose();
        this.log("Whitening the data now.");
        Matrix V = X.times(X.transpose().timesEquals(1.0 / (double)this.numberOfSamples));
        SingularValueDecomposition svd = V.svd();
        Matrix D = svd.getS();
        double[][] singularvalue = D.getArray();
        i = 0;
        while (i < singularvalue.length) {
            singularvalue[i][i] = 1.0 / Math.sqrt(singularvalue[i][i]);
            ++i;
        }
        D = new Matrix(singularvalue);
        Matrix K = D.times(svd.getU().transpose());
        K = new Matrix(K.getArray(), this.numberOfComponents, this.numberOfAttributes);
        Matrix X1 = K.times(X);
        Matrix a = this.algorithmType == 0 ? this.deflation(X1) : this.parallel(X1);
        this.log("Creating the model...");
        Matrix w = a.times(K);
        Matrix W2 = w.times(w.transpose());
        Matrix A = w.transpose().times(W2.inverse());
        X = X.transpose();
        K = K.transpose();
        Matrix W = a.transpose();
        A = A.transpose();
        FastICAModel model = new FastICAModel(set, this.numberOfComponents, this.means, this.rowNorm, K, W, A);
        return new IOObject[]{set, model};
    }

    private Matrix deflation(Matrix X) throws OperatorException {
        this.log("Deflation FastICA using " + FUNCTION[this.function] + " approx. to neg-entropy function");
        Matrix W = new Matrix(this.numberOfComponents, this.numberOfComponents, 0.0);
        int iterlog = 1;
        while (this.maxIteration / iterlog > 10 && this.maxIteration / (iterlog * 10) >= 3) {
            iterlog *= 10;
        }
        int i = 0;
        while (i < this.numberOfComponents) {
            double k;
            Matrix Wu;
            Matrix t;
            this.log("Component " + (i + 1));
            Matrix w = new Matrix(this.wInit[i], this.wInit[i].length);
            if (i > 0) {
                t = new Matrix(this.wInit[i].length, 1, 0.0);
                int u = 1;
                while (u <= i) {
                    Wu = W.getMatrix(u - 1, u - 1, 0, this.numberOfComponents - 1);
                    k = w.transpose().times(Wu.transpose()).getArray()[0][0];
                    t.plusEquals(Wu.times(k).transpose());
                    ++u;
                }
                w.minusEquals(t);
            }
            double rss = Math.sqrt(w.times(w.transpose()).getArray()[0][0]);
            w.timesEquals(1.0 / rss);
            double lim = 1000.0;
            int iter = 1;
            while (lim > this.tolerance && iter <= this.maxIteration) {
                double value;
                int j;
                int j2;
                Matrix wx = w.transpose().times(X);
                double[][] wxarray = wx.getArray();
                if (this.function == 0) {
                    j2 = 0;
                    while (j2 < wxarray[0].length) {
                        wxarray[0][j2] = MathFunctions.tanh(this.alpha * wxarray[0][j2]);
                        ++j2;
                    }
                } else {
                    j2 = 0;
                    while (j2 < wxarray[0].length) {
                        wxarray[0][j2] = wxarray[0][j2] * Math.exp(-0.5 * wxarray[0][j2] * wxarray[0][j2]);
                        ++j2;
                    }
                }
                Matrix gwx = new Matrix(wxarray);
                double[][] gwxarray = gwx.getArray();
                double[][] Xarray = X.getArray();
                int row = 0;
                while (row < Xarray.length) {
                    int col = 0;
                    while (col < Xarray[0].length) {
                        Xarray[row][col] = Xarray[row][col] * gwxarray[0][col];
                        ++col;
                    }
                    ++row;
                }
                Matrix xgwx = new Matrix(Xarray);
                Matrix v1 = new Matrix(this.numberOfComponents, 1, 0.0);
                int row2 = 0;
                while (row2 < this.numberOfComponents) {
                    double mean = 0.0;
                    int col = 0;
                    while (col < this.numberOfSamples) {
                        mean += xgwx.get(row2, col);
                        ++col;
                    }
                    v1.set(row2, 0, mean /= (double)this.numberOfSamples);
                    ++row2;
                }
                Matrix g_wx = wx.copy();
                double mean = 0.0;
                if (this.function == 0) {
                    j = 0;
                    while (j < wxarray[0].length) {
                        value = MathFunctions.tanh(this.alpha * g_wx.get(0, j));
                        value = this.alpha * (1.0 - value * value);
                        mean += value;
                        g_wx.set(0, j, value);
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < wxarray[0].length) {
                        value = g_wx.get(0, j);
                        value = (1.0 - value * value) * Math.exp(-0.5 * value * value);
                        mean += value;
                        g_wx.set(0, j, value);
                        ++j;
                    }
                }
                Matrix v2 = w.copy();
                v2.timesEquals(mean /= (double)this.numberOfSamples);
                Matrix w1 = v1.minus(v2);
                if (i > 0) {
                    t = new Matrix(w1.getRowDimension(), w1.getColumnDimension(), 0.0);
                    int u = 1;
                    while (u <= i) {
                        Wu = W.getMatrix(u - 1, u - 1, 0, this.numberOfComponents - 1);
                        k = w1.transpose().times(Wu.transpose()).getArray()[0][0];
                        t.plusEquals(Wu.times(k).transpose());
                        ++u;
                    }
                    w1.minusEquals(t);
                }
                rss = Math.sqrt(w1.transpose().times(w1).getArray()[0][0]);
                w1.timesEquals(1.0 / rss);
                lim = Math.abs(Math.abs(w1.transpose().times(w).getArray()[0][0]) - 1.0);
                if (iter % iterlog == 0 || lim <= this.tolerance) {
                    this.log("Iteration " + iter + ", tolerance = " + lim);
                }
                ++iter;
                w = w1.copy();
            }
            int col = 0;
            while (col < this.numberOfComponents) {
                W.set(i, col, w.get(col, 0));
                ++col;
            }
            this.checkForStop();
            ++i;
        }
        return W;
    }

    private Matrix parallel(Matrix X) throws OperatorException {
        this.log("Symmetric FastICA using " + FUNCTION[this.function] + " approx. to neg-entropy function");
        int p = X.getColumnDimension();
        Matrix W = new Matrix(this.wInit);
        SingularValueDecomposition svd = W.svd();
        double[] svalues = svd.getSingularValues();
        Matrix svaluesMatrix = new Matrix(svalues.length, svalues.length, 0.0);
        int i = 0;
        while (i < svalues.length) {
            svalues[i] = 1.0 / svalues[i];
            svaluesMatrix.set(i, i, svalues[i]);
            ++i;
        }
        W = svd.getU().times(svaluesMatrix).times(svd.getU().transpose()).times(W);
        Matrix W1 = W.copy();
        double lim = 1000.0;
        int iter = 1;
        int iterlog = 1;
        while (this.maxIteration / iterlog > 10 && this.maxIteration / (iterlog * 10) >= 3) {
            iterlog *= 10;
        }
        while (lim > this.tolerance && iter <= this.maxIteration) {
            double mean;
            double value;
            int col;
            int row;
            Matrix wx = W.times(X);
            Matrix gwx = wx.copy();
            if (this.function == 0) {
                row = 0;
                while (row < this.numberOfComponents) {
                    col = 0;
                    while (col < this.numberOfSamples) {
                        value = gwx.get(row, col);
                        value = MathFunctions.tanh(this.alpha * value);
                        gwx.set(row, col, value);
                        ++col;
                    }
                    ++row;
                }
            } else {
                row = 0;
                while (row < this.numberOfComponents) {
                    col = 0;
                    while (col < this.numberOfSamples) {
                        value = gwx.get(row, col);
                        value *= Math.exp(-0.5 * value * value);
                        gwx.set(row, col, value);
                        ++col;
                    }
                    ++row;
                }
            }
            Matrix v1 = gwx.times(X.transpose()).times((double)p);
            Matrix g_wx = gwx.copy();
            Matrix diagmean = new Matrix(this.numberOfComponents, this.numberOfComponents, 0.0);
            if (this.function == 0) {
                row = 0;
                while (row < this.numberOfComponents) {
                    mean = 0.0;
                    col = 0;
                    while (col < this.numberOfSamples) {
                        value = g_wx.get(row, col);
                        value = this.alpha * (1.0 - value * value);
                        g_wx.set(row, col, value);
                        mean += value;
                        ++col;
                    }
                    diagmean.set(row, row, mean /= (double)this.numberOfSamples);
                    ++row;
                }
            } else {
                g_wx = wx.copy();
                row = 0;
                while (row < this.numberOfComponents) {
                    mean = 0.0;
                    col = 0;
                    while (col < this.numberOfSamples) {
                        value = g_wx.get(row, col);
                        value = (1.0 - value * value) * Math.exp(-0.5 * value * value);
                        g_wx.set(row, col, value);
                        mean += value;
                        ++col;
                    }
                    diagmean.set(row, row, mean /= (double)this.numberOfSamples);
                    ++row;
                }
            }
            Matrix v2 = diagmean.times(W);
            W1 = v1.minus(v2);
            svd = W1.svd();
            svalues = svd.getSingularValues();
            svaluesMatrix = new Matrix(svalues.length, svalues.length, 0.0);
            int i2 = 0;
            while (i2 < svalues.length) {
                svalues[i2] = 1.0 / svalues[i2];
                svaluesMatrix.set(i2, i2, svalues[i2]);
                ++i2;
            }
            W1 = svd.getU().times(svaluesMatrix).times(svd.getU().transpose()).times(W1);
            double[][] diag = W1.times(W.transpose()).getArray();
            value = Double.NEGATIVE_INFINITY;
            int row2 = 0;
            while (row2 < this.numberOfComponents) {
                value = Math.max(value, Math.abs(Math.abs(diag[row2][row2]) - 1.0));
                ++row2;
            }
            lim = value;
            W = W1.copy();
            if (iter % iterlog == 0 || lim <= this.tolerance) {
                this.log("Iteration " + iter + ", tolerance = " + lim);
            }
            ++iter;
        }
        return W;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COMPONENTS, "Number components to be extracted (-1 number of attributes is used).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        list.add(type);
        type = new ParameterTypeCategory(PARAMETER_ALGORITHM_TYPE, "If 'parallel' the components are extracted simultaneously, 'deflation' the components are extracted one at a time", ALGORITHM_TYPE, 0);
        list.add(type);
        type = new ParameterTypeCategory(PARAMETER_FUNCTION, "The functional form of the G function used in the approximation to neg-entropy", FUNCTION, 0);
        list.add(type);
        type = new ParameterTypeDouble(PARAMETER_ALPHA, "constant in range [1, 2] used in approximation to neg-entropy when fun=\"logcosh\"", 1.0, 2.0, 1.0);
        list.add(type);
        type = new ParameterTypeBoolean(PARAMETER_ROW_NORM, "Indicates whether rows of the data matrix should be standardized beforehand.", false);
        list.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_ITERATION, "maximum number of iterations to perform", 0, Integer.MAX_VALUE, 200);
        list.add(type);
        type = new ParameterTypeDouble(PARAMETER_TOLERANCE, "A positive scalar giving the tolerance at which the un-mixing matrix is considered to have converged.", 0.0, Double.POSITIVE_INFINITY, 1.0E-4);
        list.add(type);
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1);
        list.add(type);
        return list;
    }
}

