/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.operator.learner.tree.Criterion;
import com.rapidminer.operator.learner.tree.NumericalSplitter;

public abstract class AbstractEntropyWeighting
extends AbstractWeighting {
    public AbstractEntropyWeighting(OperatorDescription description) {
        super(description);
    }

    public abstract Criterion getEntropyCriterion();

    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, this.getName(), label.getName());
        }
        Criterion criterion = this.getEntropyCriterion();
        NumericalSplitter splitter = new NumericalSplitter(criterion);
        AttributeWeights weights = new AttributeWeights(exampleSet);
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNominal()) {
                double weight = criterion.getNominalBenefit(exampleSet, attribute);
                weights.setWeight(attribute.getName(), weight);
                continue;
            }
            double splitValue = splitter.getBestSplit(exampleSet, attribute);
            double weight = criterion.getNumericalBenefit(exampleSet, attribute, splitValue);
            weights.setWeight(attribute.getName(), weight);
        }
        return weights;
    }
}

