/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final int MAX_STORES = 15;
    private static final int MAX_CUSTOMERS = 2000;
    private static final String[] ATTRIBUTE_NAMES = new String[]{"transaction_id", "store_id", "customer_id", "product_id", "product_category", "date", "amount", "single_price"};
    private static final int ATT_TRANSACTION_ID = 0;
    private static final int ATT_STORE_ID = 1;
    private static final int ATT_CUSTOMER_ID = 2;
    private static final int ATT_PRODUCT_ID = 3;
    private static final int ATT_PRODUCT_CATEGORY = 4;
    private static final int ATT_DATE = 5;
    private static final int ATT_AMOUNT = 6;
    private static final int ATT_SINGLE_PRICE = 7;
    private static final String[] PRODUCT_CATEGORIES = new String[]{"Books", "Movies", "Electronics", "Home/Garden", "Health", "Toys", "Sports", "Clothing"};

    public SalesExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute transactionId = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[0], 3);
        attributes.add(transactionId);
        Attribute storeId = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[1], 1);
        int s = 1;
        while (s <= 15) {
            storeId.getMapping().mapString("Store " + this.getFullStoreNumber(s));
            ++s;
        }
        attributes.add(storeId);
        Attribute customerId = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[2], 1);
        int s2 = 1;
        while (s2 <= 2000) {
            customerId.getMapping().mapString("Customer " + s2);
            ++s2;
        }
        attributes.add(customerId);
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[3], 3));
        Attribute productCategory = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[4], 1);
        int s3 = 0;
        while (s3 < PRODUCT_CATEGORIES.length) {
            productCategory.getMapping().mapString(PRODUCT_CATEGORIES[s3]);
            ++s3;
        }
        attributes.add(productCategory);
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[5], 10));
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[6], 3));
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[7], 4));
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        int n = 0;
        while (n < numberOfExamples) {
            double[] values = new double[ATTRIBUTE_NAMES.length];
            values[0] = n + 1;
            values[1] = ((Attribute)attributes.get(1)).getMapping().mapString("Store " + this.getFullStoreNumber(random.nextIntInRange(1, 16)));
            values[2] = ((Attribute)attributes.get(2)).getMapping().mapString("Customer " + random.nextIntInRange(1, 2001));
            values[3] = random.nextIntInRange(10000, 100000);
            values[4] = random.nextInt(PRODUCT_CATEGORIES.length);
            values[5] = random.nextDateInRange(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2008, 10, 30).getTime()).getTime();
            values[6] = random.nextIntInRange(1, 10);
            values[7] = random.nextDoubleInRange(10.0, 100.0);
            table.addDataRow(new DoubleArrayDataRow(values));
            ++n;
        }
        return table.createExampleSet(null, null, transactionId);
    }

    private String getFullStoreNumber(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

