/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransfersExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_CREATE_FRAUD_LABEL = "create_fraud_label";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static String[] ATTRIBUTE_NAMES = new String[]{"Source", "Target", "ProjectID", "Reason", "Person", "Amount"};
    private static int[] VALUE_TYPES = new int[]{1, 1, 1, 3, 1, 4};
    private static String[][] POSSIBLE_VALUES;

    static {
        String[][] stringArrayArray = new String[6][];
        stringArrayArray[0] = new String[]{"1201", "1302", "4517", "4711", "2323", "1110", "2233"};
        stringArrayArray[1] = new String[]{"1201", "1302", "4517", "4711", "2323", "1110", "2233"};
        stringArrayArray[2] = new String[]{"Prj01", "Prj02", "Prj03", "Prj04", "Prj05", "Prj06", "Prj07", "Prj08"};
        stringArrayArray[4] = new String[]{"Mr. Brown", "Mr. Miller", "Mrs. Smith", "Mrs. Hanson", "Mrs. Green", "Mr. Chang"};
        POSSIBLE_VALUES = stringArrayArray;
    }

    public TransfersExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute id = AttributeFactory.createAttribute("TransferID", 3);
        attributes.add(id);
        int m = 0;
        while (m < ATTRIBUTE_NAMES.length) {
            Attribute current = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[m], VALUE_TYPES[m]);
            String[] possibleValues = POSSIBLE_VALUES[m];
            if (possibleValues != null) {
                int v = 0;
                while (v < possibleValues.length) {
                    current.getMapping().mapString(possibleValues[v]);
                    ++v;
                }
            }
            attributes.add(current);
            ++m;
        }
        boolean createFraudLabel = this.getParameterAsBoolean(PARAMETER_CREATE_FRAUD_LABEL);
        Attribute label = null;
        if (createFraudLabel) {
            label = AttributeFactory.createAttribute("fraud", 1);
            label.getMapping().mapString("yes");
            label.getMapping().mapString("no");
            attributes.add(label);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        int n = 0;
        while (n < numberOfExamples) {
            int specialLength = createFraudLabel ? 2 : 1;
            double[] values = new double[ATTRIBUTE_NAMES.length + specialLength];
            values[0] = n + 1;
            values[1] = random.nextInt(POSSIBLE_VALUES[0].length);
            values[2] = random.nextInt(POSSIBLE_VALUES[1].length);
            values[3] = random.nextInt(POSSIBLE_VALUES[2].length);
            values[4] = random.nextIntInRange(10000, 99999);
            values[5] = random.nextInt(POSSIBLE_VALUES[4].length);
            values[6] = Math.round(random.nextGaussian() * 15000.0) + 50000L;
            if (createFraudLabel) {
                values[7] = label.getMapping().mapString("no");
                if (!(values[1] != 3.0 && values[1] != 4.0 || values[2] != 1.0 && values[2] != 2.0 || !(random.nextDouble() > 0.05))) {
                    values[7] = label.getMapping().mapString("yes");
                }
            }
            table.addDataRow(new DoubleArrayDataRow(values));
            ++n;
        }
        if (createFraudLabel) {
            return table.createExampleSet(label, null, id);
        }
        return table.createExampleSet(null, null, id);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_CREATE_FRAUD_LABEL, "Indicates if a label should be created for possible frauds.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

