/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BytewiseExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_FILENAME = "filename";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    protected static final String GENERIC_ERROR_MESSAGE = "Wrong file format";
    protected static final String UNSPECIFIED_ERROR_MESSAGE = "Unspecified error";
    protected static final int LENGTH_BYTE = 1;
    protected static final int LENGTH_INT_32 = 4;
    protected static final int LENGTH_DOUBLE = 8;

    public BytewiseExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        DataRowFactory dataRowFactory = new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), '.');
        ExampleSet result = null;
        try {
            InputStream inputStream = this.getParameterAsInputStream(PARAMETER_FILENAME);
            result = this.readStream(inputStream, dataRowFactory);
            inputStream.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_FILENAME), e.getMessage());
        }
        if (result == null) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_FILENAME), UNSPECIFIED_ERROR_MESSAGE);
        }
        if (result.size() == 0) {
            throw new UserError(this, 117);
        }
        return result;
    }

    protected abstract String getFileSuffix();

    protected abstract ExampleSet readStream(InputStream var1, DataRowFactory var2) throws IOException, UndefinedParameterError;

    protected int read(InputStream inputStream, byte[] buffer, int length) throws IOException {
        boolean offset = false;
        return this.read(inputStream, buffer, 0, length);
    }

    protected int read(InputStream inputStream, byte[] buffer, int offset, int length) throws IOException {
        int readLength = inputStream.read(buffer, offset, length);
        if (readLength != length) {
            throw new IOException("wrong byte length");
        }
        return readLength;
    }

    protected int readWithoutLengthCheck(InputStream inputStream, byte[] buffer, int length) throws IOException {
        return inputStream.read(buffer, 0, length);
    }

    protected int read(InputStream inputStream, byte[] buffer, char divider) throws IOException {
        int index = 0;
        do {
            byte readByte;
            if ((readByte = (byte)(0xFF & inputStream.read())) == -1 || readByte == (byte)divider) {
                return index;
            }
            buffer[index] = readByte;
        } while (++index < buffer.length);
        return index;
    }

    protected int read(InputStream inputStream, byte[] buffer, char[] divider) throws IOException {
        int index = 0;
        int dividerIndex = 0;
        do {
            byte readByte;
            if ((readByte = (byte)(0xFF & inputStream.read())) == -1) {
                return index;
            }
            if (readByte == divider[dividerIndex]) {
                ++dividerIndex;
            }
            if (dividerIndex == divider.length) {
                int i = index -= dividerIndex - 1;
                while (i < index + dividerIndex) {
                    if (i >= buffer.length) break;
                    buffer[i] = 0;
                    ++i;
                }
                return index;
            }
            buffer[index] = readByte;
        } while (++index < buffer.length);
        return index;
    }

    protected int extract2ByteInt(byte[] buffer, int offset, boolean reverseEndian) {
        int r = 0;
        r = reverseEndian ? (buffer[offset + 1] << 8) + (0xFF & buffer[offset]) : (buffer[offset] << 8) + (0xFF & buffer[offset + 1]);
        return r;
    }

    protected int extractInt(byte[] buffer, int offset, boolean reverseEndian) {
        int r = 0;
        if (reverseEndian) {
            int i = offset + 3;
            while (i >= offset) {
                r <<= 8;
                r += 0xFF & buffer[i];
                --i;
            }
        } else {
            int i = offset;
            while (i < offset + 4) {
                r <<= 8;
                r += 0xFF & buffer[i];
                ++i;
            }
        }
        return r;
    }

    protected float extractFloat(byte[] value, int offset, boolean reverseEndian) {
        int bits = 0;
        if (reverseEndian) {
            int i = offset + 3;
            while (i >= offset) {
                bits <<= 8;
                bits += 0xFF & value[i];
                --i;
            }
        } else {
            int i = offset;
            while (i < offset + 4) {
                bits <<= 8;
                bits += 0xFF & value[i];
                ++i;
            }
        }
        return Float.intBitsToFloat(bits);
    }

    protected double extractDouble(byte[] value, int offset, boolean reverseEndian) {
        long bits = 0L;
        if (reverseEndian) {
            int i = offset + 7;
            while (i >= offset) {
                bits <<= 8;
                bits += (long)(0xFF & value[i]);
                --i;
            }
        } else {
            int i = offset;
            while (i < offset + 8) {
                bits <<= 8;
                bits += (long)(0xFF & value[i]);
                ++i;
            }
        }
        return Double.longBitsToDouble(bits);
    }

    protected String extractString(byte[] value, int offset, int length) {
        return new String(value, offset, length).trim();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeFile(PARAMETER_FILENAME, "Name of the file to read the data from.", this.getFileSuffix(), false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

