/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.hyperhyper;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.JRadioSelectionPanel;
import com.rapidminer.gui.viewer.DataTableViewerTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import java.awt.Component;

public class HyperModel
extends PredictionModel {
    private static final long serialVersionUID = -453402008180607969L;
    private String[] coefficientNames;
    private double[] x1;
    private double[] x2;
    private double bias;
    private double[] w;

    public HyperModel(ExampleSet trainingExampleSet, double bias, double[] w, double[] x1, double[] x2) {
        super(trainingExampleSet);
        this.coefficientNames = Tools.getRegularAttributeNames(trainingExampleSet);
        this.bias = bias;
        this.w = w;
        this.x1 = x1;
        this.x2 = x2;
    }

    public int getNumberOfAttributes() {
        return this.x1.length;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Support Vector 1:" + com.rapidminer.tools.Tools.getLineSeparator());
        int i = 0;
        while (i < this.coefficientNames.length) {
            result.append(String.valueOf(this.coefficientNames[i]) + " = " + com.rapidminer.tools.Tools.formatNumber(this.x1[i]) + com.rapidminer.tools.Tools.getLineSeparator());
            ++i;
        }
        result.append(String.valueOf(com.rapidminer.tools.Tools.getLineSeparator()) + "Support Vector 2:" + com.rapidminer.tools.Tools.getLineSeparator());
        i = 0;
        while (i < this.coefficientNames.length) {
            result.append(String.valueOf(this.coefficientNames[i]) + " = " + com.rapidminer.tools.Tools.formatNumber(this.x2[i]) + com.rapidminer.tools.Tools.getLineSeparator());
            ++i;
        }
        result.append(String.valueOf(com.rapidminer.tools.Tools.getLineSeparator()) + "Bias (offset): " + com.rapidminer.tools.Tools.formatNumber(this.bias) + com.rapidminer.tools.Tools.getLineSeparators(2));
        result.append("Coefficients:" + com.rapidminer.tools.Tools.getLineSeparator());
        int j = 0;
        while (j < this.w.length) {
            result.append("w(" + this.coefficientNames[j] + ") = " + com.rapidminer.tools.Tools.formatNumber(this.w[j]) + com.rapidminer.tools.Tools.getLineSeparator());
            ++j;
        }
        return result.toString();
    }

    public String getName() {
        return "HyperHyper Model";
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        if (exampleSet.getAttributes().size() != this.getNumberOfAttributes()) {
            throw new UserError(null, 133, this.getNumberOfAttributes(), exampleSet.getAttributes().size());
        }
        for (Example activeExample : exampleSet) {
            double sum = 0.0;
            int i = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                sum += activeExample.getValue(attribute) * this.w[i];
                ++i;
            }
            double result = sum + this.bias;
            int prediction = 0;
            prediction = result > 0.0 ? this.getLabel().getMapping().getPositiveIndex() : this.getLabel().getMapping().getNegativeIndex();
            activeExample.setValue(predictedLabel, prediction);
            activeExample.setConfidence(predictedLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-result)));
            activeExample.setConfidence(predictedLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(result)));
        }
        return exampleSet;
    }

    private DataTable createWeightsTable() {
        SimpleDataTable weightTable = new SimpleDataTable("Hyper Weights", new String[]{"Attribute", "Weight"});
        int j = 0;
        while (j < this.w.length) {
            int nameIndex = weightTable.mapString(0, this.coefficientNames[j]);
            weightTable.add(new SimpleDataTableRow(new double[]{nameIndex, this.w[j]}));
            ++j;
        }
        return weightTable;
    }

    public Component getVisualizationComponent(IOContainer container) {
        JRadioSelectionPanel mainPanel = new JRadioSelectionPanel();
        Component textView = super.getVisualizationComponent(container);
        mainPanel.addComponent("Text View", textView, "Changes to a textual view of this model.");
        DataTable weightDataTable = this.createWeightsTable();
        DataTableViewerTable weightTableViewer = new DataTableViewerTable(true);
        weightTableViewer.setDataTable(weightDataTable);
        ExtendedJScrollPane weightTableView = new ExtendedJScrollPane(weightTableViewer);
        mainPanel.addComponent("Weight Table View", weightTableView, "Changes to a weight table view of this model.");
        return mainPanel;
    }
}

