/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaggingModel
extends PredictionModel {
    private static final long serialVersionUID = -4691755811263523354L;
    private List<Model> models;

    public BaggingModel(ExampleSet exampleSet, List<Model> models) {
        super(exampleSet);
        this.models = models;
    }

    public int getNumberOfModels() {
        return this.models.size();
    }

    public Model getModel(int index) {
        return this.models.get(index);
    }

    @Override
    public ExampleSet performPrediction(ExampleSet origExampleSet, Attribute predictedLabel) throws OperatorException {
        if (predictedLabel.isNominal()) {
            String attributePrefix = "BaggingModelPrediction";
            int numLabels = predictedLabel.getMapping().size();
            Attribute[] specialAttributes = new Attribute[numLabels];
            int i = 0;
            while (i < numLabels) {
                specialAttributes[i] = Tools.createSpecialAttribute(origExampleSet, "BaggingModelPrediction" + i, 2);
                ++i;
            }
            for (Example example : origExampleSet) {
                int i2 = 0;
                while (i2 < specialAttributes.length) {
                    example.setValue(specialAttributes[i2], 0.0);
                    ++i2;
                }
            }
            Iterator reader = origExampleSet.iterator();
            int modelNr = 0;
            while (modelNr < this.getNumberOfModels()) {
                Model model = this.getModel(modelNr);
                ExampleSet exampleSet = (ExampleSet)origExampleSet.clone();
                exampleSet = model.apply(exampleSet);
                this.updateEstimates(exampleSet, modelNr, specialAttributes);
                PredictionModel.removePredictedLabel(exampleSet);
                ++modelNr;
            }
            this.evaluateSpecialAttributes(origExampleSet, specialAttributes);
            int i3 = 0;
            while (i3 < numLabels) {
                origExampleSet.getAttributes().remove(specialAttributes[i3]);
                origExampleSet.getExampleTable().removeAttribute(specialAttributes[i3]);
                ++i3;
            }
            return origExampleSet;
        }
        double[] predictionSums = new double[origExampleSet.size()];
        for (Model model : this.models) {
            ExampleSet resultSet = model.apply(origExampleSet);
            int index = 0;
            Attribute innerPredictedLabel = resultSet.getAttributes().getPredictedLabel();
            for (Example example : resultSet) {
                int n = index++;
                predictionSums[n] = predictionSums[n] + example.getValue(innerPredictedLabel);
            }
            PredictionModel.removePredictedLabel(resultSet);
        }
        int index = 0;
        for (Example example : origExampleSet) {
            example.setValue(predictedLabel, predictionSums[index++] / (double)this.models.size());
        }
        return origExampleSet;
    }

    private void updateEstimates(ExampleSet exampleSet, int modelNr, Attribute[] specialAttributes) {
        int numModels = this.getNumberOfModels();
        int numClasses = this.getLabel().getMapping().size();
        for (Example example : exampleSet) {
            int i = 0;
            while (i < numClasses) {
                String consideredPrediction = this.getLabel().getMapping().mapIndex(i);
                double confidence = example.getConfidence(consideredPrediction);
                double value = example.getValue(specialAttributes[i]);
                example.setValue(specialAttributes[i], value += confidence / (double)numModels);
                ++i;
            }
        }
    }

    private void evaluateSpecialAttributes(ExampleSet exampleSet, Attribute[] specialAttributes) {
        Attribute exSetLabel = exampleSet.getAttributes().getLabel();
        for (Example example : exampleSet) {
            int bestLabel = 0;
            double bestConf = -1.0;
            int n = 0;
            while (n < specialAttributes.length) {
                double curConf = example.getValue(specialAttributes[n]);
                String curPredS = this.getLabel().getMapping().mapIndex(n);
                example.setConfidence(curPredS, curConf);
                if (curConf > bestConf) {
                    bestConf = curConf;
                    bestLabel = n;
                }
                ++n;
            }
            example.setValue(example.getAttributes().getPredictedLabel(), exSetLabel.getMapping().mapString(this.getLabel().getMapping().mapIndex(bestLabel)));
        }
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        ExtendedJTabbedPane tabPane = new ExtendedJTabbedPane();
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            tabPane.add("Model " + (i + 1), model.getVisualizationComponent(container));
            ++i;
        }
        return tabPane;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + com.rapidminer.tools.Tools.getLineSeparator() + "Number of inner models: " + this.getNumberOfModels() + com.rapidminer.tools.Tools.getLineSeparators(2));
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            result.append(String.valueOf(i > 0 ? com.rapidminer.tools.Tools.getLineSeparator() : "") + "Embedded model #" + i + ":" + com.rapidminer.tools.Tools.getLineSeparator() + model.toResultString());
            ++i;
        }
        return result.toString();
    }
}

