/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.RelativeRegressionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.Ontology;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeRegression
extends AbstractMetaLearner {
    public static final String PARAMETER_RELATIVE_ATTRIBUTE = "relative_attribute";

    public RelativeRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        int relativeAttributeIndex = this.getParameterAsInt(PARAMETER_RELATIVE_ATTRIBUTE);
        if (Math.abs(relativeAttributeIndex) > exampleSet.getAttributes().size()) {
            throw new UserError((Operator)this, 207, relativeAttributeIndex, PARAMETER_RELATIVE_ATTRIBUTE, "must be between 1 and the number of attributes or between -1 and the negative number of attributes");
        }
        if (relativeAttributeIndex == 0) {
            throw new UserError((Operator)this, 207, relativeAttributeIndex, PARAMETER_RELATIVE_ATTRIBUTE, "must be between 1 and the number of attributes or between -1 and the negative number of attributes");
        }
        int headIndex = relativeAttributeIndex;
        if (relativeAttributeIndex < 0) {
            headIndex = exampleSet.getAttributes().size() + relativeAttributeIndex;
        }
        Attribute relativeAttribute = null;
        if (headIndex > 0) {
            int counter = 0;
            for (Attribute a : exampleSet.getAttributes()) {
                if (counter == headIndex) {
                    relativeAttribute = a;
                    break;
                }
                ++counter;
            }
        }
        if (relativeAttribute == null) {
            throw new UserError((Operator)this, 111, "counter: " + relativeAttributeIndex);
        }
        if (!relativeAttribute.isNumerical()) {
            throw new UserError((Operator)this, 120, relativeAttribute.getName(), Ontology.VALUE_TYPE_NAMES[relativeAttribute.getValueType()], Ontology.VALUE_TYPE_NAMES[2]);
        }
        String relativeAttributeName = relativeAttribute.getName();
        Attribute originalLabel = exampleSet.getAttributes().getLabel();
        Attribute transformedLabel = AttributeFactory.createAttribute(originalLabel, "Relative");
        exampleSet.getExampleTable().addAttribute(transformedLabel);
        exampleSet.getAttributes().addRegular(transformedLabel);
        for (Example e : exampleSet) {
            double originalLabelValue = e.getValue(originalLabel);
            double relativeValue = e.getValue(relativeAttribute);
            e.setValue(transformedLabel, originalLabelValue - relativeValue);
        }
        exampleSet.getAttributes().remove(originalLabel);
        exampleSet.getAttributes().setLabel(transformedLabel);
        Model baseModel = this.applyInnerLearner(exampleSet);
        exampleSet.getAttributes().remove(transformedLabel);
        exampleSet.getExampleTable().removeAttribute(transformedLabel);
        exampleSet.getAttributes().setLabel(originalLabel);
        return new RelativeRegressionModel(exampleSet, baseModel, relativeAttributeName);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_RELATIVE_ATTRIBUTE, "Indicates which attribute should be used as a base for the relative comparison (counting starts with 1 or -1; negative: counting starts with the last; positive: counting starts with the first).", -2147483647, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

