/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.tree.Edge;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree
implements Serializable {
    private static final long serialVersionUID = -5930873649086170840L;
    private String label = null;
    private List<Edge> children = new LinkedList<Edge>();
    private Map<String, Integer> counterMap = new LinkedHashMap<String, Integer>();
    private transient ExampleSet trainingSet = null;

    public Tree(ExampleSet trainingSet) {
        this.trainingSet = trainingSet;
    }

    public ExampleSet getTrainingSet() {
        return this.trainingSet;
    }

    public void addCount(String className, int count) {
        this.counterMap.put(className, count);
    }

    public int getCount(String className) {
        Integer count = this.counterMap.get(className);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public int getFrequencySum() {
        int sum = 0;
        for (Integer i : this.counterMap.values()) {
            sum += i.intValue();
        }
        return sum;
    }

    public int getSubtreeFrequencySum() {
        if (this.children.size() == 0) {
            return this.getFrequencySum();
        }
        int sum = 0;
        for (Edge edge : this.children) {
            sum += edge.getChild().getSubtreeFrequencySum();
        }
        return sum;
    }

    public Map<String, Integer> getCounterMap() {
        return this.counterMap;
    }

    public void setLeaf(String label) {
        this.label = label;
    }

    public void addChild(Tree child, SplitCondition condition) {
        this.children.add(new Edge(child, condition));
        Collections.sort(this.children);
    }

    public void removeChildren() {
        this.children.clear();
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public String getLabel() {
        return this.label;
    }

    public Iterator<Edge> childIterator() {
        return this.children.iterator();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(null, this, "", buffer);
        return buffer.toString();
    }

    private void toString(SplitCondition condition, Tree tree, String indent, StringBuffer buffer) {
        if (condition != null) {
            buffer.append(condition.toString());
        }
        if (!tree.isLeaf()) {
            Iterator<Edge> childIterator = tree.childIterator();
            while (childIterator.hasNext()) {
                buffer.append(Tools.getLineSeparator());
                buffer.append(indent);
                Edge edge = childIterator.next();
                this.toString(edge.getCondition(), edge.getChild(), String.valueOf(indent) + "|   ", buffer);
            }
        } else {
            buffer.append(": ");
            buffer.append(tree.getLabel());
            buffer.append(" " + tree.counterMap.toString());
        }
    }
}

