/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.meta.ESParameterOptimization;
import com.rapidminer.operator.meta.ParameterOptimizationOperator;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionaryParameterOptimizationOperator
extends ParameterOptimizationOperator {
    public static final String PARAMETER_MAX_GENERATIONS = "max_generations";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_TOURNAMENT_FRACTION = "tournament_fraction";
    public static final String PARAMETER_KEEP_BEST = "keep_best";
    public static final String PARAMETER_MUTATION_TYPE = "mutation_type";
    public static final String PARAMETER_SELECTION_TYPE = "selection_type";
    public static final String PARAMETER_CROSSOVER_PROB = "crossover_prob";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    public static final String PARAMETER_SHOW_CONVERGENCE_PLOT = "show_convergence_plot";
    private IOContainer input;
    private ESOptimization optimizer;
    private Operator[] operators;
    private String[] parameters;
    private OptimizationValueType[] types;

    public EvolutionaryParameterOptimizationOperator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("best", "best performance ever"){

            public double getDoubleValue() {
                return EvolutionaryParameterOptimizationOperator.this.optimizer.getBestFitnessEver();
            }
        });
    }

    public IOContainer getOptimizationInput() {
        return this.input;
    }

    public Operator[] getOptimizationOperators() {
        return this.operators;
    }

    public String[] getOptimizationParameters() {
        return this.parameters;
    }

    public OptimizationValueType[] getOptimizationValueTypes() {
        return this.types;
    }

    @Override
    public int getParameterValueMode() {
        return 1;
    }

    @Override
    public double getCurrentBestPerformance() {
        return this.optimizer.getBestFitnessInGeneration();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IOObject[] apply() throws OperatorException {
        int i;
        void var6_8;
        this.input = this.getInput();
        List<ParameterValues> parameterValuesList = this.parseParameterValues(this.getParameterList("parameters"));
        if (parameterValuesList == null) {
            throw new UserError(this, 922);
        }
        Iterator<ParameterValues> iterator = parameterValuesList.iterator();
        while (iterator.hasNext()) {
            ParameterValues parameterValues = iterator.next();
            if (parameterValues instanceof ParameterValueRange) continue;
            this.logWarning("found (and deleted) unsupported parameter value definition. Parameters have to be given as range (e.g. as [2;5.7]).");
            iterator.remove();
        }
        if (parameterValuesList.size() == 0) {
            throw new UserError(this, 922);
        }
        this.operators = new Operator[parameterValuesList.size()];
        this.parameters = new String[parameterValuesList.size()];
        double[] min = new double[parameterValuesList.size()];
        double[] max = new double[parameterValuesList.size()];
        this.types = new OptimizationValueType[parameterValuesList.size()];
        int index = 0;
        for (ParameterValueRange parameterValueRange : parameterValuesList) {
            this.operators[index] = parameterValueRange.getOperator();
            this.parameters[index] = parameterValueRange.getParameterType().getKey();
            min[index] = parameterValueRange.getMin();
            max[index] = parameterValueRange.getMax();
            ParameterType targetType = parameterValueRange.getParameterType();
            if (targetType == null) {
                throw new UserError((Operator)this, 906, parameterValueRange.getOperator() + "." + targetType.getKey());
            }
            if (targetType instanceof ParameterTypeDouble) {
                this.types[index] = OptimizationValueType.VALUE_TYPE_DOUBLE;
                this.log("Parameter type of parameter " + targetType.getKey() + ": double");
            } else if (targetType instanceof ParameterTypeInt) {
                this.types[index] = OptimizationValueType.VALUE_TYPE_INT;
                this.log("Parameter type of parameter " + targetType.getKey() + ": int");
            } else {
                throw new UserError((Operator)this, 909, targetType.getKey());
            }
            ++index;
        }
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        this.optimizer = this.createOptimizer(random);
        boolean bl = false;
        while (var6_8 < min.length) {
            this.optimizer.setMin((int)var6_8, min[var6_8]);
            this.optimizer.setMax((int)var6_8, max[var6_8]);
            this.optimizer.setValueType((int)var6_8, this.types[var6_8]);
            ++var6_8;
        }
        this.optimizer.optimize();
        double[] dArray = this.optimizer.getBestValuesEver();
        String[] bestValues = null;
        if (dArray != null) {
            bestValues = new String[dArray.length];
            i = 0;
            while (i < dArray.length) {
                bestValues[i] = this.types[i].equals((Object)OptimizationValueType.VALUE_TYPE_DOUBLE) ? String.valueOf(dArray[i]) : String.valueOf((int)Math.round(dArray[i]));
                ++i;
            }
        } else {
            bestValues = new String[this.operators.length];
            i = 0;
            while (i < bestValues.length) {
                bestValues[i] = "unknown";
                ++i;
            }
        }
        ParameterSet bestSet = new ParameterSet(this.operators, this.parameters, bestValues, this.optimizer.getBestPerformanceEver());
        this.input = null;
        this.optimizer = null;
        return new IOObject[]{bestSet, bestSet.getPerformance()};
    }

    protected ESOptimization createOptimizer(RandomGenerator random) throws UndefinedParameterError {
        return new ESParameterOptimization(this, this.operators.length, 0, this.getParameterAsInt(PARAMETER_MAX_GENERATIONS), this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL), this.getParameterAsInt(PARAMETER_POPULATION_SIZE), this.getParameterAsInt(PARAMETER_SELECTION_TYPE), this.getParameterAsDouble(PARAMETER_TOURNAMENT_FRACTION), this.getParameterAsBoolean(PARAMETER_KEEP_BEST), this.getParameterAsInt(PARAMETER_MUTATION_TYPE), this.getParameterAsDouble(PARAMETER_CROSSOVER_PROB), this.getParameterAsBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT), random, this);
    }

    public ESOptimization getOptimization() {
        return this.optimizer;
    }

    public PerformanceVector setParametersAndEvaluate(Individual individual) throws OperatorException {
        double[] currentValues = individual.getValues();
        int j = 0;
        while (j < currentValues.length) {
            String value = this.types[j].equals((Object)OptimizationValueType.VALUE_TYPE_DOUBLE) ? String.valueOf(currentValues[j]) : String.valueOf((int)Math.round(currentValues[j]));
            this.operators[j].getParameters().setParameter(this.parameters[j], value);
            this.log(this.operators[j] + "." + this.parameters[j] + " = " + value);
            ++j;
        }
        this.setInput(this.getOptimizationInput().copy());
        return this.getPerformance();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_MAX_GENERATIONS, "Stop after this many evaluations", 1, Integer.MAX_VALUE, 50));
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop after this number of generations without improvement (-1: optimize until max_iterations).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "The population size (-1: number of examples)", -1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_TOURNAMENT_FRACTION, "The fraction of the population used for tournament selection.", 0.0, Double.POSITIVE_INFINITY, 0.25));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_BEST, "Indicates if the best individual should survive (elititst selection).", true));
        types.add(new ParameterTypeCategory(PARAMETER_MUTATION_TYPE, "The type of the mutation operator.", ESOptimization.MUTATION_TYPES, 1));
        types.add(new ParameterTypeCategory(PARAMETER_SELECTION_TYPE, "The type of the selection operator.", ESOptimization.SELECTION_TYPES, 6));
        types.add(new ParameterTypeDouble(PARAMETER_CROSSOVER_PROB, "The probability for crossover.", 0.0, 1.0, 0.9));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT, "Indicates if a dialog with a convergence plot should be drawn.", false));
        return types;
    }

    public int getNumberOfOptimizationParameters() {
        return this.parameters.length;
    }
}

