/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingOperatorChain
extends OperatorChain {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_TIMEOUT = "timeout";
    private int currentIteration = 0;

    public IteratingOperatorChain(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The iteration currently performed by this looping operator."){

            public double getDoubleValue() {
                return IteratingOperatorChain.this.currentIteration;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int maxIterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        int timeOut = this.getParameterAsInt(PARAMETER_TIMEOUT);
        long stoptime = Long.MAX_VALUE;
        if (timeOut >= 0) {
            stoptime = System.currentTimeMillis() + 60000L * (long)timeOut;
        }
        IOContainer input = this.getInput();
        this.currentIteration = 0;
        while (this.currentIteration < maxIterations) {
            int j = 0;
            while (j < this.getNumberOfOperators()) {
                input = this.getOperator(j).apply(input);
                ++j;
            }
            if (timeOut >= 0 && System.currentTimeMillis() > stoptime) break;
            this.inApplyLoop();
            ++this.currentIteration;
        }
        return input.getIOObjects();
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_ITERATIONS, "Number of iterations", 0, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_TIMEOUT, "Timeout in minutes (-1: no timeout)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

