/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.CombinedInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SpecificInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearningCurveOperator
extends OperatorChain {
    public static final String PARAMETER_TRAINING_RATIO = "training_ratio";
    public static final String PARAMETER_STEP_FRACTION = "step_fraction";
    public static final String PARAMETER_START_FRACTION = "start_fraction";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private double lastFraction = Double.NaN;
    private double lastPerformance = Double.NaN;
    private double lastDeviation = Double.NaN;

    public LearningCurveOperator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("fraction", "The used fraction of data."){

            public double getDoubleValue() {
                return LearningCurveOperator.this.lastFraction;
            }
        });
        this.addValue(new ValueDouble("performance", "The last performance (main criterion)."){

            public double getDoubleValue() {
                return LearningCurveOperator.this.lastPerformance;
            }
        });
        this.addValue(new ValueDouble("deviation", "The variance of the last performance (main criterion)."){

            public double getDoubleValue() {
                return LearningCurveOperator.this.lastDeviation;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet originalExampleSet = this.getInput(ExampleSet.class);
        double trainingRatio = this.getParameterAsDouble(PARAMETER_TRAINING_RATIO);
        double stepFraction = this.getParameterAsDouble(PARAMETER_STEP_FRACTION);
        double startFraction = this.getParameterAsDouble(PARAMETER_START_FRACTION);
        if (startFraction <= 0.0) {
            startFraction = stepFraction;
        }
        int samplingType = this.getParameterAsInt(PARAMETER_SAMPLING_TYPE);
        int localSeed = this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED);
        SplittedExampleSet trainTestSplittedExamples = new SplittedExampleSet(originalExampleSet, trainingRatio, samplingType, localSeed);
        trainTestSplittedExamples.selectSingleSubset(0);
        this.lastFraction = startFraction;
        while (this.lastFraction <= 1.0) {
            trainTestSplittedExamples.selectSingleSubset(0);
            SplittedExampleSet growingTrainingSet = new SplittedExampleSet((ExampleSet)trainTestSplittedExamples, this.lastFraction, samplingType, localSeed);
            growingTrainingSet.selectSingleSubset(0);
            IOContainer input = new IOContainer(growingTrainingSet);
            input = this.getOperator(0).apply(input);
            trainTestSplittedExamples.selectSingleSubset(1);
            input = input.append(trainTestSplittedExamples);
            int i = 1;
            while (i < this.getNumberOfOperators()) {
                input = this.getOperator(i).apply(input);
                ++i;
            }
            PerformanceVector performance = input.remove(PerformanceVector.class);
            this.lastPerformance = performance.getMainCriterion().getAverage();
            this.lastDeviation = performance.getMainCriterion().getStandardDeviation();
            this.lastFraction += stepFraction;
            this.inApplyLoop();
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 0, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 1, new Class[]{ExampleSet.class, Model.class}, new Class[]{PerformanceVector.class}));
        return condition;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_TRAINING_RATIO, "The fraction of examples which shall be maximal used for training (dynamically growing), the rest is used for testing (fixed)", 0.0, 1.0, 0.05);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_STEP_FRACTION, "The fraction of examples which would be additionally used in each step.", 0.0, 1.0, 0.05);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_START_FRACTION, "Starts with this fraction of the training data and iteratively add step_fraction examples from the training data (-1: use step_fraction).", -1.0, 1.0, -1.0));
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "The local random seed for random number generation (-1: use global random generator).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

