/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.postprocessing.Threshold;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdApplier
extends Operator {
    public ThresholdApplier(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Threshold threshold = this.getInput(Threshold.class);
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        if (predictedLabel == null) {
            throw new UserError(this, 107);
        }
        int zeroIndex = predictedLabel.getMapping().mapString(threshold.getZeroClass());
        int oneIndex = predictedLabel.getMapping().mapString(threshold.getOneClass());
        for (Example example : exampleSet) {
            double oneClassConfidence = example.getConfidence(threshold.getOneClass());
            double crispPrediction = oneClassConfidence > threshold.getThreshold() ? oneIndex : zeroIndex;
            example.setValue(predictedLabel, crispPrediction);
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, Threshold.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

