/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferentiateSeries
extends AbstractSeriesProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_CHANGE = "change_mode";
    public static final String[] CHANGE_MODES = new String[]{"boolean", "direction", "difference", "ratio", "ln ratio", "percentage"};
    public static final int CHANGE_MODE_BOOLEAN = 0;
    public static final int CHANGE_MODE_DIRECTION = 1;
    public static final int CHANGE_MODE_DIFFERENCE = 2;
    public static final int CHANGE_MODE_RATIO = 3;
    public static final int CHANGE_MODE_LN_RATIO = 4;
    public static final int CHANGE_MODE_PERCENTAGE = 5;
    public static final String PARAMETER_LAG = "lag";
    public static final String PARAMETER_KEEP_ORIGINAL_ATTRIBUTE = "keep_original_attribute";

    public DifferentiateSeries(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute.isNominal()) {
            this.logWarning("attribute is not numerical: change attribute not created.");
            return exampleSet;
        }
        int changeMode = this.getParameterAsInt(PARAMETER_CHANGE);
        int lag = this.getParameterAsInt(PARAMETER_LAG);
        Attribute changeAttribute = null;
        switch (changeMode) {
            case 0: {
                changeAttribute = AttributeFactory.createAttribute("change(" + attribute.getName() + ")", 6);
                break;
            }
            case 1: {
                changeAttribute = AttributeFactory.createAttribute("change(" + attribute.getName() + ")", 1);
                break;
            }
            default: {
                changeAttribute = AttributeFactory.createAttribute("change(" + attribute.getName() + ")", 2);
            }
        }
        exampleSet.getExampleTable().addAttribute(changeAttribute);
        exampleSet.getAttributes().addRegular(changeAttribute);
        double[] window = new double[lag + 1];
        int index = 0;
        for (Example example : exampleSet) {
            example.setValue(changeAttribute, Double.NaN);
            if (index < lag) {
                window[index] = example.getValue(attribute);
                ++index;
                continue;
            }
            window[lag] = example.getValue(attribute);
            double changeValue = Double.NaN;
            switch (changeMode) {
                case 0: {
                    boolean changed = window[lag] != window[0];
                    changeValue = changed ? changeAttribute.getMapping().mapString("true") : changeAttribute.getMapping().mapString("false");
                    break;
                }
                case 1: {
                    if (window[lag] == window[0]) {
                        changeValue = changeAttribute.getMapping().mapString("no change");
                        break;
                    }
                    if (window[lag] > window[0]) {
                        changeValue = changeAttribute.getMapping().mapString("up");
                        break;
                    }
                    changeValue = changeAttribute.getMapping().mapString("down");
                    break;
                }
                case 2: {
                    changeValue = window[lag] - window[0];
                    break;
                }
                case 3: {
                    changeValue = window[lag] / window[0];
                    break;
                }
                case 4: {
                    changeValue = Math.log(window[lag] / window[0]);
                    break;
                }
                case 5: {
                    changeValue = (window[lag] / window[0] - 1.0) * 100.0;
                }
            }
            example.setValue(changeAttribute, changeValue);
            int i = 1;
            while (i < lag + 1) {
                window[i - 1] = window[i];
                ++i;
            }
            ++index;
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(attribute);
        }
        exampleSet.recalculateAttributeStatistics(changeAttribute);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the series attribute for MA calculation.", false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_CHANGE, "Type of change the new attribute should capture.", CHANGE_MODES, 2);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LAG, "Specifies the lag the should be considered for change evaluation.", 1, Integer.MAX_VALUE, 1);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE, "Indicates whether the original attribute should be kept in the data set.", true);
        types.add(type);
        return types;
    }
}

