/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.text;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.text.TextObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCleaner
extends Operator {
    private static final String PARAMETER_DELETION_REGEX = "deletion_regex";

    public TextCleaner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        TextObject text = this.getInput(TextObject.class);
        Pattern matchPattern = Pattern.compile(this.getParameterAsString(PARAMETER_DELETION_REGEX));
        Matcher matcher = matchPattern.matcher(text.getText());
        return new IOObject[]{new TextObject(matcher.replaceAll(""))};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameters = super.getParameterTypes();
        parameters.add(new ParameterTypeString(PARAMETER_DELETION_REGEX, "This regular expression specifies the parts of the string, which are deleted."));
        return parameters;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{TextObject.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{TextObject.class};
    }
}

