/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.significance;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.significance.SignificanceTestOperator;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.FDistribution;
import com.rapidminer.tools.math.SignificanceTestResult;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;

public class TTestSignificanceTestOperator
extends SignificanceTestOperator {
    public TTestSignificanceTestOperator(OperatorDescription description) {
        super(description);
    }

    public SignificanceTestResult performSignificanceTest(PerformanceVector[] allVectors, double alpha) {
        double[][] resultMatrix = new double[allVectors.length][allVectors.length];
        int i = 0;
        while (i < allVectors.length) {
            int j = 0;
            while (j < i + 1) {
                resultMatrix[i][j] = Double.NaN;
                ++j;
            }
            j = i + 1;
            while (j < allVectors.length) {
                resultMatrix[i][j] = this.getProbability(allVectors[i].getMainCriterion(), allVectors[j].getMainCriterion());
                ++j;
            }
            ++i;
        }
        return new TTestSignificanceTestResult(allVectors, resultMatrix, alpha);
    }

    private double getProbability(PerformanceCriterion pc1, PerformanceCriterion pc2) {
        double totalDeviation = ((double)(pc1.getAverageCount() - 1) * pc1.getVariance() + (double)(pc2.getAverageCount() - 1) * pc2.getVariance()) / (double)(pc1.getAverageCount() + pc2.getAverageCount() - 2);
        double factor = 1.0 / (1.0 / (double)pc1.getAverageCount() + 1.0 / (double)pc2.getAverageCount());
        double diff = pc1.getAverage() - pc2.getAverage();
        double t = factor * diff * diff / totalDeviation;
        FDistribution fDist = new FDistribution(1, pc1.getAverageCount() + pc2.getAverageCount() - 2);
        double prob = fDist.getProbabilityForValue(t);
        prob = prob < 0.0 ? 1.0 : 1.0 - prob;
        return prob;
    }

    public int getMinSize() {
        return 2;
    }

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public static class TTestSignificanceTestResult
    extends SignificanceTestResult {
        private static final long serialVersionUID = -5412090499056975997L;
        private PerformanceVector[] allVectors;
        private double[][] probMatrix;
        private double alpha = 0.05;

        public TTestSignificanceTestResult(PerformanceVector[] allVectors, double[][] probMatrix, double alpha) {
            this.allVectors = allVectors;
            this.probMatrix = probMatrix;
            this.alpha = alpha;
        }

        public String getName() {
            return "Pairwise t-Test";
        }

        public double getProbability() {
            return Double.NaN;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Probabilities for random values with the same result:" + Tools.getLineSeparator());
            int i = 0;
            while (i < this.allVectors.length) {
                int j = 0;
                while (j < this.allVectors.length) {
                    if (!Double.isNaN(this.probMatrix[i][j])) {
                        result.append(String.valueOf(Tools.formatNumber(this.probMatrix[i][j])) + "\t");
                    } else {
                        result.append("-----\t");
                    }
                    ++j;
                }
                result.append(Tools.getLineSeparator());
                ++i;
            }
            result.append("Values smaller than alpha=" + Tools.formatNumber(this.alpha) + " indicate a probably significant difference between the mean values!" + Tools.getLineSeparator());
            result.append("List of performance values:" + Tools.getLineSeparator());
            i = 0;
            while (i < this.allVectors.length) {
                result.append(String.valueOf(i) + ": " + Tools.formatNumber(this.allVectors[i].getMainCriterion().getAverage()) + " +/- " + Tools.formatNumber(Math.sqrt(this.allVectors[i].getMainCriterion().getVariance())) + Tools.getLineSeparator());
                ++i;
            }
            return result.toString();
        }

        public Component getVisualizationComponent(IOContainer container) {
            StringBuffer buffer = new StringBuffer();
            Color bgColor = SwingTools.LIGHTEST_YELLOW;
            String bgColorString = String.valueOf(Integer.toHexString(bgColor.getRed())) + Integer.toHexString(bgColor.getGreen()) + Integer.toHexString(bgColor.getBlue());
            buffer.append("<table bgcolor=\"" + bgColorString + "\" border=\"1\">");
            buffer.append("<tr><td></td>");
            int i = 0;
            while (i < this.allVectors.length) {
                buffer.append("<td>" + Tools.formatNumber(this.allVectors[i].getMainCriterion().getAverage()) + " +/- " + Tools.formatNumber(Math.sqrt(this.allVectors[i].getMainCriterion().getVariance())) + "</td>");
                ++i;
            }
            buffer.append("</tr>");
            i = 0;
            while (i < this.allVectors.length) {
                buffer.append("<tr><td>" + Tools.formatNumber(this.allVectors[i].getMainCriterion().getAverage()) + " +/- " + Tools.formatNumber(Math.sqrt(this.allVectors[i].getMainCriterion().getVariance())) + "</td>");
                int j = 0;
                while (j < this.allVectors.length) {
                    buffer.append("<td>");
                    if (!Double.isNaN(this.probMatrix[i][j])) {
                        double prob = this.probMatrix[i][j];
                        if (prob < this.alpha) {
                            buffer.append("<b>");
                        }
                        buffer.append(Tools.formatNumber(prob));
                        if (prob < this.alpha) {
                            buffer.append("</b>");
                        }
                    }
                    buffer.append("</td>");
                    ++j;
                }
                buffer.append("</tr>");
                ++i;
            }
            buffer.append("</table>");
            buffer.append("<br>Probabilities for random values with the same result.<br>Bold values are smaller than alpha=" + Tools.formatNumber(this.alpha) + " which indicates a probably significant difference between the actual mean values!");
            JEditorPane textPane = new JEditorPane("text/html", "<html><h1>" + this.getName() + "</h1>" + buffer.toString() + "</html>");
            textPane.setBackground(new JLabel().getBackground());
            textPane.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
            return new ExtendedJScrollPane(textPane);
        }
    }
}

