/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.NonSpecialAttributesExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.transformation.GroupedANOVAOperator;
import com.rapidminer.operator.visualization.dependencies.ANOVAMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.SignificanceTestResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANOVAMatrixOperator
extends Operator {
    public ANOVAMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        NonSpecialAttributesExampleSet exampleSet = new NonSpecialAttributesExampleSet(inputSet);
        ArrayList<String> nominalAttributes = new ArrayList<String>();
        ArrayList<String> numericalAttributes = new ArrayList<String>();
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            if (attribute.isNominal()) {
                nominalAttributes.add(attribute.getName());
                continue;
            }
            if (!attribute.isNumerical()) continue;
            numericalAttributes.add(attribute.getName());
        }
        GroupedANOVAOperator groupedAnovaOperator = null;
        try {
            groupedAnovaOperator = OperatorService.createOperator(GroupedANOVAOperator.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 109, GroupedANOVAOperator.class.getName());
        }
        double significanceLevel = this.getParameterAsDouble("significance_level");
        groupedAnovaOperator.setParameter("significance_level", String.valueOf(significanceLevel));
        groupedAnovaOperator.setParameter("only_distinct", String.valueOf(this.getParameterAsBoolean("only_distinct")));
        double[][] probabilities = new double[numericalAttributes.size()][nominalAttributes.size()];
        int numericalCounter = 0;
        while (numericalCounter < probabilities.length) {
            String numericalAttributeName = (String)numericalAttributes.get(numericalCounter);
            int nominalCounter = 0;
            while (nominalCounter < probabilities[numericalCounter].length) {
                String nominalAttributeName = (String)nominalAttributes.get(nominalCounter);
                groupedAnovaOperator.setParameter("anova_attribute", numericalAttributeName);
                groupedAnovaOperator.setParameter("group_by_attribute", nominalAttributeName);
                SignificanceTestResult testResult = groupedAnovaOperator.apply(new IOContainer((ExampleSet)exampleSet.clone())).get(SignificanceTestResult.class);
                probabilities[numericalCounter][nominalCounter] = testResult.getProbability();
                ++nominalCounter;
            }
            ++numericalCounter;
        }
        return new IOObject[]{exampleSet, new ANOVAMatrix(probabilities, numericalAttributes, nominalAttributes, significanceLevel)};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, ANOVAMatrix.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("significance_level", "The significance level for the ANOVA calculation.", 0.0, 1.0, 0.05));
        types.add(new ParameterTypeBoolean("only_distinct", "Indicates if only rows with distinct values for the aggregation attribute should be used for the calculation of the aggregation function.", false));
        return types;
    }
}

