/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
implements Cloneable,
Iterable<String> {
    public static final char PAIR_SEPARATOR = '\u241d';
    public static final char RECORD_SEPARATOR = '\u241e';
    private SortedMap<String, String> keyToValueMap = new TreeMap<String, String>();
    private SortedMap<String, ParameterType> keyToTypeMap = new TreeMap<String, ParameterType>();
    private List<String> keys = new LinkedList<String>();

    public Parameters() {
    }

    public Parameters(List<ParameterType> parameterTypes) {
        for (ParameterType type : parameterTypes) {
            this.keyToTypeMap.put(type.getKey(), type);
            this.keys.add(type.getKey());
        }
    }

    public Object clone() {
        Parameters clone = new Parameters();
        for (String key : this.keyToValueMap.keySet()) {
            String value = (String)this.keyToValueMap.get(key);
            ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
            if (type == null) continue;
            clone.keyToValueMap.put(key, value);
        }
        for (String key : this.keyToTypeMap.keySet()) {
            clone.keyToTypeMap.put(key, (ParameterType)this.keyToTypeMap.get(key));
        }
        clone.keys.clear();
        for (String key : this.keys) {
            clone.keys.add(key);
        }
        return clone;
    }

    @Override
    public Iterator<String> iterator() {
        return this.keys.iterator();
    }

    public ParameterType getParameterType(String key) {
        return (ParameterType)this.keyToTypeMap.get(key);
    }

    public boolean setParameter(String key, String value) {
        boolean knownType = true;
        if (value == null) {
            this.keyToValueMap.remove(key);
        } else {
            ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
            if (type != null) {
                value = type.transformNewValue(value);
                knownType = true;
            }
            this.keyToValueMap.put(key, value);
        }
        return knownType;
    }

    @Deprecated
    public void setParameterWithoutCheck(String key, String value) {
        this.setParameter(key, value);
    }

    public String getParameter(String key) throws UndefinedParameterError {
        if (this.keyToValueMap.containsKey(key)) {
            return (String)this.keyToValueMap.get(key);
        }
        ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
        if (type == null) {
            return null;
        }
        Object value = type.getDefaultValue();
        if (value == null && !type.isOptional()) {
            LogService.getGlobal().log("Parameter '" + key + "' is not set and has no default value.", 6);
            throw new UndefinedParameterError(key);
        }
        LogService.getGlobal().log("Parameter '" + key + "' is not set. Using default ('" + type.toString(value) + "').", 0);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Set<String> getKeys() {
        return this.keyToValueMap.keySet();
    }

    public boolean equals(Object o) {
        String otherXML;
        if (!(o instanceof Parameters)) {
            return false;
        }
        String thisXML = this.getXML("", true);
        return thisXML.equals(otherXML = ((Parameters)o).getXML("", true));
    }

    public int hashCode() {
        return this.getXML("", true).hashCode();
    }

    public String getXML(String indent, boolean hideDefault) {
        StringBuffer result = new StringBuffer();
        for (String key : this.keys) {
            String value = (String)this.keyToValueMap.get(key);
            ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
            if (type != null) {
                result.append(type.getXML(indent, key, value, hideDefault));
                continue;
            }
            result.append(String.valueOf(indent) + "<parameter key=\"" + key + "\"\tvalue=\"" + value.toString() + "\"/>" + Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String toString() {
        return this.keyToValueMap.toString();
    }

    public static String transformList2String(List<String[]> parameterList) {
        StringBuffer result = new StringBuffer();
        Iterator<String[]> i = parameterList.iterator();
        boolean first = true;
        while (i.hasNext()) {
            String[] objects = i.next();
            if (objects.length != 2) continue;
            String firstToken = objects[0];
            String secondToken = objects[1];
            if (!first) {
                result.append('\u241e');
            }
            if (secondToken != null) {
                result.append(String.valueOf(firstToken) + '\u241d' + secondToken);
            }
            first = false;
        }
        return result.toString();
    }

    public static List<String[]> transformString2List(String listString) {
        String[] splittedList;
        LinkedList<String[]> result = new LinkedList<String[]>();
        String[] stringArray = splittedList = listString.split(Character.valueOf('\u241e').toString());
        int n = splittedList.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair;
            String record = stringArray[n2];
            if (record.length() > 0 && (pair = record.split(Character.valueOf('\u241d').toString())).length == 2 && pair[0].length() > 0 && pair[1].length() > 0) {
                result.add(new String[]{pair[0], pair[1]});
            }
            ++n2;
        }
        return result;
    }

    public int notifyRenaming(String oldName, String newName) {
        int count = 0;
        for (String key : this.keyToValueMap.keySet()) {
            String oldValue = (String)this.keyToValueMap.get(key);
            if (oldValue.indexOf(Character.valueOf('\u241e').charValue()) >= 0) {
                String[] splittedList = oldValue.split(Character.valueOf('\u241e').toString());
                StringBuffer newValue = new StringBuffer();
                boolean first = true;
                String[] stringArray = splittedList;
                int n = splittedList.length;
                int n2 = 0;
                while (n2 < n) {
                    String record = stringArray[n2];
                    if (record.length() > 0) {
                        String[] pair = record.split(Character.valueOf('\u241d').toString());
                        if (pair.length == 2 && pair[0].length() > 0 && pair[1].length() > 0) {
                            pair[0] = this.performRenamingForSingleParameter(pair[0], oldName, newName);
                            pair[1] = this.performRenamingForSingleParameter(pair[1], oldName, newName);
                        }
                        if (!first) {
                            newValue.append(Character.valueOf('\u241e'));
                        }
                        first = false;
                        newValue.append(String.valueOf(pair[0]) + Character.valueOf('\u241d').toString() + pair[1]);
                    } else {
                        if (!first) {
                            newValue.append(Character.valueOf('\u241e'));
                        }
                        first = false;
                        newValue.append(record);
                    }
                    ++n2;
                }
                String newValueResult = newValue.toString();
                if (oldValue.equals(newValueResult)) continue;
                this.keyToValueMap.put(key, newValueResult);
                ++count;
                continue;
            }
            String newValue = this.performRenamingForSingleParameter(oldValue, oldName, newName);
            if (oldValue.equals(newValue)) continue;
            this.keyToValueMap.put(key, newValue);
            ++count;
        }
        return count;
    }

    private String performRenamingForSingleParameter(String oldValue, String oldName, String newName) {
        if (oldValue != null) {
            String rest = oldValue;
            StringBuffer newValue = new StringBuffer();
            int index = -1;
            while (rest.length() > 0 && (index = rest.indexOf(46)) >= 0) {
                String part = rest.substring(0, index);
                if (oldName.equals(part)) {
                    newValue.append(newName);
                } else {
                    newValue.append(part);
                }
                newValue.append('.');
                rest = rest.substring(index + 1);
            }
            if (oldName.equals(rest)) {
                newValue.append(newName);
            } else {
                newValue.append(rest);
            }
            return newValue.toString();
        }
        return oldValue;
    }
}

