/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.RapidMiner;
import com.rapidminer.Version;
import com.rapidminer.gui.look.fc.Bookmark;
import com.rapidminer.gui.look.fc.BookmarkIO;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ParameterService {
    public static void ensureRapidMinerHomeSet() {
        String home = System.getProperty("rapidminer.home");
        if (home != null) {
            LogService.getGlobal().log("rapidminer.home is '" + home + "'.", 3);
        } else {
            LogService.getGlobal().log("Property rapidminer.home is not set. Guessing.", 3);
            String classpath = System.getProperty("java.class.path");
            String[] pathComponents = classpath.split(File.pathSeparator);
            boolean found = false;
            int i = 0;
            while (i < pathComponents.length) {
                String path = pathComponents[i].trim();
                if (path.endsWith("rapidminer.jar")) {
                    File jar = new File(path).getAbsoluteFile();
                    String message = "Trying parent directory of '" + jar + "'...";
                    File dir = jar.getParentFile();
                    if (dir != null) {
                        if ((dir = dir.getParentFile()) != null) {
                            message = String.valueOf(message) + "gotcha!";
                            found = true;
                            System.setProperty("rapidminer.home", dir.getAbsolutePath());
                        } else {
                            message = String.valueOf(message) + "failed";
                        }
                    } else {
                        message = String.valueOf(message) + "failed";
                    }
                    LogService.getGlobal().log(message, 3);
                }
                ++i;
            }
            if (!found) {
                String message;
                block20: {
                    message = "Trying base directory of classes (build) '";
                    URL url = ParameterService.class.getClassLoader().getResource(".");
                    if (url != null) {
                        try {
                            File dir = new File(new URI(url.toString()));
                            if (dir.exists()) {
                                dir = dir.getParentFile();
                                message = String.valueOf(message) + dir + "'...";
                                if (dir != null) {
                                    message = String.valueOf(message) + "gotcha!";
                                    found = true;
                                    try {
                                        System.setProperty("rapidminer.home", dir.getCanonicalPath());
                                    }
                                    catch (IOException e) {
                                        System.setProperty("rapidminer.home", dir.getAbsolutePath());
                                    }
                                } else {
                                    message = String.valueOf(message) + "failed";
                                }
                                break block20;
                            }
                            message = String.valueOf(message) + "failed";
                        }
                        catch (URISyntaxException e) {
                            message = String.valueOf(message) + "failed";
                        }
                        catch (IllegalArgumentException e) {
                            message = String.valueOf(message) + "failed";
                        }
                    } else {
                        message = String.valueOf(message) + "failed";
                    }
                }
                LogService.getGlobal().log(message, 3);
            }
            if (!found) {
                LogService.getGlobal().log("No indication for the home of rapidminer found. Assuming '.' ...", 3);
                System.setProperty("rapidminer.home", ".");
            }
        }
        ParameterService.getProperty("rapidminer.home");
    }

    public static void init() {
        ParameterService.init(null, true);
    }

    public static void init(InputStream operatorsXMLStream, boolean addWekaOperators) {
        ParameterService.init(operatorsXMLStream, null, addWekaOperators);
    }

    public static void init(InputStream operatorsXMLStream, InputStream additionalXMLStream, boolean addWekaOperators) {
        ParameterService.init(operatorsXMLStream, additionalXMLStream, null, addWekaOperators);
    }

    public static void init(InputStream operatorsXMLStream, InputStream additionalXMLStream, InputStream additionalIOObjectsXMLStream, boolean addWekaOperators) {
        String additionalObjects;
        String additionalOperators;
        ParameterService.loadRCFile();
        InputStream operatorDescriptionStream = operatorsXMLStream;
        if (operatorDescriptionStream == null) {
            URL operatorURL = OperatorService.getMainOperators();
            try {
                if (operatorURL != null) {
                    operatorDescriptionStream = operatorURL.openStream();
                } else {
                    LogService.getGlobal().log("Cannot find 'operators.xml'.", 6);
                }
            }
            catch (IOException e) {
                LogService.getGlobal().log("Cannot read 'operators.xml'.", 6);
            }
        }
        if (operatorDescriptionStream != null) {
            OperatorService.registerOperators("operators.xml", operatorDescriptionStream, null, addWekaOperators);
        }
        try {
            if (operatorDescriptionStream != null && operatorsXMLStream == null) {
                operatorDescriptionStream.close();
            }
        }
        catch (IOException operatorURL) {
            // empty catch block
        }
        if (additionalXMLStream != null) {
            OperatorService.registerOperators("Additional Operators from Init", additionalXMLStream, null, addWekaOperators);
        }
        if (additionalIOObjectsXMLStream != null) {
            RendererService.init("Init", additionalIOObjectsXMLStream);
        }
        if ((additionalOperators = System.getProperty("rapidminer.operators.additional")) != null && additionalOperators.length() > 0) {
            String[] additionalOperatorFileNames = additionalOperators.split(File.pathSeparator);
            int i = 0;
            while (i < additionalOperatorFileNames.length) {
                File additionalOperatorFile = new File(additionalOperatorFileNames[i]);
                if (additionalOperatorFile.exists()) {
                    try {
                        OperatorService.registerOperators(additionalOperatorFile.getPath(), new FileInputStream(additionalOperatorFile), null, addWekaOperators);
                    }
                    catch (IOException e) {
                        LogService.getGlobal().log("Cannot read '" + additionalOperatorFile + "'.", 6);
                    }
                } else {
                    LogService.getGlobal().log("Cannot find operator description file '" + additionalOperatorFileNames[i] + "'", 6);
                }
                ++i;
            }
        }
        if ((additionalObjects = System.getProperty("rapidminer.objects.additional")) != null && additionalObjects.length() > 0) {
            String[] additionalObjectFileNames = additionalObjects.split(File.pathSeparator);
            int i = 0;
            while (i < additionalObjectFileNames.length) {
                File additionalObjectFile = new File(additionalObjectFileNames[i]);
                if (additionalObjectFile.exists()) {
                    try {
                        RendererService.init(additionalObjectFile.getPath(), new FileInputStream(additionalObjectFile));
                    }
                    catch (IOException e) {
                        LogService.getGlobal().log("Cannot read '" + additionalObjectFile + "'.", 6);
                    }
                } else {
                    LogService.getGlobal().log("Cannot find IOObject description file '" + additionalObjectFileNames[i] + "'", 6);
                }
                ++i;
            }
        }
    }

    public static File getUserWorkspace() {
        String workspacePath;
        block17: {
            File workspaceLocationFile = ParameterService.getUserConfigFile("workspace");
            if (!workspaceLocationFile.exists()) {
                return null;
            }
            BufferedReader in = null;
            workspacePath = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(workspaceLocationFile));
                    workspacePath = in.readLine();
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (workspacePath != null) {
            boolean creationResult;
            File workspace = new File(workspacePath);
            if (!workspace.exists() && !(creationResult = workspace.mkdir())) {
                LogService.getGlobal().logWarning("Cannot create workspace directory: " + workspace);
                return null;
            }
            return workspace;
        }
        return null;
    }

    public static final void setUserWorkspace(File workspace) {
        File newSampleDir;
        boolean result;
        if (!workspace.exists() && !(result = workspace.mkdir())) {
            LogService.getGlobal().logWarning("Unable to create workspace directory: " + workspace);
        }
        if ((newSampleDir = new File(workspace, "sample")).exists()) {
            Tools.delete(newSampleDir);
            boolean creationResult = newSampleDir.mkdir();
            if (!creationResult) {
                LogService.getGlobal().logWarning("Cannot create user sample directory: " + newSampleDir);
            }
        }
        File globalSampleDir = ParameterService.getSampleDir();
        try {
            Tools.copy(globalSampleDir, newSampleDir);
        }
        catch (IOException e1) {
            LogService.getGlobal().logWarning("Cannot copy sample directory to workspace: " + e1.getMessage());
        }
        List<Bookmark> bookmarks = null;
        File bookmarksFile = new File(ParameterService.getUserRapidMinerDir(), ".bookmarks");
        if (bookmarksFile.exists()) {
            bookmarks = BookmarkIO.readBookmarks(bookmarksFile);
            boolean changedWorkspace = false;
            boolean changedSamples = false;
            boolean changedSampleData = false;
            if (bookmarks != null) {
                File newSampleDataDir;
                for (Bookmark bookmark : bookmarks) {
                    if (bookmark.getName().equals("Workspace")) {
                        bookmark.setPath(workspace.getAbsolutePath());
                        changedWorkspace = true;
                        continue;
                    }
                    if (bookmark.getName().equals("Samples")) {
                        if (newSampleDir.exists()) {
                            bookmark.setPath(newSampleDir.getAbsolutePath());
                        }
                        changedSamples = true;
                        continue;
                    }
                    if (!bookmark.getName().equals("Sample Data")) continue;
                    File newSampleDataDir2 = new File(newSampleDir, "data");
                    if (newSampleDataDir2.exists()) {
                        bookmark.setPath(newSampleDataDir2.getAbsolutePath());
                    }
                    changedSampleData = true;
                }
                if (!changedWorkspace) {
                    Bookmark workspaceBookmark = new Bookmark("Workspace", workspace.getAbsolutePath());
                    bookmarks.add(workspaceBookmark);
                }
                if (!changedSamples && newSampleDir.exists()) {
                    Bookmark sampleBookmark = new Bookmark("Samples", newSampleDir.getAbsolutePath());
                    bookmarks.add(sampleBookmark);
                }
                if (!changedSampleData && (newSampleDataDir = new File(newSampleDir, "data")).exists()) {
                    Bookmark sampleDataBookmark = new Bookmark("Sample Data", newSampleDataDir.getAbsolutePath());
                    bookmarks.add(sampleDataBookmark);
                }
            }
        }
        if (bookmarks == null) {
            File newSampleDataDir;
            bookmarks = new LinkedList<Bookmark>();
            Bookmark workspaceBookmark = new Bookmark("Workspace", workspace.getAbsolutePath());
            bookmarks.add(workspaceBookmark);
            if (newSampleDir.exists()) {
                Bookmark sampleBookmark = new Bookmark("Samples", newSampleDir.getAbsolutePath());
                bookmarks.add(sampleBookmark);
            }
            if ((newSampleDataDir = new File(newSampleDir, "data")).exists()) {
                Bookmark sampleDataBookmark = new Bookmark("Sample Data", newSampleDataDir.getAbsolutePath());
                bookmarks.add(sampleDataBookmark);
            }
        }
        BookmarkIO.writeBookmarks(bookmarks, bookmarksFile);
        File workspaceLocationFile = ParameterService.getUserConfigFile("workspace");
        PrintWriter workspaceOut = null;
        try {
            try {
                workspaceOut = new PrintWriter(new FileWriter(workspaceLocationFile));
                workspaceOut.println(workspace.getAbsolutePath());
            }
            catch (IOException e) {
                LogService.getGlobal().logWarning("Cannot write workspace location: " + e.getMessage());
                if (workspaceOut != null) {
                    workspaceOut.close();
                }
            }
        }
        finally {
            if (workspaceOut != null) {
                workspaceOut.close();
            }
        }
    }

    public static void copyMainUserConfigFile(VersionNumber oldVersion, VersionNumber newVersion) {
        Properties oldProperties = ParameterService.readPropertyFile(ParameterService.getVersionedUserConfigFile(oldVersion, "rapidminerrc." + System.getProperty("os.name")));
        ParameterService.writeProperties(oldProperties, ParameterService.getMainUserConfigFile());
    }

    private static Properties readPropertyFile(File file) {
        Properties properties;
        block17: {
            properties = new Properties();
            if (file.exists()) {
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(file);
                        properties.load(in);
                    }
                    catch (IOException e) {
                        LogService.getGlobal().logWarning("Cannot read main user properties: " + e.getMessage());
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e2) {
                                LogService.getGlobal().logWarning("Cannot close connection to user properties: " + e2.getMessage());
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            LogService.getGlobal().logWarning("Cannot close connection to user properties: " + e.getMessage());
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        LogService.getGlobal().logWarning("Cannot close connection to user properties: " + e.getMessage());
                    }
                }
            }
        }
        block10: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String typeKey = (String)entry.getKey();
            String typeValue = (String)entry.getValue();
            if (typeValue == null) continue;
            for (ParameterType type : RapidMiner.getRapidMinerProperties()) {
                if (!type.getKey().equals(typeKey)) continue;
                properties.put(typeKey, type.transformNewValue(typeValue));
                continue block10;
            }
        }
        return properties;
    }

    public static void writeProperties(Properties properties, File file) {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(ParameterService.getMainUserConfigFile()));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String typeKey = (String)entry.getKey();
                    String typeValue = (String)entry.getValue();
                    if (typeValue == null) continue;
                    for (ParameterType type : RapidMiner.getRapidMinerProperties()) {
                        if (!type.getKey().equals(typeKey)) continue;
                        typeValue = type.toString(typeValue);
                        break;
                    }
                    out.println(String.valueOf(typeKey) + " = " + typeValue);
                }
            }
            catch (IOException e) {
                LogService.getGlobal().logWarning("Cannot write user properties: " + e.getMessage());
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void writePropertyIntoMainUserConfigFile(String key, String value) {
        Properties userProperties = ParameterService.readPropertyFile(ParameterService.getMainUserConfigFile());
        userProperties.setProperty(key, value);
        System.setProperty(key, value);
        ParameterService.writeProperties(userProperties, ParameterService.getMainUserConfigFile());
    }

    public static File getMainUserConfigFile() {
        return ParameterService.getUserConfigFile("rapidminerrc." + System.getProperty("os.name"));
    }

    public static File getUserConfigFile(String name) {
        return ParameterService.getVersionedUserConfigFile(new VersionNumber(Version.getLongVersion()), name);
    }

    public static File getVersionedUserConfigFile(VersionNumber versionNumber, String name) {
        String configName = name;
        if (configName.startsWith("rapidminerrc") && versionNumber != null) {
            configName = String.valueOf(versionNumber.toString().replaceAll("\\.", "_")) + "_" + configName;
        }
        return new File(ParameterService.getUserRapidMinerDir(), configName);
    }

    public static File getUserRapidMinerDir() {
        File homeDir = new File(System.getProperty("user.home"));
        File userHomeDir = new File(homeDir, ".rapidminer");
        if (!userHomeDir.exists()) {
            LogService.getGlobal().log("Creating directory '" + userHomeDir + "'", 3);
            boolean result = userHomeDir.mkdir();
            if (!result) {
                LogService.getGlobal().logWarning("Unable to create user home rapidminer directory " + userHomeDir);
            }
        }
        return userHomeDir;
    }

    private static void loadRCFile() {
        File globalRC = ParameterService.getConfigFile("rapidminerrc");
        ParameterService.loadAllRCFiles(globalRC.getPath());
        ParameterService.loadAllRCFiles(ParameterService.getUserConfigFile("rapidminerrc").getAbsolutePath());
        ParameterService.loadAllRCFiles(new File(new File(System.getProperty("user.dir")), "rapidminerrc").getAbsolutePath());
        String localRC = System.getProperty("rapidminer.rcfile");
        if (localRC != null) {
            ParameterService.loadRCFile(localRC);
        } else {
            LogService.getGlobal().log("Trying rapidminer.rcfile. Property not specified...skipped", 3);
        }
    }

    private static void loadAllRCFiles(String rcFileName) {
        ParameterService.loadRCFile(rcFileName);
        ParameterService.loadRCFile(String.valueOf(rcFileName) + "." + System.getProperty("os.name"));
    }

    private static void loadRCFile(String rcFileName) {
        if (rcFileName == null) {
            return;
        }
        File rcFile = new File(rcFileName);
        if (!rcFile.exists()) {
            LogService.getGlobal().log("Trying rcfile '" + rcFile + "'...skipped", 3);
            return;
        }
        Properties props = ParameterService.readPropertyFile(rcFile);
        System.getProperties().putAll((Map<?, ?>)props);
        LogService.getGlobal().log("Read rcfile '" + rcFile + "'.", 3);
    }

    private static String getProperty(String key) {
        String property = System.getProperty(key);
        if (property == null) {
            throw new RuntimeException("Property '" + key + "' not set!");
        }
        return property;
    }

    public static File getRapidMinerHome() {
        return new File(ParameterService.getProperty("rapidminer.home"));
    }

    public static File getConfigFile(String name) {
        File home = ParameterService.getRapidMinerHome();
        return new File(home, "etc" + File.separator + name);
    }

    public static File getLibraryFile(String name) {
        File home = ParameterService.getRapidMinerHome();
        return new File(home, "lib" + File.separator + name);
    }

    public static File getSampleFile(String filename) {
        File home = ParameterService.getRapidMinerHome();
        return new File(home, "sample" + File.separator + filename);
    }

    public static File getUserSampleFile(String filename) {
        File workspace = ParameterService.getUserWorkspace();
        return new File(workspace, "sample" + File.separator + filename);
    }

    public static File getSourceFile(String filename) {
        File home = ParameterService.getRapidMinerHome();
        return new File(home, "src" + File.separator + filename);
    }

    public static File getPluginDir() {
        return ParameterService.getLibraryFile("plugins");
    }

    public static File getSampleDir() {
        File home = ParameterService.getRapidMinerHome();
        return new File(home, "sample");
    }

    public static boolean booleanValue(String value, boolean deflt) {
        if (value == null) {
            return deflt;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("yes")) {
            return true;
        }
        if (value.equals("y")) {
            return true;
        }
        if (value.equals("on")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("no")) {
            return false;
        }
        if (value.equals("n")) {
            return false;
        }
        if (value.equals("off")) {
            return false;
        }
        return deflt;
    }
}

