/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class EpanechnikovKernel
extends Kernel {
    private static final long serialVersionUID = -4683350345234451645L;
    private double sigma = 1.0;
    private double degree = 1.0;

    public int getType() {
        return 5;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getDegree() {
        return this.degree;
    }

    public void setDegree(double degree) {
        this.degree = degree;
    }

    public double calculateDistance(double[] x1, double[] x2) {
        double expression = this.norm2(x1, x2) / this.sigma;
        if (expression > 1.0) {
            return 0.0;
        }
        double minus = 1.0 - expression;
        return Math.pow(minus, this.degree);
    }

    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer("pow((1 - (");
        boolean first = true;
        int i = 0;
        while (i < x.length) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                result.append(String.valueOf(valueString) + " * " + valueString);
            } else {
                result.append(" + " + valueString + " * " + valueString);
            }
            first = false;
            ++i;
        }
        result.append(")), " + this.degree + ")");
        return result.toString();
    }

    public String toString() {
        return "Epanechnikov Kernel with" + Tools.getLineSeparator() + "  sigma: " + Tools.formatNumber(this.getSigma()) + Tools.getLineSeparator() + "  degree: " + this.degree;
    }
}

