/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class SigmoidKernel
extends Kernel {
    private static final long serialVersionUID = -4503893127271607088L;
    private double a = 1.0;
    private double b = 0.0;

    public int getType() {
        return 3;
    }

    public void setSigmoidParameters(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public double calculateDistance(double[] x1, double[] x2) {
        double prod = this.a * this.innerProduct(x1, x2) + this.b;
        double e1 = Math.exp(prod);
        double e2 = Math.exp(-prod);
        return (e1 - e2) / (e1 + e2);
    }

    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < x.length) {
            double value = x[i];
            if (!Tools.isZero(value)) {
                if (value < 0.0) {
                    if (first) {
                        result.append("-" + Math.abs(value) + " * " + attributeConstructions[i]);
                    } else {
                        result.append(" - " + Math.abs(value) + " * " + attributeConstructions[i]);
                    }
                } else if (first) {
                    result.append(String.valueOf(value) + " * " + attributeConstructions[i]);
                } else {
                    result.append(" + " + value + " * " + attributeConstructions[i]);
                }
                first = false;
            }
            ++i;
        }
        String e1 = "exp(" + result.toString() + ")";
        String e2 = "exp(-1 * (" + result.toString() + "))";
        return "((" + e1 + " - " + e2 + ") / (" + e1 + " + " + e2 + "))";
    }

    public String toString() {
        return "Sigmoid Kernel with" + Tools.getLineSeparator() + "  a: " + Tools.formatNumber(this.a) + Tools.getLineSeparator() + "  b: " + Tools.formatNumber(this.b);
    }
}

