/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.jsapi;

import com.sun.speech.freetts.ValidationException;
import com.sun.speech.freetts.jsapi.FreeTTSSynthesizer;
import com.sun.speech.freetts.jsapi.FreeTTSVoice;
import java.util.LinkedList;
import java.util.Locale;
import javax.speech.Engine;
import javax.speech.EngineCreate;
import javax.speech.EngineException;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class FreeTTSSynthesizerModeDesc
extends SynthesizerModeDesc
implements EngineCreate {
    public FreeTTSSynthesizerModeDesc(String engineName, String modeName, Locale locale) {
        super(engineName, modeName, locale, Boolean.FALSE, null);
    }

    public Voice[] getVoices() {
        LinkedList<FreeTTSVoice> voiceList = new LinkedList<FreeTTSVoice>();
        Voice[] voices = super.getVoices();
        int count = 0;
        for (int i = 0; i < voices.length; ++i) {
            FreeTTSVoice freettsVoice = (FreeTTSVoice)voices[i];
            try {
                freettsVoice.validate();
                voiceList.add(freettsVoice);
                ++count;
                continue;
            }
            catch (ValidationException ve) {
                // empty catch block
            }
        }
        Voice[] validVoices = new Voice[count];
        voiceList.toArray(validVoices);
        return validVoices;
    }

    public void validate() throws ValidationException {
        Voice[] voices = super.getVoices();
        int invalidCount = 0;
        String validationMessage = "";
        for (int i = 0; i < voices.length; ++i) {
            try {
                ((FreeTTSVoice)voices[i]).validate();
                continue;
            }
            catch (ValidationException ve) {
                ++invalidCount;
                validationMessage = validationMessage + ve.getMessage() + "\n";
            }
        }
        if (invalidCount == voices.length) {
            throw new ValidationException(validationMessage + this.getModeName() + " has no valid voices.");
        }
    }

    public Engine createEngine() throws IllegalArgumentException, EngineException, SecurityException {
        FreeTTSSynthesizer s = new FreeTTSSynthesizer(this);
        return s;
    }
}

