/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import marytts.cart.DecisionNode;
import marytts.cart.DirectedGraph;
import marytts.cart.DirectedGraphNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.cart.io.DirectedGraphReader;
import marytts.features.FeatureVector;
import marytts.util.MaryUtils;
import marytts.util.data.MaryHeader;
import org.apache.log4j.Logger;

public class DirectedGraphWriter {
    protected Logger logger = MaryUtils.getLogger(this.getClass().getName());

    public void saveGraph(DirectedGraph graph, String destFile) throws IOException {
        if (graph == null) {
            throw new NullPointerException("Cannot dump null graph");
        }
        if (destFile == null) {
            throw new NullPointerException("No destination file");
        }
        this.logger.debug("Dumping directed graph in Mary format to " + destFile + " ...");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(destFile)));
        MaryHeader hdr = new MaryHeader(110);
        hdr.writeTo(out);
        Properties props = graph.getProperties();
        if (props == null) {
            out.writeShort(0);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            props.store(baos, null);
            byte[] propData = baos.toByteArray();
            out.writeShort(propData.length);
            out.write(propData);
        }
        graph.getFeatureDefinition().writeBinaryTo(out);
        this.dumpBinary(graph, out);
        out.close();
        this.logger.debug(" ... done\n");
    }

    public void toTextOut(DirectedGraph graph, PrintWriter pw) throws IOException {
        try {
            int numLeafNodes = this.setUniqueLeafNodeIds(graph);
            int numDecNodes = this.setUniqueDecisionNodeIds(graph);
            int numGraphNodes = this.setUniqueDirectedGraphNodeIds(graph);
            pw.println("Num decision nodes= " + numDecNodes + "  Num leaf nodes= " + numLeafNodes + "  Num directed graph nodes= " + numGraphNodes);
            this.printDecisionNodes(graph, null, pw);
            pw.println("\n----------------\n");
            this.printLeafNodes(graph, null, pw);
            pw.println("\n----------------\n");
            this.printDirectedGraphNodes(graph, null, pw);
            pw.flush();
            pw.close();
        }
        catch (IOException ioe) {
            IOException newIOE = new IOException("Error dumping graph to standard output");
            newIOE.initCause(ioe);
            throw newIOE;
        }
    }

    private int setUniqueLeafNodeIds(DirectedGraph graph) {
        int i = 0;
        for (LeafNode l : graph.getLeafNodes()) {
            l.setUniqueLeafId(++i);
        }
        return i;
    }

    private int setUniqueDecisionNodeIds(DirectedGraph graph) {
        int i = 0;
        for (DecisionNode d : graph.getDecisionNodes()) {
            d.setUniqueDecisionNodeId(++i);
        }
        return i;
    }

    private int setUniqueDirectedGraphNodeIds(DirectedGraph graph) {
        int i = 0;
        for (DirectedGraphNode g : graph.getDirectedGraphNodes()) {
            g.setUniqueGraphNodeID(++i);
        }
        return i;
    }

    private void dumpBinary(DirectedGraph graph, DataOutput os) throws IOException {
        try {
            int numLeafNodes = this.setUniqueLeafNodeIds(graph);
            int numDecNodes = this.setUniqueDecisionNodeIds(graph);
            int numGraphNodes = this.setUniqueDirectedGraphNodeIds(graph);
            int maxNum = 0x40000000;
            if (numLeafNodes > maxNum || numDecNodes > maxNum || numGraphNodes > maxNum) {
                throw new UnsupportedOperationException("Cannot write more than " + maxNum + " nodes of one type in this format");
            }
            os.writeInt(numDecNodes);
            this.printDecisionNodes(graph, os, null);
            os.writeInt(numLeafNodes);
            this.printLeafNodes(graph, os, null);
            os.writeInt(numGraphNodes);
            this.printDirectedGraphNodes(graph, os, null);
        }
        catch (IOException ioe) {
            IOException newIOE = new IOException("Error dumping CART to output stream");
            newIOE.initCause(ioe);
            throw newIOE;
        }
    }

    private void printDecisionNodes(DirectedGraph graph, DataOutput out, PrintWriter pw) throws IOException {
        for (DecisionNode decNode : graph.getDecisionNodes()) {
            int id = decNode.getUniqueDecisionNodeId();
            String nodeDefinition = decNode.getNodeDefinition();
            int featureIndex = decNode.getFeatureIndex();
            DecisionNode.Type nodeType = decNode.getDecisionNodeType();
            if (out != null) {
                out.writeInt(featureIndex);
                out.writeInt(nodeType.ordinal());
                switch (nodeType) {
                    case BinaryByteDecisionNode: {
                        out.writeInt(((DecisionNode.BinaryByteDecisionNode)decNode).getCriterionValueAsByte());
                        assert (decNode.getNumberOfDaugthers() == 2);
                        break;
                    }
                    case BinaryShortDecisionNode: {
                        out.writeInt(((DecisionNode.BinaryShortDecisionNode)decNode).getCriterionValueAsShort());
                        assert (decNode.getNumberOfDaugthers() == 2);
                        break;
                    }
                    case BinaryFloatDecisionNode: {
                        out.writeFloat(((DecisionNode.BinaryFloatDecisionNode)decNode).getCriterionValueAsFloat());
                        assert (decNode.getNumberOfDaugthers() == 2);
                        break;
                    }
                    case ByteDecisionNode: 
                    case ShortDecisionNode: {
                        out.writeInt(decNode.getNumberOfDaugthers());
                    }
                }
                int n = decNode.getNumberOfDaugthers();
                for (int i = 0; i < n; ++i) {
                    int daughterID;
                    Node daughter = decNode.getDaughter(i);
                    if (daughter == null) {
                        out.writeInt(0);
                        continue;
                    }
                    if (daughter.isDecisionNode()) {
                        daughterID = ((DecisionNode)daughter).getUniqueDecisionNodeId();
                        out.writeInt(daughterID |= DirectedGraphReader.DECISIONNODE << 30);
                        continue;
                    }
                    if (daughter.isLeafNode()) {
                        daughterID = ((LeafNode)daughter).getUniqueLeafId();
                        if (daughterID != 0) {
                            daughterID |= DirectedGraphReader.LEAFNODE << 30;
                        }
                        out.writeInt(daughterID);
                        continue;
                    }
                    if (!daughter.isDirectedGraphNode()) continue;
                    daughterID = ((DirectedGraphNode)daughter).getUniqueGraphNodeID();
                    if (daughterID != 0) {
                        daughterID |= DirectedGraphReader.DIRECTEDGRAPHNODE << 30;
                    }
                    out.writeInt(daughterID);
                }
            }
            if (pw == null) continue;
            StringBuilder strNode = new StringBuilder("-" + id + " " + nodeDefinition);
            int n = decNode.getNumberOfDaugthers();
            for (int i = 0; i < n; ++i) {
                int daughterID;
                strNode.append(" ");
                Node daughter = decNode.getDaughter(i);
                if (daughter == null) {
                    strNode.append("0");
                    continue;
                }
                if (daughter.isDecisionNode()) {
                    daughterID = ((DecisionNode)daughter).getUniqueDecisionNodeId();
                    strNode.append("-").append(daughterID);
                    out.writeInt(daughterID);
                    continue;
                }
                if (daughter.isLeafNode()) {
                    daughterID = ((LeafNode)daughter).getUniqueLeafId();
                    if (daughterID == 0) {
                        strNode.append("0");
                        continue;
                    }
                    strNode.append("id").append(daughterID);
                    continue;
                }
                if (!daughter.isDirectedGraphNode()) continue;
                daughterID = ((DirectedGraphNode)daughter).getUniqueGraphNodeID();
                if (daughterID == 0) {
                    strNode.append("0");
                    continue;
                }
                strNode.append("DGN").append(daughterID);
            }
            pw.println(strNode.toString());
        }
    }

    private void printLeafNodes(DirectedGraph graph, DataOutput out, PrintWriter pw) throws IOException {
        for (LeafNode leaf : graph.getLeafNodes()) {
            if (leaf.getUniqueLeafId() == 0) continue;
            LeafNode.LeafType leafType = leaf.getLeafNodeType();
            if (leafType == LeafNode.LeafType.FeatureVectorLeafNode) {
                leafType = LeafNode.LeafType.IntArrayLeafNode;
            }
            if (out != null) {
                out.writeInt(leafType.ordinal());
            }
            if (pw != null) {
                pw.print("id" + leaf.getUniqueLeafId() + " " + (Object)((Object)leafType));
            }
            switch (leaf.getLeafNodeType()) {
                case IntArrayLeafNode: {
                    int[] data = ((LeafNode.IntArrayLeafNode)leaf).getIntData();
                    if (out != null) {
                        out.writeInt(data.length);
                    }
                    if (pw != null) {
                        pw.print(" " + data.length);
                    }
                    for (int i = 0; i < data.length; ++i) {
                        if (out != null) {
                            out.writeInt(data[i]);
                        }
                        if (pw == null) continue;
                        pw.print(" " + data[i]);
                    }
                    break;
                }
                case FloatLeafNode: {
                    float stddev = ((LeafNode.FloatLeafNode)leaf).getStDeviation();
                    float mean = ((LeafNode.FloatLeafNode)leaf).getMean();
                    if (out != null) {
                        out.writeFloat(stddev);
                        out.writeFloat(mean);
                    }
                    if (pw == null) break;
                    pw.print(" 1 " + stddev + " " + mean);
                    break;
                }
                case IntAndFloatArrayLeafNode: 
                case StringAndFloatLeafNode: {
                    int[] data1 = ((LeafNode.IntAndFloatArrayLeafNode)leaf).getIntData();
                    float[] floats = ((LeafNode.IntAndFloatArrayLeafNode)leaf).getFloatData();
                    if (out != null) {
                        out.writeInt(data1.length);
                    }
                    if (pw != null) {
                        pw.print(" " + data1.length);
                    }
                    for (int i = 0; i < data1.length; ++i) {
                        if (out != null) {
                            out.writeInt(data1[i]);
                            out.writeFloat(floats[i]);
                        }
                        if (pw == null) continue;
                        pw.print(" " + data1[i] + " " + floats[i]);
                    }
                    break;
                }
                case FeatureVectorLeafNode: {
                    FeatureVector[] fv = ((LeafNode.FeatureVectorLeafNode)leaf).getFeatureVectors();
                    if (out != null) {
                        out.writeInt(fv.length);
                    }
                    if (pw != null) {
                        pw.print(" " + fv.length);
                    }
                    for (int i = 0; i < fv.length; ++i) {
                        if (out != null) {
                            out.writeInt(fv[i].getUnitIndex());
                        }
                        if (pw == null) continue;
                        pw.print(" " + fv[i].getUnitIndex());
                    }
                    break;
                }
                case PdfLeafNode: {
                    throw new IllegalArgumentException("Writing of pdf leaf nodes not yet implemented");
                }
            }
            if (pw == null) continue;
            pw.println();
        }
    }

    private void printDirectedGraphNodes(DirectedGraph graph, DataOutput out, PrintWriter pw) throws IOException {
        for (DirectedGraphNode g : graph.getDirectedGraphNodes()) {
            DecisionNode d;
            int decID;
            int id = g.getUniqueGraphNodeID();
            if (id == 0) continue;
            Node leaf = g.getLeafNode();
            int leafID = 0;
            int leafNodeType = 0;
            if (leaf != null) {
                if (leaf instanceof LeafNode) {
                    leafID = ((LeafNode)leaf).getUniqueLeafId();
                    leafNodeType = DirectedGraphReader.LEAFNODE;
                } else if (leaf instanceof DirectedGraphNode) {
                    leafID = ((DirectedGraphNode)leaf).getUniqueGraphNodeID();
                    leafNodeType = DirectedGraphReader.DIRECTEDGRAPHNODE;
                } else {
                    throw new IllegalArgumentException("Unexpected leaf type: " + leaf.getClass());
                }
            }
            int n = decID = (d = g.getDecisionNode()) != null ? d.getUniqueDecisionNodeId() : 0;
            if (out != null) {
                int outLeafId = leafID == 0 ? 0 : leafID | leafNodeType << 30;
                out.writeInt(outLeafId);
                int outDecId = decID == 0 ? 0 : decID | DirectedGraphReader.DECISIONNODE << 30;
                out.writeInt(outDecId);
            }
            if (pw == null) continue;
            pw.print("DGN" + id);
            if (leafID == 0) {
                pw.print(" 0");
            } else if (leaf.isLeafNode()) {
                pw.print(" id" + leafID);
            } else {
                assert (leaf.isDirectedGraphNode());
                pw.print(" DGN" + leafID);
            }
            if (decID == 0) {
                pw.print(" 0");
            } else {
                pw.print(" -" + decID);
            }
            pw.println();
        }
    }
}

