/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import marytts.signalproc.adaptation.codebook.WeightedCodebookSpeakerItem;
import marytts.util.io.MaryRandomAccessFile;

public class WeightedCodebookEntry {
    public WeightedCodebookSpeakerItem sourceItem;
    public WeightedCodebookSpeakerItem targetItem;

    public WeightedCodebookEntry() {
        this(0, 0);
    }

    public WeightedCodebookEntry(int lpOrder, int mfccDimension) {
        this.allocate(lpOrder, mfccDimension);
    }

    public WeightedCodebookEntry(double[] sourceLsfs, double[] targetLsfs, double[] sourceMfccs, double[] targetMfccs) {
        int lsfDimension = 0;
        int mfccDimension = 0;
        if (sourceLsfs != null && targetLsfs != null) {
            assert (sourceLsfs.length == targetLsfs.length);
            lsfDimension = sourceLsfs.length;
        }
        if (sourceMfccs != null && targetMfccs != null) {
            assert (sourceMfccs.length == targetMfccs.length);
            mfccDimension = sourceMfccs.length;
        }
        this.allocate(lsfDimension, mfccDimension);
        if (lsfDimension > 0) {
            this.setLsfs(sourceLsfs, targetLsfs);
        }
        if (mfccDimension > 0) {
            this.setMfccs(sourceMfccs, targetMfccs);
        }
    }

    public void allocate(int lpOrder, int mfccDimension) {
        if (lpOrder > 0 || mfccDimension > 0) {
            this.sourceItem = new WeightedCodebookSpeakerItem(lpOrder, mfccDimension);
            this.targetItem = new WeightedCodebookSpeakerItem(lpOrder, mfccDimension);
        } else {
            this.sourceItem = null;
            this.targetItem = null;
        }
    }

    public void setLsfs(double[] srcLsfs, double[] tgtLsfs) {
        this.sourceItem.setLsfs(srcLsfs);
        this.targetItem.setLsfs(tgtLsfs);
    }

    public void setMfccs(double[] srcMfccs, double[] tgtMfccs) {
        this.sourceItem.setMfccs(srcMfccs);
        this.targetItem.setMfccs(tgtMfccs);
    }

    public void write(MaryRandomAccessFile ler) {
        if (this.sourceItem != null && this.targetItem != null) {
            this.sourceItem.write(ler);
            this.targetItem.write(ler);
        }
    }

    public void read(MaryRandomAccessFile ler, int lpOrder, int mfccDimension) {
        this.sourceItem = new WeightedCodebookSpeakerItem();
        this.sourceItem.read(ler, lpOrder, mfccDimension);
        this.targetItem = new WeightedCodebookSpeakerItem();
        this.targetItem.read(ler, lpOrder, mfccDimension);
    }
}

