/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import marytts.machinelearning.KMeansClusteringTrainer;
import marytts.machinelearning.KMeansClusteringTrainerParams;
import marytts.signalproc.analysis.EnergyAnalyser_dB;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.window.RectWindow;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;
import marytts.util.string.PrintfFormat;

public class EnergyAnalyser
extends FrameBasedAnalyser<Double> {
    protected final int DEFAULT_MAXSIZE = 0x3FFFFFFF;
    protected double[] frameEnergies = new double[16384];
    protected int offset = 0;
    protected int len = 0;
    protected int maxSize;

    public EnergyAnalyser(DoubleDataSource signal, int framelength, int samplingRate) {
        super(signal, new RectWindow(framelength), framelength, samplingRate);
        this.maxSize = 0x3FFFFFFF;
    }

    public EnergyAnalyser(DoubleDataSource signal, int framelength, int frameShift, int samplingRate) {
        super(signal, new RectWindow(framelength), frameShift, samplingRate);
        this.maxSize = 0x3FFFFFFF;
    }

    public EnergyAnalyser(DoubleDataSource signal, int framelength, int frameShift, int samplingRate, int maxSize) {
        super(signal, new RectWindow(framelength), frameShift, samplingRate);
        this.maxSize = maxSize;
    }

    @Override
    public Double analyse(double[] frame) {
        if (frame.length != this.getFrameLengthSamples()) {
            throw new IllegalArgumentException("Expected frame of length " + this.getFrameLengthSamples() + ", got " + frame.length);
        }
        double totalEnergy = 0.0;
        for (int i = 0; i < frame.length; ++i) {
            totalEnergy += frame[i] * frame[i];
        }
        this.rememberFrameEnergy(totalEnergy);
        return new Double(totalEnergy);
    }

    protected void rememberFrameEnergy(double energy) {
        if (this.offset + this.len == this.frameEnergies.length) {
            if (this.len < this.maxSize) {
                assert (this.offset == 0);
                double[] dummy = new double[2 * this.frameEnergies.length];
                System.arraycopy(this.frameEnergies, 0, dummy, 0, this.frameEnergies.length);
                this.frameEnergies = dummy;
            } else if (this.frameEnergies.length < 2 * this.maxSize) {
                double[] dummy = new double[2 * this.maxSize];
                System.arraycopy(this.frameEnergies, this.offset, dummy, 0, this.len);
                this.frameEnergies = dummy;
                this.offset = 0;
            } else {
                System.arraycopy(this.frameEnergies, this.offset, this.frameEnergies, 0, this.len);
                this.offset = 0;
            }
        }
        assert (this.offset + this.len < this.frameEnergies.length);
        this.frameEnergies[this.offset + this.len] = energy;
        if (this.len < this.maxSize) {
            ++this.len;
        } else {
            ++this.offset;
        }
    }

    public double getMeanFrameEnergy() {
        double mean = 0.0;
        for (int i = 0; i < this.len; ++i) {
            mean += this.frameEnergies[this.offset + i];
        }
        return mean /= (double)this.len;
    }

    public double getMaxFrameEnergy() {
        if (this.len == 0) {
            return Double.NaN;
        }
        double max = this.frameEnergies[this.offset];
        for (int i = 0; i < this.len; ++i) {
            double val = this.frameEnergies[this.offset + i];
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public double getMinFrameEnergy() {
        if (this.len == 0) {
            return Double.NaN;
        }
        double min = this.frameEnergies[this.offset];
        for (int i = 0; i < this.len; ++i) {
            double val = this.frameEnergies[this.offset + i];
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public double[] getEnergyHistogram() {
        return this.getEnergyHistogram(100);
    }

    public double[] getEnergyHistogram(int nbins) {
        double[] histogram = new double[nbins];
        double min = this.getMinFrameEnergy();
        double range = this.getMaxFrameEnergy() - min;
        double binWidth = range / (double)nbins;
        double increment = 1.0 / (double)this.len;
        for (int i = 0; i < this.len; ++i) {
            int bin = (int)Math.floor((this.frameEnergies[this.offset + i] - min) / binWidth);
            if (bin == nbins) {
                bin = nbins - 1;
            }
            assert (bin < nbins);
            int n = bin;
            histogram[n] = histogram[n] + increment;
        }
        return histogram;
    }

    public double getSilenceCutoff() {
        double[] hist = this.getEnergyHistogram();
        double[] lowerHalf = new double[hist.length / 2];
        double[] upperHalf = new double[hist.length - lowerHalf.length];
        System.arraycopy(hist, 0, lowerHalf, 0, lowerHalf.length);
        System.arraycopy(hist, lowerHalf.length, upperHalf, 0, upperHalf.length);
        int silencePeak = MathUtils.findGlobalPeakLocation(lowerHalf);
        int speechPeak = lowerHalf.length + MathUtils.findGlobalPeakLocation(upperHalf);
        int iCutoff = silencePeak + (speechPeak - silencePeak) / 2;
        double minEnergy = this.getMinFrameEnergy();
        double maxEnergy = this.getMaxFrameEnergy();
        double cutoffEnergy = minEnergy + (maxEnergy - minEnergy) * (double)iCutoff / (double)hist.length;
        return cutoffEnergy;
    }

    public double getSilenceCutoffFromSortedEnergies(FrameBasedAnalyser.FrameAnalysisResult[] far, double silenceThreshold) {
        double[] energies = new double[far.length];
        for (int i = 0; i < far.length; ++i) {
            energies[i] = (Double)far[i].get();
        }
        MathUtils.quickSort(energies);
        int cutoffIndex = (int)Math.floor(silenceThreshold * (double)energies.length);
        while (energies[cutoffIndex] == 0.0) {
            if (++cutoffIndex <= energies.length - 1) continue;
            cutoffIndex = energies.length - 1;
            break;
        }
        double cutoffEnergy = energies[cutoffIndex];
        return cutoffEnergy;
    }

    public double[][] getSpeechStretches() {
        double minSilenceDur = Double.parseDouble(System.getProperty("signalproc.minsilenceduration", "0.1"));
        double minSpeechDur = Double.parseDouble(System.getProperty("signalproc.minspeechduration", "0.1"));
        FrameBasedAnalyser.FrameAnalysisResult<T>[] far = this.analyseAllFrames();
        double silenceCutoff = this.getSilenceCutoff();
        LinkedList<double[]> stretches = new LinkedList<double[]>();
        boolean withinSpeech = false;
        for (int i = 0; i < far.length; ++i) {
            double energy = (Double)far[i].get();
            if (energy > silenceCutoff) {
                if (withinSpeech) continue;
                boolean addStretch = false;
                if (stretches.size() == 0) {
                    addStretch = true;
                } else {
                    double silenceStart = ((double[])stretches.getLast())[1];
                    double silenceEnd = (double)i * this.getFrameLengthTime();
                    if (silenceEnd - silenceStart >= minSilenceDur) {
                        addStretch = true;
                    }
                }
                if (addStretch) {
                    double[] newStretch = new double[2];
                    newStretch[0] = (double)i * this.getFrameLengthTime();
                    stretches.add(newStretch);
                }
                withinSpeech = true;
                assert (stretches.size() > 0);
                continue;
            }
            if (!withinSpeech) continue;
            assert (stretches.size() > 0);
            double[] latestStretch = (double[])stretches.getLast();
            double speechStart = latestStretch[0];
            double speechEnd = (double)(i + 1) * this.getFrameLengthTime();
            if (speechEnd - speechStart >= minSpeechDur) {
                latestStretch[1] = speechEnd;
            } else {
                stretches.removeLast();
            }
            withinSpeech = false;
        }
        return (double[][])stretches.toArray((T[])new double[0][0]);
    }

    public double getSilenceCutoffFromKMeansClustering(double shiftFromMinimumEnergyCenter, int numClusters) {
        int i;
        FrameBasedAnalyser.FrameAnalysisResult<T>[] far = this.analyseAllFrames();
        double[][] energies = new double[far.length][1];
        for (i = 0; i < far.length; ++i) {
            energies[i][0] = (Double)far[i].get();
        }
        KMeansClusteringTrainerParams p = new KMeansClusteringTrainerParams();
        p.numClusters = numClusters;
        p.maxIterations = 40;
        KMeansClusteringTrainer t = new KMeansClusteringTrainer();
        t.train(energies, p);
        double[] meanEns = new double[p.numClusters];
        for (i = 0; i < p.numClusters; ++i) {
            meanEns[i] = t.clusters[i].meanVector[0];
            System.out.println(String.valueOf(meanEns[i]));
        }
        double minEnCenter = MathUtils.getMin(meanEns);
        double maxEnCenter = MathUtils.getMax(meanEns);
        double energyTh = minEnCenter + shiftFromMinimumEnergyCenter * (maxEnCenter - minEnCenter);
        return energyTh;
    }

    public double[][] getSpeechStretchesUsingEnergyHistory(int energyBufferLength, double speechStartLikelihood, double speechEndLikelihood, double shiftFromMinimumEnergyCenter, int numClusters) {
        int i;
        double minSilenceDur = Double.parseDouble(System.getProperty("signalproc.minsilenceduration", "0.3"));
        double minSpeechDur = Double.parseDouble(System.getProperty("signalproc.minspeechduration", "0.3"));
        FrameBasedAnalyser.FrameAnalysisResult<T>[] far = this.analyseAllFrames();
        double[][] energies = new double[far.length][1];
        for (i = 0; i < far.length; ++i) {
            energies[i][0] = (Double)far[i].get();
        }
        double[] isSpeechsAll = new double[far.length];
        Arrays.fill(isSpeechsAll, 0.0);
        KMeansClusteringTrainerParams p = new KMeansClusteringTrainerParams();
        p.numClusters = numClusters;
        p.maxIterations = 40;
        KMeansClusteringTrainer t = new KMeansClusteringTrainer();
        t.train(energies, p);
        double[] meanEns = new double[p.numClusters];
        boolean takeLog = true;
        if (this instanceof EnergyAnalyser_dB) {
            takeLog = false;
        }
        for (i = 0; i < p.numClusters; ++i) {
            meanEns[i] = t.clusters[i].meanVector[0];
            if (!takeLog) continue;
            meanEns[i] = 10.0 * Math.log10(meanEns[i]);
        }
        double minEnCenter = MathUtils.getMin(meanEns);
        double maxEnCenter = MathUtils.getMax(meanEns);
        double energyTh = minEnCenter + shiftFromMinimumEnergyCenter * (maxEnCenter - minEnCenter);
        LinkedList<double[]> stretches = new LinkedList<double[]>();
        if (energyBufferLength > far.length) {
            energyBufferLength = far.length;
        }
        double[] energyBuffer = new double[energyBufferLength];
        int[] isSpeechs = new int[energyBufferLength];
        Arrays.fill(isSpeechs, 0);
        int bufferInd = 0;
        for (i = 0; i < energyBufferLength - 1; ++i) {
            energyBuffer[bufferInd] = energies[i][0];
            if (takeLog) {
                energyBuffer[bufferInd] = 10.0 * Math.log10(energyBuffer[bufferInd]);
            }
            ++bufferInd;
        }
        boolean isSpeechStarted = false;
        int tmpSpeechStartIndex = -1;
        int tmpSpeechEndIndex = -1;
        int prevStartIndex = -1;
        double speechStart = -1.0;
        double speechEnd = -1.0;
        for (i = energyBufferLength - 1; i < energies.length; ++i) {
            if (bufferInd > energyBufferLength - 1) {
                bufferInd = 0;
            }
            energyBuffer[bufferInd] = energies[i][0];
            if (takeLog) {
                energyBuffer[bufferInd] = 10.0 * Math.log10(energyBuffer[bufferInd]);
            }
            if (energyBuffer[bufferInd] > energyTh) {
                isSpeechs[bufferInd] = 1;
                isSpeechsAll[i] = 1.0;
            } else {
                isSpeechs[bufferInd] = 0;
            }
            int speechCount = 0;
            for (int j = 0; j < energyBufferLength; ++j) {
                if (isSpeechs[j] != 1) continue;
                ++speechCount;
            }
            double ratio = (double)speechCount / (double)energyBufferLength;
            if (!isSpeechStarted && ratio > speechStartLikelihood) {
                isSpeechStarted = true;
                tmpSpeechStartIndex = i - energyBufferLength;
                speechStart = Math.max(0.0, (double)tmpSpeechStartIndex * this.getFrameShiftTime() - 0.5 * this.getFrameLengthTime());
                tmpSpeechEndIndex = -1;
            } else if (isSpeechStarted && ratio <= speechEndLikelihood) {
                isSpeechStarted = false;
                tmpSpeechEndIndex = i;
                speechEnd = Math.max(0.0, (double)i * this.getFrameShiftTime() + 0.5 * this.getFrameLengthTime());
                double[] newStretch = new double[]{speechStart, speechEnd};
                stretches.add(newStretch);
                tmpSpeechStartIndex = -1;
            }
            ++bufferInd;
        }
        if (isSpeechStarted) {
            speechEnd = (double)(energies.length - 1) * this.getFrameShiftTime() + 0.5 * this.getFrameLengthTime();
            stretches.add(new double[]{speechStart, speechEnd});
        }
        double[][] speechStretches = (double[][])stretches.toArray((T[])new double[0][0]);
        boolean[] bRemoveds = new boolean[speechStretches.length];
        Arrays.fill(bRemoveds, false);
        double[] stretch1 = new double[2];
        double[] stretch2 = new double[2];
        for (i = speechStretches.length - 1; i > 0; --i) {
            if (!(speechStretches[i][0] - speechStretches[i - 1][1] < minSilenceDur)) continue;
            speechStretches[i - 1][1] = speechStretches[i][1];
            bRemoveds[i] = true;
        }
        for (i = 0; i < speechStretches.length; ++i) {
            if (bRemoveds[i] || !(speechStretches[i][1] - speechStretches[i][0] < minSpeechDur)) continue;
            bRemoveds[i] = true;
        }
        stretches.clear();
        for (i = 0; i < bRemoveds.length; ++i) {
            if (bRemoveds[i]) continue;
            double[] newStretch = new double[]{speechStretches[i][0], speechStretches[i][1]};
            stretches.add(newStretch);
        }
        return (double[][])stretches.toArray((T[])new double[0][0]);
    }

    public static void energySegmentation(String[] args) throws Exception {
        String wavDirectory = args[0];
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
        Date today = new Date();
        String currentDate = formatter.format(today);
        if (args.length > 0) {
            for (int file = 1; file < args.length; ++file) {
                int i;
                System.out.println("\nProcessing file: " + args[file]);
                AudioInputStream ais = AudioSystem.getAudioInputStream(new File(wavDirectory + "/" + args[file]));
                if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
                }
                if (ais.getFormat().getChannels() > 1) {
                    throw new IllegalArgumentException("Can only deal with mono audio signals");
                }
                int samplingRate = (int)ais.getFormat().getSampleRate();
                AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
                int framelength = (int)(0.01 * (double)samplingRate);
                EnergyAnalyser ea = new EnergyAnalyser((DoubleDataSource)signal, framelength, framelength, samplingRate);
                double[][] speechStretches1 = ea.getSpeechStretches();
                int energyBufferLength = 30;
                double speechStartLikelihood = 0.6;
                double speechEndLikelihood = 0.2;
                double shiftFromMinimumEnergyCenter = 0.1;
                int numClusters = 5;
                double[][] speechStretches2 = ea.getSpeechStretchesUsingEnergyHistory(energyBufferLength, speechStartLikelihood, speechEndLikelihood, shiftFromMinimumEnergyCenter, numClusters);
                System.out.println("Speech stretches1 in " + args[file] + ":");
                PrintfFormat format = new PrintfFormat("%.4f");
                for (i = 0; i < speechStretches1.length; ++i) {
                    System.out.println(format.sprintf(speechStretches1[i][0]) + " " + format.sprintf(speechStretches1[i][1]));
                }
                String fileNameNoExt = args[file];
                fileNameNoExt = fileNameNoExt.replace(".wav", "");
                String segmentationFileName = wavDirectory + "/" + fileNameNoExt + ".trs";
                PrintWriter toList = new PrintWriter(new FileWriter(segmentationFileName));
                toList.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Trans SYSTEM \"trans-14.dtd\">");
                toList.println("<Trans scribe=\"MARY (automatic)\" audio_filename=\"" + fileNameNoExt + "\" version=\"1\" version_date=\"" + currentDate + "\">");
                ais.getFrameLength();
                float duration = (float)ais.getFrameLength() / ais.getFormat().getFrameRate();
                toList.println("<Speakers>");
                toList.println("<Speaker id=\"spk1\" name=\"word\" check=\"no\" dialect=\"native\" accent=\"\" scope=\"local\"/>");
                toList.println("</Speakers>");
                toList.println("<Episode>");
                toList.println("<Section type=\"report\" startTime=\"0\" endTime=\"" + format.sprintf(duration) + "\">");
                toList.println("<Turn startTime=\"0\" endTime=\"" + format.sprintf(speechStretches2[0][0]) + "\">");
                toList.println("<Sync time=\"0\"/>");
                toList.println("");
                toList.println("</Turn>");
                System.out.println("Speech stretches2 in " + args[file] + ":");
                for (i = 0; i < speechStretches2.length; ++i) {
                    System.out.println(format.sprintf(speechStretches2[i][0]) + " " + format.sprintf(speechStretches2[i][1]));
                    toList.println("<Turn speaker=\"spk1\" startTime=\"" + format.sprintf(speechStretches2[i][0]) + "0\" endTime=\"" + format.sprintf(speechStretches2[i][1]) + "\">");
                    toList.println("<Sync time=\"" + format.sprintf(speechStretches2[i][0]) + "\"/>");
                    toList.println("");
                    toList.println("</Turn>");
                }
                toList.println("</Section>");
                toList.println("</Episode>");
                toList.println("</Trans>");
                toList.close();
                System.out.println("list of Speech stretches2 in " + segmentationFileName + "  num=" + i + "  dur=" + duration);
            }
        } else {
            System.out.println("No arguments provided: \n Usage: EnergyAnalyser wav_directory wav1 wav2 ... wavN");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            for (int file = 0; file < args.length; ++file) {
                int i;
                AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[file]));
                if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
                }
                if (ais.getFormat().getChannels() > 1) {
                    throw new IllegalArgumentException("Can only deal with mono audio signals");
                }
                int samplingRate = (int)ais.getFormat().getSampleRate();
                AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
                int framelength = (int)(0.01 * (double)samplingRate);
                EnergyAnalyser ea = new EnergyAnalyser((DoubleDataSource)signal, framelength, framelength, samplingRate);
                double[][] speechStretches1 = ea.getSpeechStretches();
                int energyBufferLength = 30;
                double speechStartLikelihood = 0.6;
                double speechEndLikelihood = 0.2;
                double shiftFromMinimumEnergyCenter = 0.1;
                int numClusters = 3;
                double[][] speechStretches2 = ea.getSpeechStretchesUsingEnergyHistory(energyBufferLength, speechStartLikelihood, speechEndLikelihood, shiftFromMinimumEnergyCenter, numClusters);
                System.out.println("Speech stretches1 in " + args[file] + ":");
                PrintfFormat format = new PrintfFormat("%.4f");
                for (i = 0; i < speechStretches1.length; ++i) {
                    System.out.println(format.sprintf(speechStretches1[i][0]) + " " + format.sprintf(speechStretches1[i][1]));
                }
                System.out.println("Speech stretches2 in " + args[file] + ":");
                for (i = 0; i < speechStretches2.length; ++i) {
                    System.out.println(format.sprintf(speechStretches2[i][0]) + " " + format.sprintf(speechStretches2[i][1]));
                }
            }
        } else {
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
            AudioInputStream input = null;
            try {
                TargetDataLine mic = (TargetDataLine)AudioSystem.getLine(info);
                mic.open(audioFormat);
                mic.start();
                input = new AudioInputStream(mic);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
            AudioDoubleDataSource signal = new AudioDoubleDataSource(input);
            int framelength = (int)(0.01 * (double)audioFormat.getSampleRate());
            EnergyAnalyser ea = new EnergyAnalyser((DoubleDataSource)signal, framelength, framelength, (int)audioFormat.getSampleRate());
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                System.out.println(ea.getSilenceCutoff());
            }
        }
    }
}

