/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import marytts.signalproc.analysis.FeatureFileHeader;

public class LsfFileHeader
extends FeatureFileHeader {
    public float preCoef;
    public int windowType;
    public boolean isBarkScaled;

    public LsfFileHeader() {
        this.preCoef = 0.0f;
        this.windowType = 1;
        this.isBarkScaled = false;
    }

    public LsfFileHeader(LsfFileHeader existingHeader) {
        super(existingHeader);
        this.preCoef = existingHeader.preCoef;
        this.windowType = existingHeader.windowType;
        this.isBarkScaled = existingHeader.isBarkScaled;
    }

    public LsfFileHeader(String lsfFile) {
        super(lsfFile);
        try {
            this.readHeader(lsfFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isIdenticalAnalysisParams(LsfFileHeader hdr) {
        boolean bRet = super.isIdenticalAnalysisParams(hdr);
        if (!bRet) {
            return false;
        }
        if (this.preCoef != hdr.preCoef) {
            return false;
        }
        if (this.windowType != hdr.windowType) {
            return false;
        }
        if (this.isBarkScaled != hdr.isBarkScaled) {
            return false;
        }
        return bRet;
    }

    @Override
    public void readHeader(DataInput stream) throws IOException {
        if (stream != null) {
            super.readHeader(stream);
            this.preCoef = stream.readFloat();
            this.windowType = stream.readInt();
            this.isBarkScaled = stream.readBoolean();
        }
    }

    @Override
    public void writeHeader(DataOutput ler) throws IOException {
        super.writeHeader(ler);
        ler.writeFloat(this.preCoef);
        ler.writeInt(this.windowType);
        ler.writeBoolean(this.isBarkScaled);
    }
}

